/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dns.DnsZoneManager;
import com.azure.resourcemanager.dns.fluent.DnsManagementClient;
import com.azure.resourcemanager.dns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.dns.implementation.DnsRecordSetsBaseImpl;
import com.azure.resourcemanager.dns.implementation.DnsZoneImpl;
import com.azure.resourcemanager.dns.implementation.PtrRecordSetImpl;
import com.azure.resourcemanager.dns.models.PtrRecordSet;
import com.azure.resourcemanager.dns.models.PtrRecordSets;
import com.azure.resourcemanager.dns.models.RecordType;
import reactor.core.publisher.Mono;

class PtrRecordSetsImpl
extends DnsRecordSetsBaseImpl<PtrRecordSet, PtrRecordSetImpl>
implements PtrRecordSets {
    PtrRecordSetsImpl(DnsZoneImpl dnsZone) {
        super(dnsZone, RecordType.PTR);
    }

    public PtrRecordSet getByName(String name) {
        return (PtrRecordSet)this.getByNameAsync(name).block();
    }

    public Mono<PtrRecordSet> getByNameAsync(String name) {
        return ((DnsManagementClient)((DnsZoneManager)this.parent().manager()).serviceClient()).getRecordSets().getAsync(this.dnsZone.resourceGroupName(), this.dnsZone.name(), name, this.recordType).map(this::wrapModel);
    }

    @Override
    protected PagedIterable<PtrRecordSet> listIntern(String recordSetNameSuffix, Integer pageSize) {
        return super.wrapList(((DnsManagementClient)((DnsZoneManager)this.parent().manager()).serviceClient()).getRecordSets().listByType(this.dnsZone.resourceGroupName(), this.dnsZone.name(), this.recordType, pageSize, recordSetNameSuffix, Context.NONE));
    }

    @Override
    protected PagedFlux<PtrRecordSet> listInternAsync(String recordSetNameSuffix, Integer pageSize) {
        return this.wrapPageAsync(((DnsManagementClient)((DnsZoneManager)this.parent().manager()).serviceClient()).getRecordSets().listByTypeAsync(this.dnsZone.resourceGroupName(), this.dnsZone.name(), this.recordType));
    }

    protected PtrRecordSetImpl wrapModel(RecordSetInner inner) {
        if (inner == null) {
            return null;
        }
        return new PtrRecordSetImpl(inner.name(), this.dnsZone, inner);
    }
}

