/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine;

import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.server.master.engine.WorkflowEventBusFireWorker;
import org.apache.dolphinscheduler.server.master.engine.WorkflowEventBusFireWorkers;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.runner.IWorkflowExecuteContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class WorkflowEventBusCoordinator
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowEventBusCoordinator.class);
    @Lazy
    @Autowired
    private WorkflowEventBusFireWorkers workflowEventBusFireWorkers;

    public void start() {
        this.workflowEventBusFireWorkers.start();
        log.info("WorkflowEventBusCoordinator started");
    }

    public void registerWorkflowEventBus(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        int workerSlot = this.calculateWorkflowEventBusFireWorkerSlot(workflowExecutionRunnable);
        WorkflowEventBusFireWorker workflowEventBusFireWorker = this.workflowEventBusFireWorkers.getWorker(workerSlot);
        workflowEventBusFireWorker.registerWorkflowEventBus(workflowExecutionRunnable);
    }

    public void unRegisterWorkflowEventBus(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        int workerSlot = this.calculateWorkflowEventBusFireWorkerSlot(workflowExecutionRunnable);
        WorkflowEventBusFireWorker workflowEventBusFireWorker = this.workflowEventBusFireWorkers.getWorker(workerSlot);
        workflowEventBusFireWorker.unRegisterWorkflowEventBus(workflowExecutionRunnable);
    }

    private int calculateWorkflowEventBusFireWorkerSlot(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        IWorkflowExecuteContext workflowExecuteContext = workflowExecutionRunnable.getWorkflowExecuteContext();
        WorkflowInstance workflowInstance = workflowExecuteContext.getWorkflowInstance();
        Integer workflowInstanceId = workflowInstance.getId();
        return workflowInstanceId % this.workflowEventBusFireWorkers.getWorkerSize();
    }

    @Override
    public void close() throws Exception {
        this.workflowEventBusFireWorkers.close();
    }
}

