/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.etcd;

import io.etcd.jetcd.Client;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.lease.LeaseKeepAliveResponse;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdKeepAliveLeaseManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EtcdKeepAliveLeaseManager.class);
    private final Map<String, Long> keyLeaseCache = new ConcurrentHashMap<String, Long>();
    private final Client client;

    EtcdKeepAliveLeaseManager(Client client) {
        this.client = client;
    }

    long getOrCreateKeepAliveLease(final String key, long timeToLive) {
        return this.keyLeaseCache.computeIfAbsent(key, $ -> {
            try {
                final long leaseId = ((LeaseGrantResponse)this.client.getLeaseClient().grant(timeToLive).get()).getID();
                this.client.getLeaseClient().keepAlive(leaseId, (StreamObserver)new StreamObserver<LeaseKeepAliveResponse>(){

                    public void onNext(LeaseKeepAliveResponse value) {
                    }

                    public void onError(Throwable t) {
                        log.error("Lease {} keep alive error, remove cache with key:{}", new Object[]{leaseId, key, t});
                        EtcdKeepAliveLeaseManager.this.keyLeaseCache.remove(key);
                    }

                    public void onCompleted() {
                        log.error("Lease {} keep alive complete, remove cache with key:{}", (Object)leaseId, (Object)key);
                        EtcdKeepAliveLeaseManager.this.keyLeaseCache.remove(key);
                    }
                });
                log.info("Lease {} keep alive create with key:{}", (Object)leaseId, (Object)key);
                return leaseId;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RegistryException("Failed to create lease key: " + key, (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new RegistryException("Failed to create lease key: " + key, (Throwable)e);
            }
        });
    }

    Optional<Long> getKeepAliveLease(String key) {
        return Optional.ofNullable(this.keyLeaseCache.get(key));
    }
}

