/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.LocalNetworkGatewayPropertiesFormat;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class LocalNetworkGatewayInner
extends Resource {
    @JsonProperty(value="properties", required=true)
    private LocalNetworkGatewayPropertiesFormat innerProperties = new LocalNetworkGatewayPropertiesFormat();
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(LocalNetworkGatewayInner.class);

    private LocalNetworkGatewayPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public LocalNetworkGatewayInner withId(String id) {
        this.id = id;
        return this;
    }

    public LocalNetworkGatewayInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public LocalNetworkGatewayInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public AddressSpace localNetworkAddressSpace() {
        return this.innerProperties() == null ? null : this.innerProperties().localNetworkAddressSpace();
    }

    public LocalNetworkGatewayInner withLocalNetworkAddressSpace(AddressSpace localNetworkAddressSpace) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LocalNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withLocalNetworkAddressSpace(localNetworkAddressSpace);
        return this;
    }

    public String gatewayIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().gatewayIpAddress();
    }

    public LocalNetworkGatewayInner withGatewayIpAddress(String gatewayIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LocalNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withGatewayIpAddress(gatewayIpAddress);
        return this;
    }

    public String fqdn() {
        return this.innerProperties() == null ? null : this.innerProperties().fqdn();
    }

    public LocalNetworkGatewayInner withFqdn(String fqdn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LocalNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withFqdn(fqdn);
        return this;
    }

    public BgpSettings bgpSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().bgpSettings();
    }

    public LocalNetworkGatewayInner withBgpSettings(BgpSettings bgpSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LocalNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withBgpSettings(bgpSettings);
        return this;
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model LocalNetworkGatewayInner"));
        }
        this.innerProperties().validate();
    }
}

