/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.AuthenticationType;
import com.azure.resourcemanager.sql.models.StorageKeyType;
import com.fasterxml.jackson.annotation.JsonProperty;

public class ExportRequest {
    @JsonProperty(value="storageKeyType", required=true)
    private StorageKeyType storageKeyType;
    @JsonProperty(value="storageKey", required=true)
    private String storageKey;
    @JsonProperty(value="storageUri", required=true)
    private String storageUri;
    @JsonProperty(value="administratorLogin", required=true)
    private String administratorLogin;
    @JsonProperty(value="administratorLoginPassword", required=true)
    private String administratorLoginPassword;
    @JsonProperty(value="authenticationType")
    private AuthenticationType authenticationType;
    private static final ClientLogger LOGGER = new ClientLogger(ExportRequest.class);

    public StorageKeyType storageKeyType() {
        return this.storageKeyType;
    }

    public ExportRequest withStorageKeyType(StorageKeyType storageKeyType) {
        this.storageKeyType = storageKeyType;
        return this;
    }

    public String storageKey() {
        return this.storageKey;
    }

    public ExportRequest withStorageKey(String storageKey) {
        this.storageKey = storageKey;
        return this;
    }

    public String storageUri() {
        return this.storageUri;
    }

    public ExportRequest withStorageUri(String storageUri) {
        this.storageUri = storageUri;
        return this;
    }

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ExportRequest withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ExportRequest withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public ExportRequest withAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public void validate() {
        if (this.storageKeyType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageKeyType in model ExportRequest"));
        }
        if (this.storageKey() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageKey in model ExportRequest"));
        }
        if (this.storageUri() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageUri in model ExportRequest"));
        }
        if (this.administratorLogin() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property administratorLogin in model ExportRequest"));
        }
        if (this.administratorLoginPassword() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property administratorLoginPassword in model ExportRequest"));
        }
    }
}

