/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.ElasticPoolActivitiesClient;
import com.azure.resourcemanager.sql.fluent.models.ElasticPoolActivityInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.ElasticPoolActivityListResult;
import reactor.core.publisher.Mono;

public final class ElasticPoolActivitiesClientImpl
implements ElasticPoolActivitiesClient {
    private final ElasticPoolActivitiesService service;
    private final SqlManagementClientImpl client;

    ElasticPoolActivitiesClientImpl(SqlManagementClientImpl client) {
        this.service = (ElasticPoolActivitiesService)RestProxy.create(ElasticPoolActivitiesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ElasticPoolActivityInner>> listByElasticPoolSinglePageAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (elasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByElasticPool(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, elasticPoolName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ElasticPoolActivityListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ElasticPoolActivityInner>> listByElasticPoolSinglePageAsync(String resourceGroupName, String serverName, String elasticPoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (elasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByElasticPool(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, elasticPoolName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ElasticPoolActivityListResult)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ElasticPoolActivityInner> listByElasticPoolAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        return new PagedFlux(() -> this.listByElasticPoolSinglePageAsync(resourceGroupName, serverName, elasticPoolName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ElasticPoolActivityInner> listByElasticPoolAsync(String resourceGroupName, String serverName, String elasticPoolName, Context context) {
        return new PagedFlux(() -> this.listByElasticPoolSinglePageAsync(resourceGroupName, serverName, elasticPoolName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ElasticPoolActivityInner> listByElasticPool(String resourceGroupName, String serverName, String elasticPoolName) {
        return new PagedIterable(this.listByElasticPoolAsync(resourceGroupName, serverName, elasticPoolName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ElasticPoolActivityInner> listByElasticPool(String resourceGroupName, String serverName, String elasticPoolName, Context context) {
        return new PagedIterable(this.listByElasticPoolAsync(resourceGroupName, serverName, elasticPoolName, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientE")
    private static interface ElasticPoolActivitiesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/elasticPoolActivity")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ElasticPoolActivityListResult>> listByElasticPool(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @PathParam(value="elasticPoolName") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

