/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.k8s;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Optional;
import org.apache.dolphinscheduler.api.k8s.K8sManager;
import org.apache.dolphinscheduler.dao.entity.K8sNamespace;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.yaml.snakeyaml.Yaml;

@Component
public class K8sClientService {
    private static Yaml yaml = new Yaml();
    @Autowired
    private K8sManager k8sManager;

    public void upsertNamespaceAndResourceToK8s(K8sNamespace k8sNamespace) {
        if (!this.checkNamespaceToK8s(k8sNamespace.getNamespace(), k8sNamespace.getClusterCode())) {
            throw new RuntimeException(String.format("namespace %s does not exist in k8s cluster, please create namespace in k8s cluster first", k8sNamespace.getNamespace()));
        }
    }

    public Optional<Namespace> deleteNamespaceToK8s(String name, Long clusterCode) {
        Optional<Namespace> result = this.getNamespaceFromK8s(name, clusterCode);
        if (result.isPresent()) {
            KubernetesClient client = this.k8sManager.getK8sClient(clusterCode);
            Namespace body = new Namespace();
            ObjectMeta meta = new ObjectMeta();
            meta.setNamespace(name);
            meta.setName(name);
            body.setMetadata(meta);
            client.namespaces().delete((Object)body);
        }
        return this.getNamespaceFromK8s(name, clusterCode);
    }

    private Optional<Namespace> getNamespaceFromK8s(String name, Long clusterCode) {
        NamespaceList listNamespace = (NamespaceList)this.k8sManager.getK8sClient(clusterCode).namespaces().list();
        Optional<Namespace> list = listNamespace.getItems().stream().filter(namespace -> namespace.getMetadata().getName().equals(name)).findFirst();
        return list;
    }

    private boolean checkNamespaceToK8s(String name, Long clusterCode) {
        Optional<Namespace> result = this.getNamespaceFromK8s(name, clusterCode);
        return result.isPresent();
    }
}

