/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.ServicePrincipalCredentialTypeProperties;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.azure.resourcemanager.datafactory.models.Credential;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="ServicePrincipal")
public final class ServicePrincipalCredential
extends Credential {
    @JsonProperty(value="typeProperties", required=true)
    private ServicePrincipalCredentialTypeProperties innerTypeProperties = new ServicePrincipalCredentialTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ServicePrincipalCredential.class);

    private ServicePrincipalCredentialTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public ServicePrincipalCredential withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ServicePrincipalCredential withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object servicePrincipalId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalId();
    }

    public ServicePrincipalCredential withServicePrincipalId(Object servicePrincipalId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ServicePrincipalCredentialTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalId(servicePrincipalId);
        return this;
    }

    public AzureKeyVaultSecretReference servicePrincipalKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalKey();
    }

    public ServicePrincipalCredential withServicePrincipalKey(AzureKeyVaultSecretReference servicePrincipalKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ServicePrincipalCredentialTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalKey(servicePrincipalKey);
        return this;
    }

    public Object tenant() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tenant();
    }

    public ServicePrincipalCredential withTenant(Object tenant) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ServicePrincipalCredentialTypeProperties();
        }
        this.innerTypeProperties().withTenant(tenant);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ServicePrincipalCredential"));
        }
        this.innerTypeProperties().validate();
    }
}

