/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.AzureMLLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="AzureML")
public final class AzureMLLinkedService
extends LinkedService {
    @JsonProperty(value="typeProperties", required=true)
    private AzureMLLinkedServiceTypeProperties innerTypeProperties = new AzureMLLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AzureMLLinkedService.class);

    private AzureMLLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AzureMLLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureMLLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AzureMLLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AzureMLLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object mlEndpoint() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().mlEndpoint();
    }

    public AzureMLLinkedService withMlEndpoint(Object mlEndpoint) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMlEndpoint(mlEndpoint);
        return this;
    }

    public SecretBase apiKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().apiKey();
    }

    public AzureMLLinkedService withApiKey(SecretBase apiKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withApiKey(apiKey);
        return this;
    }

    public Object updateResourceEndpoint() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().updateResourceEndpoint();
    }

    public AzureMLLinkedService withUpdateResourceEndpoint(Object updateResourceEndpoint) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUpdateResourceEndpoint(updateResourceEndpoint);
        return this;
    }

    public Object servicePrincipalId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalId();
    }

    public AzureMLLinkedService withServicePrincipalId(Object servicePrincipalId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalId(servicePrincipalId);
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalKey();
    }

    public AzureMLLinkedService withServicePrincipalKey(SecretBase servicePrincipalKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalKey(servicePrincipalKey);
        return this;
    }

    public Object tenant() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tenant();
    }

    public AzureMLLinkedService withTenant(Object tenant) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTenant(tenant);
        return this;
    }

    public Object encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public AzureMLLinkedService withEncryptedCredential(Object encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    public Object authentication() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authentication();
    }

    public AzureMLLinkedService withAuthentication(Object authentication) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthentication(authentication);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AzureMLLinkedService"));
        }
        this.innerTypeProperties().validate();
    }
}

