/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jpa.impl.transaction;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.interceptor.InvocationContext;
import jakarta.persistence.EntityManager;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.deltaspike.core.util.AnnotationUtils;
import org.apache.deltaspike.jpa.api.transaction.Transactional;
import org.apache.deltaspike.jpa.impl.entitymanager.EntityManagerMetadata;

@Dependent
public class TransactionStrategyHelper
implements Serializable {
    private static final long serialVersionUID = -6272327391611428125L;
    @Inject
    private BeanManager beanManager;

    public Set<Class<? extends Annotation>> resolveEntityManagerQualifiers(EntityManagerMetadata entityManagerMetadata, Class interceptedTargetClass) {
        HashSet<Class<? extends Annotation>> emQualifiers = new HashSet<Class<? extends Annotation>>();
        Class<? extends Annotation>[] qualifierClasses = entityManagerMetadata.getQualifiers();
        if (qualifierClasses == null || qualifierClasses.length == 1 && Any.class.equals(qualifierClasses[0])) {
            this.collectEntityManagerQualifiersOnClass(emQualifiers, interceptedTargetClass);
        } else {
            Collections.addAll(emQualifiers, qualifierClasses);
        }
        if (emQualifiers.isEmpty()) {
            emQualifiers.add(Default.class);
        }
        return emQualifiers;
    }

    private void collectEntityManagerQualifiersOnClass(Set<Class<? extends Annotation>> emQualifiers, Class target) {
        Field[] fields;
        for (Field field : fields = target.getDeclaredFields()) {
            if (!EntityManager.class.equals(field.getType()) || field.getAnnotation(Inject.class) == null) continue;
            boolean qualifierFound = false;
            Class<? extends Annotation> qualifier = this.getFirstQualifierAnnotation(field.getAnnotations());
            if (qualifier != null) {
                emQualifiers.add(qualifier);
                qualifierFound = true;
            }
            if (qualifierFound) continue;
            emQualifiers.add(Default.class);
        }
        Class superClass = target.getSuperclass();
        if (!Object.class.equals(superClass)) {
            this.collectEntityManagerQualifiersOnClass(emQualifiers, superClass);
        }
    }

    private Class<? extends Annotation> getFirstQualifierAnnotation(Annotation[] annotations) {
        for (Annotation ann : annotations) {
            if (!this.beanManager.isQualifier(ann.annotationType())) continue;
            return ann.annotationType();
        }
        return null;
    }

    EntityManagerMetadata createEntityManagerMetadata(InvocationContext context) {
        EntityManagerMetadata metadata = new EntityManagerMetadata();
        metadata.readFrom(context.getMethod().getDeclaringClass(), this.beanManager);
        metadata.readFrom(context.getMethod(), this.beanManager);
        return metadata;
    }

    protected Transactional extractTransactionalAnnotation(InvocationContext context) {
        Class<?> targetClass = context.getTarget() != null ? context.getTarget().getClass() : context.getMethod().getDeclaringClass();
        return (Transactional)AnnotationUtils.extractAnnotationFromMethodOrClass((BeanManager)this.beanManager, (Method)context.getMethod(), targetClass, Transactional.class);
    }
}

