/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jpa.impl.entitymanager;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.deltaspike.jpa.api.entitymanager.PersistenceUnitName;
import org.apache.deltaspike.jpa.spi.entitymanager.PersistenceConfigurationProvider;

@ApplicationScoped
public class EntityManagerFactoryProducer {
    private static final Logger LOG = Logger.getLogger(EntityManagerFactoryProducer.class.getName());
    @Inject
    private PersistenceConfigurationProvider persistenceConfigurationProvider;

    @Produces
    @Dependent
    @PersistenceUnitName(value="any")
    public EntityManagerFactory createEntityManagerFactoryForUnit(InjectionPoint injectionPoint) {
        PersistenceUnitName unitNameAnnotation = (PersistenceUnitName)injectionPoint.getAnnotated().getAnnotation(PersistenceUnitName.class);
        if (unitNameAnnotation == null) {
            LOG.warning("@PersistenceUnitName annotation could not be found at EntityManagerFactory injection point!");
            return null;
        }
        String unitName = unitNameAnnotation.value();
        Properties properties = this.persistenceConfigurationProvider.getEntityManagerFactoryConfiguration(unitName);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)unitName, (Map)properties);
        return emf;
    }

    public void disposeEntityManagerFactory(@Disposes @PersistenceUnitName(value="any") EntityManagerFactory emf) {
        if (emf.isOpen()) {
            emf.close();
        }
    }
}

