/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.source;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.source.transform.SourceTransformer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigurableClassSaxHandler<T>
extends DefaultHandler {
    private static Log log = LogFactory.getLog(DefaultHandler.class);
    private final UnitDescriptor unitDescriptor;
    private T configuredClass;
    private final String tagNameToProcess;
    private int level = 0;
    private String propertyName;
    private StringBuilder simplePropertyValue;
    private ArrayList<String> listPropertyValue;
    private StringBuilder listPropertyEntry;

    public ConfigurableClassSaxHandler(ConfigurationProvider configurationProvider, UnitDescriptor unitDescriptor, String tagNameToProcess) {
        if (configurationProvider == null) {
            throw new NullPointerException("configurationProvider must not be null");
        }
        if (unitDescriptor == null) {
            throw new NullPointerException("unitDescriptor must not be null");
        }
        if (tagNameToProcess == null) {
            throw new NullPointerException("tagNameToProcess must not be null");
        }
        this.unitDescriptor = unitDescriptor;
        this.tagNameToProcess = tagNameToProcess;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        if (this.level == 0) {
            ++this.level;
            if (!rawName.equals(this.tagNameToProcess)) throw new SAXException("Unknown element " + rawName);
            String className = attributes.getValue("class");
            if (className == null) {
                throw new SAXException("The attribute class must not be null for the element " + this.tagNameToProcess);
            }
            this.configuredClass = this.createConfiguredClass(className, this.unitDescriptor);
            return;
        } else if (this.level == 1) {
            ++this.level;
            this.propertyName = rawName;
            this.simplePropertyValue = new StringBuilder();
            return;
        } else {
            if (this.level != 2) throw new SAXException("unknown Element " + rawName);
            ++this.level;
            if (this.simplePropertyValue.length() > 0 && !StringUtils.isWhitespace((CharSequence)this.simplePropertyValue.toString())) {
                throw new SAXException("Cannot parse both text content and child elements  in element " + this.propertyName);
            }
            this.simplePropertyValue = null;
            if (this.listPropertyValue == null) {
                this.listPropertyValue = new ArrayList();
            }
            this.listPropertyEntry = new StringBuilder();
        }
    }

    @Override
    public void endElement(String uri, String localName, String rawName) throws SAXException {
        --this.level;
        if (this.level == 2) {
            this.listPropertyValue.add(this.listPropertyEntry.toString());
            this.listPropertyEntry = null;
        } else if (this.level == 1) {
            if (!PropertyUtils.isWriteable(this.configuredClass, (String)this.propertyName)) {
                throw new SAXException("No setter found for property " + this.propertyName + " in class " + this.configuredClass.getClass().getName());
            }
            Object propertyValue = this.simplePropertyValue != null ? this.simplePropertyValue.toString() : this.listPropertyValue;
            try {
                BeanUtils.copyProperty(this.configuredClass, (String)this.propertyName, (Object)propertyValue);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SAXException("error while setting Property " + this.propertyName + " for java transformer " + this.configuredClass.getClass().getName() + " with value " + propertyValue.toString(), e);
            }
            this.propertyName = null;
            propertyValue = null;
        } else if (this.level != 0) {
            throw new SAXException("endElemend reached Level " + this.level);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.simplePropertyValue != null) {
            for (int i = start; i < start + length; ++i) {
                this.simplePropertyValue.append(ch[i]);
            }
            return;
        }
        if (this.listPropertyEntry != null) {
            for (int i = start; i < start + length; ++i) {
                this.listPropertyEntry.append(ch[i]);
            }
            return;
        }
    }

    public T getConfiguredClass() {
        return this.configuredClass;
    }

    public boolean isFinished() {
        return this.configuredClass != null && this.level == 0;
    }

    private T createConfiguredClass(String className, UnitDescriptor unitDescriptor) throws SAXException {
        Object result;
        Class<?> transformerClass;
        try {
            ClassLoader classLoader = unitDescriptor.getClassLoader();
            if (classLoader == null) {
                classLoader = ConfigurableClassSaxHandler.class.getClassLoader();
            }
            transformerClass = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new SAXException("Error  while initializing a source transformer : Could not load class " + className, e);
        }
        catch (ExceptionInInitializerError e) {
            log.error((Object)("Error  while initializing a source transformer : Could not initialize class " + className + " : " + e.getMessage()));
            throw e;
        }
        catch (LinkageError e) {
            log.error((Object)("Error  while initializing a source transformer : Could not link class " + className + " : " + e.getMessage()));
            throw e;
        }
        try {
            Constructor<?> constructor = transformerClass.getConstructor(new Class[0]);
            result = constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new SAXException("Error  while instantiating a source transformer : The class " + className + " has no default constructor", e);
        }
        catch (ClassCastException e) {
            throw new SAXException("Error  while instantiating a source transformer : The class " + className + " is not an instance of " + SourceTransformer.class.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new SAXException("Error  while instantiating a source transformer : The constructor of class " + className + " could not be accessed", e);
        }
        catch (InvocationTargetException e) {
            throw new SAXException("Error  while instantiating a source transformer : The constructor of class " + className + " could not be called", e);
        }
        catch (InstantiationException e) {
            throw new SAXException("Error  while instantiating a source transformer : The class " + className + " represents an abstract class, an interface, an array class, a primitive type, or void, or the class has no parameterless constructor, or the instantiation fails for some other reason.", e);
        }
        catch (SecurityException e) {
            throw new SAXException("Error  while instantiating a source transformer : The security manager denies instantiation of the class " + className, e);
        }
        return (T)result;
    }
}

