/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsInserter;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsPacksChangedEvent;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsReaderOptions;
import org.eclipse.jgit.internal.storage.dfs.DfsReftable;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexWriterV1;
import org.eclipse.jgit.internal.storage.pack.PackBitmapIndexWriter;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.util.io.CountingOutputStream;

public abstract class DfsObjDatabase
extends ObjectDatabase {
    private static final PackList NO_PACKS = new PackList(new DfsPackFile[0], new DfsReftable[0]){

        @Override
        boolean dirty() {
            return true;
        }

        @Override
        void clearDirty() {
        }

        @Override
        public void markDirty() {
        }
    };
    private final AtomicReference<PackList> packList;
    private final DfsRepository repository;
    private DfsReaderOptions readerOptions;
    private Comparator<DfsPackDescription> packComparator;

    protected DfsObjDatabase(DfsRepository repository, DfsReaderOptions options) {
        this.repository = repository;
        this.packList = new AtomicReference<PackList>(NO_PACKS);
        this.readerOptions = options;
        this.packComparator = DfsPackDescription.objectLookupComparator();
    }

    public DfsReaderOptions getReaderOptions() {
        return this.readerOptions;
    }

    public void setPackComparator(Comparator<DfsPackDescription> packComparator) {
        this.packComparator = packComparator;
    }

    @Override
    public DfsReader newReader() {
        return new DfsReader(this);
    }

    @Override
    public ObjectInserter newInserter() {
        return new DfsInserter(this);
    }

    public DfsPackFile[] getPacks() throws IOException {
        return this.getPackList().packs;
    }

    public DfsReftable[] getReftables() throws IOException {
        return this.getPackList().reftables;
    }

    public PackList getPackList() throws IOException {
        return this.scanPacks(NO_PACKS);
    }

    protected DfsRepository getRepository() {
        return this.repository;
    }

    public DfsPackFile[] getCurrentPacks() {
        return this.getCurrentPackList().packs;
    }

    public DfsReftable[] getCurrentReftables() {
        return this.getCurrentPackList().reftables;
    }

    public PackList getCurrentPackList() {
        return this.packList.get();
    }

    public boolean has(AnyObjectId objectId, boolean avoidUnreachableObjects) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DfsReader or = this.newReader();){
            ((ObjectReader)or).setAvoidUnreachableObjects(avoidUnreachableObjects);
            return ((ObjectReader)or).has(objectId);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected abstract DfsPackDescription newPack(PackSource var1) throws IOException;

    protected DfsPackDescription newPack(PackSource source, long estimatedPackSize) throws IOException {
        DfsPackDescription pack = this.newPack(source);
        pack.setEstimatedPackSize(estimatedPackSize);
        return pack;
    }

    protected void commitPack(Collection<DfsPackDescription> desc, Collection<DfsPackDescription> replaces) throws IOException {
        this.commitPackImpl(desc, replaces);
        this.getRepository().fireEvent(new DfsPacksChangedEvent());
    }

    protected abstract void commitPackImpl(Collection<DfsPackDescription> var1, Collection<DfsPackDescription> var2) throws IOException;

    protected abstract void rollbackPack(Collection<DfsPackDescription> var1);

    protected abstract List<DfsPackDescription> listPacks() throws IOException;

    protected abstract ReadableChannel openFile(DfsPackDescription var1, PackExt var2) throws FileNotFoundException, IOException;

    protected abstract DfsOutputStream writeFile(DfsPackDescription var1, PackExt var2) throws IOException;

    void addPack(DfsPackFile newPack) throws IOException {
        DfsPackFile[] packs;
        PackListImpl n;
        PackList o;
        do {
            if ((o = this.packList.get()) == NO_PACKS) {
                o = this.scanPacks(o);
                DfsPackFile[] dfsPackFileArray = o.packs;
                int n2 = o.packs.length;
                int n3 = 0;
                while (n3 < n2) {
                    DfsPackFile p = dfsPackFileArray[n3];
                    if (p.key.equals(newPack.key)) {
                        return;
                    }
                    ++n3;
                }
            }
            packs = new DfsPackFile[1 + o.packs.length];
            packs[0] = newPack;
            System.arraycopy(o.packs, 0, packs, 1, o.packs.length);
        } while (!this.packList.compareAndSet(o, n = new PackListImpl(packs, o.reftables)));
    }

    void addReftable(DfsPackDescription add, Set<DfsPackDescription> remove) throws IOException {
        ArrayList<DfsReftable> tables;
        PackListImpl n;
        PackList o;
        do {
            int n2;
            if ((o = this.packList.get()) == NO_PACKS) {
                o = this.scanPacks(o);
                DfsReftable[] dfsReftableArray = o.reftables;
                n2 = o.reftables.length;
                int n3 = 0;
                while (n3 < n2) {
                    DfsReftable t = dfsReftableArray[n3];
                    if (t.getPackDescription().equals(add)) {
                        return;
                    }
                    ++n3;
                }
            }
            tables = new ArrayList<DfsReftable>(1 + o.reftables.length);
            DfsReftable[] dfsReftableArray = o.reftables;
            int n4 = o.reftables.length;
            n2 = 0;
            while (n2 < n4) {
                DfsReftable t = dfsReftableArray[n2];
                if (!remove.contains(t.getPackDescription())) {
                    tables.add(t);
                }
                ++n2;
            }
            tables.add(new DfsReftable(add));
        } while (!this.packList.compareAndSet(o, n = new PackListImpl(o.packs, tables.toArray(new DfsReftable[0]))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackList scanPacks(PackList original) throws IOException {
        PackList n;
        AtomicReference<PackList> atomicReference = this.packList;
        synchronized (atomicReference) {
            PackList o;
            do {
                if ((o = this.packList.get()) != original) {
                    return o;
                }
                n = this.scanPacksImpl(o);
                if (n != o) continue;
                return n;
            } while (!this.packList.compareAndSet(o, n));
        }
        this.getRepository().fireEvent(new DfsPacksChangedEvent());
        return n;
    }

    private PackList scanPacksImpl(PackList old) throws IOException {
        DfsBlockCache cache = DfsBlockCache.getInstance();
        Map<DfsPackDescription, DfsPackFile> packs = DfsObjDatabase.packMap(old);
        Map<DfsPackDescription, DfsReftable> reftables = DfsObjDatabase.reftableMap(old);
        List<DfsPackDescription> scanned = this.listPacks();
        Collections.sort(scanned, this.packComparator);
        ArrayList<DfsPackFile> newPacks = new ArrayList<DfsPackFile>(scanned.size());
        ArrayList<DfsReftable> newReftables = new ArrayList<DfsReftable>(scanned.size());
        boolean foundNew = false;
        for (DfsPackDescription dsc : scanned) {
            DfsPackFile oldPack = packs.remove(dsc);
            if (oldPack != null) {
                newPacks.add(oldPack);
            } else if (dsc.hasFileExt(PackExt.PACK)) {
                newPacks.add(this.createDfsPackFile(cache, dsc));
                foundNew = true;
            }
            DfsReftable oldReftable = reftables.remove(dsc);
            if (oldReftable != null) {
                newReftables.add(oldReftable);
                continue;
            }
            if (!dsc.hasFileExt(PackExt.REFTABLE)) continue;
            newReftables.add(new DfsReftable(cache, dsc));
            foundNew = true;
        }
        if (newPacks.isEmpty() && newReftables.isEmpty()) {
            return new PackListImpl(DfsObjDatabase.NO_PACKS.packs, DfsObjDatabase.NO_PACKS.reftables);
        }
        if (!foundNew) {
            old.clearDirty();
            return old;
        }
        Collections.sort(newReftables, this.reftableComparator());
        return new PackListImpl(newPacks.toArray(new DfsPackFile[0]), newReftables.toArray(new DfsReftable[0]));
    }

    protected DfsPackFile createDfsPackFile(DfsBlockCache cache, DfsPackDescription dsc) {
        return new DfsPackFile(cache, dsc);
    }

    private static Map<DfsPackDescription, DfsPackFile> packMap(PackList old) {
        HashMap<DfsPackDescription, DfsPackFile> forReuse = new HashMap<DfsPackDescription, DfsPackFile>();
        DfsPackFile[] dfsPackFileArray = old.packs;
        int n = old.packs.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile p = dfsPackFileArray[n2];
            if (!p.invalid()) {
                forReuse.put(p.desc, p);
            }
            ++n2;
        }
        return forReuse;
    }

    private static Map<DfsPackDescription, DfsReftable> reftableMap(PackList old) {
        HashMap<DfsPackDescription, DfsReftable> forReuse = new HashMap<DfsPackDescription, DfsReftable>();
        DfsReftable[] dfsReftableArray = old.reftables;
        int n = old.reftables.length;
        int n2 = 0;
        while (n2 < n) {
            DfsReftable p = dfsReftableArray[n2];
            if (!p.invalid()) {
                forReuse.put(p.desc, p);
            }
            ++n2;
        }
        return forReuse;
    }

    protected Comparator<DfsReftable> reftableComparator() {
        return Comparator.comparing(DfsReftable::getPackDescription, DfsPackDescription.reftableComparator());
    }

    protected void clearCache() {
        this.packList.set(NO_PACKS);
    }

    @Override
    public void close() {
        this.packList.set(NO_PACKS);
    }

    public PackBitmapIndexWriter getPackBitmapIndexWriter(DfsPackDescription pack) throws IOException {
        return (bitmaps, packDataChecksum) -> {
            Throwable throwable = null;
            Object var5_6 = null;
            try (DfsOutputStream out = this.writeFile(pack, PackExt.BITMAP_INDEX);){
                CountingOutputStream cnt = new CountingOutputStream(out);
                PackBitmapIndexWriterV1 iw = new PackBitmapIndexWriterV1(cnt);
                iw.write(bitmaps, packDataChecksum);
                pack.addFileExt(PackExt.BITMAP_INDEX);
                pack.setFileSize(PackExt.BITMAP_INDEX, cnt.getCount());
                pack.setBlockSize(PackExt.BITMAP_INDEX, out.blockSize());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        };
    }

    public static abstract class PackList {
        public final DfsPackFile[] packs;
        public final DfsReftable[] reftables;
        private long lastModified = -1L;

        PackList(DfsPackFile[] packs, DfsReftable[] reftables) {
            this.packs = packs;
            this.reftables = reftables;
        }

        public long getLastModified() {
            if (this.lastModified < 0L) {
                long max = 0L;
                DfsPackFile[] dfsPackFileArray = this.packs;
                int n = this.packs.length;
                int n2 = 0;
                while (n2 < n) {
                    DfsPackFile pack = dfsPackFileArray[n2];
                    max = Math.max(max, pack.getPackDescription().getLastModified());
                    ++n2;
                }
                this.lastModified = max;
            }
            return this.lastModified;
        }

        abstract boolean dirty();

        abstract void clearDirty();

        public abstract void markDirty();
    }

    private static final class PackListImpl
    extends PackList {
        private volatile boolean dirty;

        PackListImpl(DfsPackFile[] packs, DfsReftable[] reftables) {
            super(packs, reftables);
        }

        @Override
        boolean dirty() {
            return this.dirty;
        }

        @Override
        void clearDirty() {
            this.dirty = false;
        }

        @Override
        public void markDirty() {
            this.dirty = true;
        }
    }

    public static enum PackSource {
        INSERT,
        RECEIVE,
        COMPACT,
        GC,
        GC_REST,
        UNREACHABLE_GARBAGE;

        public static final Comparator<PackSource> DEFAULT_COMPARATOR;

        static {
            DEFAULT_COMPARATOR = new ComparatorBuilder().add(INSERT, RECEIVE).add(COMPACT).add(GC).add(GC_REST).add(UNREACHABLE_GARBAGE).build();
        }

        public static class ComparatorBuilder {
            private final Map<PackSource, Integer> ranks = new HashMap<PackSource, Integer>();
            private int counter;

            public ComparatorBuilder add(PackSource ... sources) {
                PackSource[] packSourceArray = sources;
                int n = sources.length;
                int n2 = 0;
                while (n2 < n) {
                    PackSource s = packSourceArray[n2];
                    this.ranks.put(s, this.counter);
                    ++n2;
                }
                ++this.counter;
                return this;
            }

            public Comparator<PackSource> build() {
                return new PackSourceComparator(this.ranks);
            }
        }

        private static class PackSourceComparator
        implements Comparator<PackSource> {
            private final Map<PackSource, Integer> ranks;

            private PackSourceComparator(Map<PackSource, Integer> ranks) {
                if (!ranks.keySet().equals(new HashSet<PackSource>(Arrays.asList(PackSource.values())))) {
                    throw new IllegalArgumentException();
                }
                this.ranks = new HashMap<PackSource, Integer>(ranks);
            }

            @Override
            public int compare(PackSource a, PackSource b) {
                return this.ranks.get((Object)a).compareTo(this.ranks.get((Object)b));
            }

            public String toString() {
                return Arrays.stream(PackSource.values()).map(s -> String.valueOf(s) + "=" + String.valueOf(this.ranks.get(s))).collect(Collectors.joining(", ", this.getClass().getSimpleName() + "{", "}"));
            }
        }
    }
}

