/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer.sql;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.option.OptionName;
import org.apache.torque.generator.source.transform.SourceTransformer;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.templates.TemplateOptionName;
import org.apache.torque.templates.TorqueSchemaIdMethod;
import org.apache.torque.templates.model.Column;
import org.apache.torque.templates.model.Database;
import org.apache.torque.templates.model.EnumValue;
import org.apache.torque.templates.model.ForeignKey;
import org.apache.torque.templates.model.Index;
import org.apache.torque.templates.model.IndexColumn;
import org.apache.torque.templates.model.Reference;
import org.apache.torque.templates.model.Table;
import org.apache.torque.templates.model.Unique;
import org.apache.torque.templates.model.UniqueColumn;
import org.apache.torque.templates.platform.Platform;
import org.apache.torque.templates.platform.PlatformFactory;
import org.apache.torque.templates.transformer.IncludeSchemaTransformer;
import org.apache.torque.templates.transformer.LoadExternalSchemaTransformer;
import org.apache.torque.templates.transformer.SchemaTypeHelper;
import org.apache.torque.templates.transformer.om.OMColumnJavaTransformer;
import org.apache.torque.templates.transformer.om.OMTransformer;
import org.apache.torque.templates.typemapping.SchemaType;
import org.apache.torque.templates.typemapping.SqlType;
import org.apache.torque.templates.typemapping.TypeMap;

public class SQLModelTransformer
implements SourceTransformer {
    private static final LoadExternalSchemaTransformer loadExternalSchemaTransformer = new LoadExternalSchemaTransformer();
    private static final IncludeSchemaTransformer includeSchemaTransformer = new IncludeSchemaTransformer();

    public Database transform(Object databaseModel, ControllerState controllerState) throws SourceTransformerException {
        Database database = (Database)databaseModel;
        OMTransformer.setRootDatabaseName(database);
        includeSchemaTransformer.transform(database, controllerState);
        loadExternalSchemaTransformer.transform(database, controllerState);
        TemplateOptionName.checkRequiredOptions(controllerState, TemplateOptionName.DATABASE);
        for (Table table : database.allTables) {
            this.transformTable(table, database, controllerState);
        }
        this.addDatabaseSchemaElements(database, controllerState);
        return database;
    }

    /*
     * WARNING - void declaration
     */
    public void transformTable(Table table, Database database, ControllerState controllerState) throws SourceTransformerException {
        table.unqualifiedName = table.name;
        if (StringUtils.contains((CharSequence)table.name, (CharSequence)".")) {
            table.unqualifiedName = table.name.substring(table.name.indexOf(".") + 1);
        }
        if (table.idMethod == null) {
            if (database.defaultIdMethod == null) {
                throw new SourceTransformerException("idMethod is not set on table " + table.name + " and defaultIdMethod is not set on database");
            }
            table.idMethod = database.defaultIdMethod;
        }
        if (table.primaryKeyConstraintName == null) {
            table.primaryKeyConstraintName = table.unqualifiedName + "_PK";
        }
        if (StringUtils.isBlank((CharSequence)table.sequenceName)) {
            if (!table.idMethodParameterList.isEmpty()) {
                table.sequenceName = table.idMethodParameterList.get((int)0).value;
            }
            if (StringUtils.isBlank((CharSequence)table.sequenceName)) {
                table.sequenceName = table.name + "_SEQ";
            }
        }
        for (Column column : table.columnList) {
            if (!Boolean.TRUE.equals(column.primaryKey)) continue;
            table.primaryKeyList.add(column);
        }
        StringBuilder primaryKeyColumnNames = new StringBuilder();
        for (Column primaryKeyColumn : table.primaryKeyList) {
            if (primaryKeyColumnNames.length() != 0) {
                primaryKeyColumnNames.append(", ");
            }
            primaryKeyColumnNames.append(primaryKeyColumn.name);
        }
        table.primaryKeyColumnNames = primaryKeyColumnNames.toString();
        Platform platform = this.getPlatform(controllerState);
        boolean hasUniqueSize = platform.hasUniqueConstraintSize();
        int uniqueIndex = 1;
        for (Unique unique : table.uniqueList) {
            if (unique.name == null) {
                unique.name = table.name + "_UQ_" + uniqueIndex;
            }
            StringBuilder uniqueColumnNames = new StringBuilder();
            StringBuilder uniqueColumnSizes = new StringBuilder();
            for (UniqueColumn uniqueColumn : unique.uniqueColumnList) {
                if (uniqueColumnNames.length() != 0) {
                    uniqueColumnNames.append(", ");
                }
                uniqueColumnNames.append(uniqueColumn.name);
                if (!hasUniqueSize) continue;
                if (uniqueColumnSizes.length() != 0) {
                    uniqueColumnSizes.append(", ");
                }
                if (uniqueColumn.size == null) continue;
                uniqueColumnNames.append("(" + uniqueColumn.size + ")");
            }
            unique.uniqueColumnNames = uniqueColumnNames.toString();
            ++uniqueIndex;
        }
        int indexIndex = 1;
        for (Index index : table.indexList) {
            if (index.name == null) {
                index.name = table.name + "_IDX_" + indexIndex;
            }
            StringBuilder indexColumnNames = new StringBuilder();
            for (IndexColumn indexColumn : index.indexColumnList) {
                if (indexColumnNames.length() != 0) {
                    indexColumnNames.append(", ");
                }
                indexColumnNames.append(indexColumn.name);
            }
            index.indexColumnNames = indexColumnNames.toString();
            ++indexIndex;
        }
        for (Column column : table.columnList) {
            if (column.ddlSql == null) {
                column.ddlSql = this.getDdlSql(column, controllerState);
            }
            if (column.enumConstraintName == null) {
                column.enumConstraintName = controllerState.getStringOption((OptionName)TemplateOptionName.SQL_ENUM_CONSTRAINT_NAME_PREFIX) + column.name + controllerState.getStringOption((OptionName)TemplateOptionName.SQL_ENUM_CONSTRAINT_NAME_SUFFIX);
            }
            column.generateEnum = !column.enumValueList.isEmpty();
            Iterator<EnumValue> enumValueIt = column.enumValueList.iterator();
            while (enumValueIt.hasNext()) {
                EnumValue enumValue = enumValueIt.next();
                this.transformEnumValue(enumValue, controllerState);
                enumValue.hasNext = enumValueIt.hasNext();
            }
        }
        boolean bl = true;
        for (ForeignKey foreignKey : table.foreignKeyList) {
            void var9_17;
            this.transformForeignKey(foreignKey, controllerState, (int)var9_17);
            ++var9_17;
        }
    }

    private String getDdlSql(Column column, ControllerState controllerState) throws SourceTransformerException {
        String autoIncrement;
        boolean primaryKey;
        SchemaType schemaType = SchemaTypeHelper.getSchemaType(column, controllerState);
        SqlType domainType = SchemaTypeHelper.getDomain(column, controllerState);
        SqlType sqlType = SchemaTypeHelper.getSqlType(schemaType, domainType, controllerState, column.size, column.scale, column._default);
        Platform platform = this.getPlatform(controllerState);
        ArrayList<String> resultList = new ArrayList<String>();
        Object sqlTypeName = sqlType.getSqlTypeName();
        if (platform.hasSize((String)sqlTypeName)) {
            sqlTypeName = (String)sqlTypeName + sqlType.printSize(platform.getSizeSuffix((String)sqlTypeName));
        }
        if (platform.hasScale((String)sqlTypeName)) {
            sqlTypeName = (String)sqlTypeName + sqlType.printScale();
        }
        resultList.add((String)sqlTypeName);
        if (StringUtils.isNotEmpty((CharSequence)sqlType.getDefaultValue())) {
            resultList.add("default");
            if (SchemaType.DATE == schemaType || SchemaType.TIME == schemaType || SchemaType.TIMESTAMP == schemaType) {
                if (sqlType.getDefaultValue().startsWith("CURRENT_")) {
                    resultList.add(sqlType.getDefaultValue());
                } else {
                    Date defaultDate = OMColumnJavaTransformer.getDefaultValueAsDate(sqlType.getDefaultValue());
                    if (SchemaType.DATE == schemaType) {
                        resultList.add(platform.getDateString(defaultDate));
                    } else if (SchemaType.TIME == schemaType) {
                        resultList.add(platform.getTimeString(defaultDate));
                    } else {
                        resultList.add(platform.getTimestampString(defaultDate));
                    }
                }
            } else if (TypeMap.isTextType(schemaType)) {
                resultList.add(platform.quoteAndEscape(sqlType.getDefaultValue()));
            } else {
                resultList.add(sqlType.getDefaultValue());
            }
        }
        boolean isNotNull = (primaryKey = Boolean.TRUE.equals(column.primaryKey)) || Boolean.TRUE.equals(column.required);
        String isNotNullString = platform.getNullString(isNotNull);
        if (platform.createNotNullBeforeAutoincrement() && StringUtils.isNotEmpty((CharSequence)isNotNullString)) {
            resultList.add(isNotNullString);
        }
        if (primaryKey && TorqueSchemaIdMethod.NATIVE.getName().equals(column.parent.idMethod) && StringUtils.isNotEmpty((CharSequence)(autoIncrement = platform.getAutoIncrement()))) {
            resultList.add(autoIncrement);
        }
        if (!platform.createNotNullBeforeAutoincrement() && StringUtils.isNotEmpty((CharSequence)isNotNullString)) {
            resultList.add(isNotNullString);
        }
        return StringUtils.join(resultList.iterator(), (char)' ');
    }

    private Platform getPlatform(ControllerState controllerState) {
        Platform platform = PlatformFactory.getPlatformFor(controllerState.getStringOption((OptionName)TemplateOptionName.DATABASE));
        return platform;
    }

    private void transformForeignKey(ForeignKey foreignKey, ControllerState controllerState, int fkIndex) {
        if (foreignKey.name == null) {
            foreignKey.name = foreignKey.parent.name + "_FK_" + fkIndex;
        }
        StringBuilder localColumnNames = new StringBuilder();
        StringBuilder foreignColumnNames = new StringBuilder();
        for (Reference reference : foreignKey.referenceList) {
            if (localColumnNames.length() != 0) {
                localColumnNames.append(", ");
            }
            localColumnNames.append(reference.local);
            if (foreignColumnNames.length() != 0) {
                foreignColumnNames.append(", ");
            }
            foreignColumnNames.append(reference.foreign);
        }
        foreignKey.localColumnNames = localColumnNames.toString();
        foreignKey.foreignColumnNames = foreignColumnNames.toString();
    }

    private void addDatabaseSchemaElements(Database database, ControllerState controllerState) {
        Platform platform = this.getPlatform(controllerState);
        if (!platform.usesStandaloneSchema()) {
            return;
        }
        for (Table table : database.allTables) {
            String databaseSchema;
            if (!StringUtils.contains((CharSequence)table.name, (int)46) || database.schemaNameList.contains(databaseSchema = table.name.substring(0, table.name.indexOf(46)))) continue;
            database.schemaNameList.add(databaseSchema);
        }
    }

    private void transformEnumValue(EnumValue enumValue, ControllerState controllerState) throws SourceTransformerException {
        if (enumValue.sqlValue != null) {
            return;
        }
        Column column = enumValue.parent;
        SchemaType schemaType = SchemaTypeHelper.getSchemaType(column, controllerState);
        Platform platform = this.getPlatform(controllerState);
        if (SchemaType.DATE == schemaType || SchemaType.TIME == schemaType || SchemaType.TIMESTAMP == schemaType) {
            Date defaultDate = OMColumnJavaTransformer.getDefaultValueAsDate(enumValue.value);
            enumValue.sqlValue = SchemaType.DATE == schemaType ? platform.getDateString(defaultDate) : (SchemaType.TIME == schemaType ? platform.getTimeString(defaultDate) : platform.getTimestampString(defaultDate));
        } else {
            enumValue.sqlValue = TypeMap.isTextType(schemaType) ? platform.quoteAndEscape(enumValue.value) : enumValue.value;
        }
    }
}

