/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.httpsignature.SignatureValidator;
import org.apache.cxf.rs.security.httpsignature.TomitribeSignatureValidator;
import org.apache.cxf.rs.security.httpsignature.exception.MissingSignatureHeaderException;
import org.apache.cxf.rs.security.httpsignature.exception.MultipleSignatureHeaderException;
import org.apache.cxf.rs.security.httpsignature.provider.AlgorithmProvider;
import org.apache.cxf.rs.security.httpsignature.provider.KeyProvider;
import org.apache.cxf.rs.security.httpsignature.provider.SecurityProvider;
import org.apache.cxf.rs.security.httpsignature.utils.SignatureHeaderUtils;

public class MessageVerifier {
    private static final Logger LOG = LogUtils.getL7dLogger(MessageVerifier.class);
    private AlgorithmProvider algorithmProvider;
    private KeyProvider keyProvider;
    private SecurityProvider securityProvider;
    private final SignatureValidator signatureValidator;
    private final List<String> requiredHeaders;
    private boolean addDefaultRequiredHeaders = true;

    public MessageVerifier(KeyProvider keyProvider) {
        this(keyProvider, (List<String>)null);
    }

    public MessageVerifier(KeyProvider keyProvider, List<String> requiredHeaders) {
        this(keyProvider, null, keyId -> "rsa-sha256", requiredHeaders);
    }

    public MessageVerifier(KeyProvider keyProvider, AlgorithmProvider algorithmProvider) {
        this(keyProvider, null, algorithmProvider, Collections.emptyList());
    }

    public MessageVerifier(KeyProvider keyProvider, SecurityProvider securityProvider, AlgorithmProvider algorithmProvider) {
        this(keyProvider, securityProvider, algorithmProvider, Collections.emptyList());
    }

    public MessageVerifier(KeyProvider keyProvider, SecurityProvider securityProvider, AlgorithmProvider algorithmProvider, List<String> requiredHeaders) {
        this(keyProvider, securityProvider, algorithmProvider, requiredHeaders, new TomitribeSignatureValidator());
    }

    public MessageVerifier(KeyProvider keyProvider, SecurityProvider securityProvider, AlgorithmProvider algorithmProvider, List<String> requiredHeaders, SignatureValidator signatureValidator) {
        this.setkeyProvider(keyProvider);
        this.setSecurityProvider(securityProvider);
        this.setAlgorithmProvider(algorithmProvider);
        this.requiredHeaders = requiredHeaders == null ? Collections.emptyList() : requiredHeaders;
        this.signatureValidator = signatureValidator;
    }

    public final void setkeyProvider(KeyProvider provider) {
        this.keyProvider = Objects.requireNonNull(provider, "public key provider cannot be null");
    }

    public final void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public final void setAlgorithmProvider(AlgorithmProvider algorithmProvider) {
        this.algorithmProvider = Objects.requireNonNull(algorithmProvider, "algorithm provider cannot be null");
    }

    public void verifyMessage(Map<String, List<String>> messageHeaders, String method, String uri, Message m, byte[] messageBody) {
        SignatureHeaderUtils.inspectMessageHeaders(messageHeaders);
        this.inspectMissingSignatureHeader(messageHeaders);
        this.inspectMultipleSignatureHeaders(messageHeaders);
        List<String> signedHeaders = new ArrayList<String>(this.requiredHeaders);
        if (this.requiredHeaders.isEmpty() && m.getContextualProperty("rs.security.http.signature.in.headers") != null) {
            signedHeaders = CastUtils.cast((List)((List)m.getContextualProperty("rs.security.http.signature.in.headers")));
        }
        boolean requestor = MessageUtils.isRequestor((Message)m);
        if (this.addDefaultRequiredHeaders) {
            if (!requestor && !signedHeaders.contains("(request-target)")) {
                signedHeaders.add("(request-target)");
            }
            if (!signedHeaders.contains("digest") && (messageBody != null && messageBody.length > 0 || "POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method) || "PATCH".equalsIgnoreCase(method))) {
                signedHeaders.add("digest");
            }
        }
        Integer status = (Integer)m.get((Object)Message.RESPONSE_CODE);
        if (requestor && (status < 200 || status >= 300 || status == 204) || !requestor && ("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method))) {
            signedHeaders.remove("digest");
        }
        LOG.fine("Starting signature verification");
        this.signatureValidator.validate(messageHeaders, this.algorithmProvider, this.keyProvider, this.securityProvider, method, uri, signedHeaders);
        LOG.fine("Finished signature verification");
    }

    private void inspectMultipleSignatureHeaders(Map<String, List<String>> responseHeaders) {
        if (responseHeaders.get("Signature").size() > 1) {
            throw new MultipleSignatureHeaderException("there are multiple signature headers in request");
        }
    }

    private void inspectMissingSignatureHeader(Map<String, List<String>> responseHeaders) {
        if (!responseHeaders.containsKey("Signature")) {
            throw new MissingSignatureHeaderException("there is no signature header in request");
        }
    }

    public boolean isAddDefaultRequiredHeaders() {
        return this.addDefaultRequiredHeaders;
    }

    public void setAddDefaultRequiredHeaders(boolean addDefaultRequiredHeaders) {
        this.addDefaultRequiredHeaders = addDefaultRequiredHeaders;
    }
}

