/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.auth.signatures;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.List;
import org.tomitribe.auth.signatures.Base64;
import org.tomitribe.auth.signatures.EC;
import org.tomitribe.auth.signatures.RSA;

public enum PEM {

    private static final String BEGIN_MARKER = "-----BEGIN ";

    public static PrivateKey readPrivateKey(InputStream is) throws InvalidKeySpecException, IOException {
        List<PEMObject> objects = PEM.readPEMObjects(is);
        for (PEMObject object : objects) {
            switch (object.getPEMObjectType()) {
                case PRIVATE_KEY_PKCS1: {
                    return RSA.privateKeyFromPKCS1(object.getDerBytes());
                }
                case PRIVATE_EC_KEY_PKCS8: {
                    return EC.privateKeyFromPKCS8(object.getDerBytes());
                }
                case PRIVATE_KEY_PKCS8: {
                    try {
                        return RSA.privateKeyFromPKCS8(object.getDerBytes());
                    }
                    catch (InvalidKeySpecException e) {
                        return EC.privateKeyFromPKCS8(object.getDerBytes());
                    }
                }
            }
        }
        throw new IllegalArgumentException("Found no private key");
    }

    public static PublicKey readPublicKey(InputStream is) throws InvalidKeySpecException, IOException {
        for (PEMObject object : PEM.readPEMObjects(is)) {
            switch (object.getPEMObjectType()) {
                case PUBLIC_KEY_X509: {
                    try {
                        return RSA.publicKeyFrom(object.getDerBytes());
                    }
                    catch (InvalidKeySpecException e) {
                        return EC.publicKeyFrom(object.getDerBytes());
                    }
                }
            }
        }
        throw new IllegalArgumentException("Found no public key");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<PEMObject> readPEMObjects(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            ArrayList<PEMObject> pemContents = new ArrayList<PEMObject>();
            boolean readingContent = false;
            String beginMarker = null;
            String endMarker = null;
            StringBuffer sb = null;
            while ((line = reader.readLine()) != null) {
                if (readingContent) {
                    if (line.contains(endMarker)) {
                        pemContents.add(new PEMObject(beginMarker, Base64.decodeBase64(sb.toString().getBytes("UTF-8"))));
                        readingContent = false;
                        continue;
                    }
                    sb.append(line.trim());
                    continue;
                }
                if (!line.contains(BEGIN_MARKER)) continue;
                readingContent = true;
                beginMarker = line.trim();
                endMarker = beginMarker.replace("BEGIN", "END");
                sb = new StringBuffer();
            }
            ArrayList<PEMObject> arrayList = pemContents;
            return arrayList;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    static enum PEMObjectType {
        PRIVATE_KEY_PKCS1("-----BEGIN RSA PRIVATE KEY-----"),
        PRIVATE_EC_KEY_PKCS8("-----BEGIN EC PRIVATE KEY-----"),
        PRIVATE_KEY_PKCS8("-----BEGIN PRIVATE KEY-----"),
        PUBLIC_KEY_X509("-----BEGIN PUBLIC KEY-----"),
        CERTIFICATE_X509("-----BEGIN CERTIFICATE-----");

        private final String beginMarker;

        public String getBeginMarker() {
            return this.beginMarker;
        }

        private PEMObjectType(String beginMarker) {
            this.beginMarker = beginMarker;
        }

        public static PEMObjectType fromBeginMarker(String beginMarker) {
            for (PEMObjectType e : PEMObjectType.values()) {
                if (!e.getBeginMarker().equals(beginMarker)) continue;
                return e;
            }
            return null;
        }
    }

    static class PEMObject {
        private final String beginMarker;
        private final byte[] derBytes;

        public PEMObject(String beginMarker, byte[] derBytes) {
            this.beginMarker = beginMarker;
            this.derBytes = (byte[])derBytes.clone();
        }

        public String getBeginMarker() {
            return this.beginMarker;
        }

        public byte[] getDerBytes() {
            return (byte[])this.derBytes.clone();
        }

        public PEMObjectType getPEMObjectType() {
            return PEMObjectType.fromBeginMarker(this.beginMarker);
        }
    }
}

