/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.util;

import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageListener;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.jms.util.JMSListenerContainer;
import org.apache.cxf.transport.jms.util.MessageListenerContainer;

public abstract class AbstractMessageListenerContainer
implements JMSListenerContainer {
    protected static final Logger LOG = LogUtils.getL7dLogger(MessageListenerContainer.class);
    protected Connection connection;
    protected Destination destination;
    protected MessageListener listenerHandler;
    protected boolean transacted;
    protected int acknowledgeMode = 1;
    protected String messageSelector;
    protected volatile boolean running;
    protected String durableSubscriptionName;
    protected boolean pubSubNoLocal;
    protected TransactionManager transactionManager;
    protected Properties jndiEnvironment;
    private Executor executor;
    private int concurrentConsumers = 1;
    private boolean internalExecutor;

    public Connection getConnection() {
        return this.connection;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
        if (this.transacted) {
            this.acknowledgeMode = 0;
        }
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    protected Executor getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(this.concurrentConsumers);
            this.internalExecutor = true;
        }
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setJndiEnvironment(Properties jndiEnvironment) {
        this.jndiEnvironment = jndiEnvironment;
    }

    public InitialContext createInitialContext() {
        if (this.jndiEnvironment != null) {
            try {
                return new InitialContext(this.jndiEnvironment);
            }
            catch (NamingException e) {
                LOG.log(Level.SEVERE, "Could not expose JNDI environment to JMS thread context", e);
            }
        }
        return null;
    }

    @Override
    public void stop() {
        if (this.executor == null || !this.internalExecutor) {
            return;
        }
        ExecutorService executorService = (ExecutorService)this.executor;
        executorService.shutdown();
        try {
            executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        executorService.shutdownNow();
        this.executor = null;
        this.internalExecutor = false;
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.durableSubscriptionName = durableSubscriptionName;
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }
}

