/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.CachedOutputStreamCleaner;

public final class DelayedCachedOutputStreamCleaner
implements CachedOutputStreamCleaner,
BusLifeCycleListener {
    private static final Logger LOG = LogUtils.getL7dLogger(DelayedCachedOutputStreamCleaner.class);
    private static final long MIN_DELAY = 2000L;
    private static final DelayedCleaner NOOP_CLEANER = new DelayedCleaner(){};
    private DelayedCleaner cleaner = NOOP_CLEANER;
    private boolean cleanupOnShutdown = true;

    @Resource
    public void setBus(Bus bus) {
        Number delayValue = null;
        BusLifeCycleManager busLifeCycleManager = null;
        Boolean cleanupOnShutdownValue = null;
        if (bus != null) {
            delayValue = (Number)bus.getProperty("bus.io.CachedOutputStreamCleaner.Delay");
            cleanupOnShutdownValue = (Boolean)bus.getProperty("bus.io.CachedOutputStreamCleaner.CleanOnShutdown");
            busLifeCycleManager = bus.getExtension(BusLifeCycleManager.class);
        }
        if (this.cleaner != null) {
            this.cleaner.close();
        }
        this.cleanupOnShutdown = cleanupOnShutdownValue != null ? cleanupOnShutdownValue : true;
        if (delayValue == null) {
            this.cleaner = new DelayedCleanerImpl(TimeUnit.MILLISECONDS.convert(30L, TimeUnit.MINUTES));
        } else {
            long value = delayValue.longValue();
            if (value > 0L && value >= 2000L) {
                this.cleaner = new DelayedCleanerImpl(value);
            } else {
                this.cleaner = NOOP_CLEANER;
                if (value != 0L) {
                    throw new IllegalArgumentException("The value of bus.io.CachedOutputStreamCleaner.Delay property is invalid: " + value + " (should be >= " + 2000L + ", 0 to deactivate)");
                }
            }
        }
        if (busLifeCycleManager != null) {
            busLifeCycleManager.registerLifeCycleListener(this);
        }
    }

    @Override
    public void register(Closeable closeable) {
        this.cleaner.register(closeable);
    }

    @Override
    public void unregister(Closeable closeable) {
        this.cleaner.unregister(closeable);
    }

    @Override
    public int size() {
        return this.cleaner.size();
    }

    @Override
    public void clean() {
        this.cleaner.clean();
    }

    @Override
    public void initComplete() {
    }

    @Override
    public void postShutdown() {
        if (this.cleanupOnShutdown) {
            this.forceClean();
            this.cleaner.close();
        }
    }

    @Override
    public void preShutdown() {
        if (!this.cleanupOnShutdown) {
            this.cleaner.close();
        }
    }

    public void forceClean() {
        this.cleaner.forceClean();
    }

    private static final class DelayedCloseable
    implements Delayed {
        private final Closeable closeable;
        private final long expireAt;

        DelayedCloseable(Closeable closeable, long delay) {
            this.closeable = closeable;
            this.expireAt = System.nanoTime() + delay;
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compare(this.expireAt, ((DelayedCloseable)o).expireAt);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expireAt - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        public int hashCode() {
            return Objects.hash(this.closeable);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DelayedCloseable other = (DelayedCloseable)obj;
            return Objects.equals(this.closeable, other.closeable);
        }
    }

    private static final class DelayedCleanerImpl
    implements DelayedCleaner {
        private final long delay;
        private final DelayQueue<DelayedCloseable> queue = new DelayQueue();
        private final Timer timer;

        DelayedCleanerImpl(long delay) {
            this.delay = delay;
            this.timer = new Timer("DelayedCachedOutputStreamCleaner", true);
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    this.clean();
                }
            }, 0L, Math.max(2000L, delay >> 1));
        }

        @Override
        public void register(Closeable closeable) {
            this.queue.put(new DelayedCloseable(closeable, this.delay));
        }

        @Override
        public void unregister(Closeable closeable) {
            this.queue.remove(new DelayedCloseable(closeable, this.delay));
        }

        @Override
        public void clean() {
            ArrayList<DelayedCloseable> closeables = new ArrayList<DelayedCloseable>();
            this.queue.drainTo(closeables);
            this.clean(closeables);
        }

        @Override
        public void forceClean() {
            this.clean(this.queue);
        }

        @Override
        public void close() {
            this.timer.cancel();
            this.queue.clear();
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        private void clean(Collection<DelayedCloseable> closeables) {
            Iterator<DelayedCloseable> iterator = closeables.iterator();
            while (iterator.hasNext()) {
                DelayedCloseable next = iterator.next();
                try {
                    iterator.remove();
                    LOG.warning("Unclosed (leaked?) stream detected: " + next.closeable.hashCode());
                    next.closeable.close();
                }
                catch (IOException | RuntimeException ex) {
                    LOG.warning("Unable to close (leaked?) stream: " + ex.getMessage());
                }
            }
        }
    }

    private static interface DelayedCleaner
    extends CachedOutputStreamCleaner,
    Closeable {
        @Override
        default public void register(Closeable closeable) {
        }

        @Override
        default public void unregister(Closeable closeable) {
        }

        @Override
        default public void close() {
        }

        @Override
        default public void clean() {
        }

        @Override
        default public int size() {
            return 0;
        }

        default public void forceClean() {
        }
    }
}

