/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.utils;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.weaver.Consumes;
import org.apache.commons.weaver.Produces;
import org.apache.commons.weaver.spi.WeaveLifecycleProvider;

public final class Providers {
    public static <P extends WeaveLifecycleProvider<?>> Iterable<P> sort(Iterable<P> providers) {
        return new SortWorker<P>().sort(providers);
    }

    private Providers() {
    }

    private static class SortWorker<P extends WeaveLifecycleProvider<?>> {
        private SortWorker() {
        }

        Iterable<P> sort(Iterable<P> providers) {
            Validate.noNullElements(providers);
            Map<Class<P>, Set<Class<P>>> dependencyMap = this.toDependencyMap(providers);
            LinkedHashSet<Class<? extends P>> order = new LinkedHashSet<Class<? extends P>>();
            HashMap<Class<P>, State> stateMap = new HashMap<Class<P>, State>();
            ArrayDeque<Class<? extends P>> visiting = new ArrayDeque<Class<? extends P>>();
            for (Class<P> type : dependencyMap.keySet()) {
                State state = (State)((Object)stateMap.get(type));
                if (state == null) {
                    this.tsort(type, dependencyMap, stateMap, visiting, order);
                    continue;
                }
                Validate.validState((state != State.VISITING ? 1 : 0) != 0, (String)"Unexpected node in visiting state: %s", (Object[])new Object[]{type});
            }
            return this.imposeOrder(providers, order);
        }

        private void tsort(Class<? extends P> root, Map<Class<? extends P>, Set<Class<? extends P>>> dependencyMap, Map<Class<? extends P>, State> stateMap, Deque<Class<? extends P>> visiting, Collection<Class<? extends P>> target) {
            stateMap.put(root, State.VISITING);
            visiting.push(root);
            for (Class<P> dependency : dependencyMap.get(root)) {
                State state = stateMap.get(dependency);
                if (state == State.VISITED) continue;
                Validate.validState((state == null ? 1 : 0) != 0, (String)"Circular dependency: %s of %s", (Object[])new Object[]{dependency.getName(), root.getName()});
                this.tsort(dependency, dependencyMap, stateMap, visiting, target);
            }
            Class<P> top = visiting.pop();
            Validate.validState((top == root ? 1 : 0) != 0, (String)"Stack out of balance: expected %s, found %s", (Object[])new Object[]{root.getName(), top.getName()});
            stateMap.put(root, State.VISITED);
            target.add(root);
        }

        private Class<? extends P>[] producedBy(Class<? extends P> providerClass) {
            Validate.notNull(providerClass);
            Produces produces = providerClass.getAnnotation(Produces.class);
            if (produces == null || produces.value().length == 0) {
                Class[] empty = ArrayUtils.EMPTY_CLASS_ARRAY;
                return empty;
            }
            Class<? extends WeaveLifecycleProvider<?>>[] result = produces.value();
            return result;
        }

        private Class<? extends P>[] consumedBy(Class<? extends P> providerClass) {
            Validate.notNull(providerClass);
            Consumes consumes = providerClass.getAnnotation(Consumes.class);
            if (consumes == null || consumes.value().length == 0) {
                Class[] empty = ArrayUtils.EMPTY_CLASS_ARRAY;
                return empty;
            }
            Class<? extends WeaveLifecycleProvider<?>>[] result = consumes.value();
            return result;
        }

        private Map<Class<? extends P>, Set<Class<? extends P>>> toDependencyMap(Iterable<P> providers) {
            HashMap<Class<P>, Set<Class<P>>> result = new HashMap<Class<P>, Set<Class<P>>>();
            for (WeaveLifecycleProvider provider : providers) {
                Class<?> type = provider.getClass();
                Collections.addAll(result.computeIfAbsent(type, k -> new HashSet()), this.consumedBy(type));
                for (Class<?> dependent : this.producedBy(type)) {
                    result.computeIfAbsent(dependent, k -> new HashSet()).add(type);
                }
            }
            return result;
        }

        private Iterable<P> imposeOrder(Iterable<P> providers, Iterable<Class<? extends P>> order) {
            LinkedHashSet<WeaveLifecycleProvider> result = new LinkedHashSet<WeaveLifecycleProvider>();
            for (Class<P> type : order) {
                for (WeaveLifecycleProvider provider : providers) {
                    if (!type.isInstance(provider)) continue;
                    result.add(provider);
                }
            }
            return Collections.unmodifiableSet(result);
        }
    }

    private static enum State {
        VISITING,
        VISITED;

    }
}

