/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import java.io.File;
import java.net.URL;
import java.time.Duration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.AbstractProviderTestConfig;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.ProviderTestSuite;
import org.apache.commons.vfs2.VfsTestUtils;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.ftps.FtpsFileProvider;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftps.NoProtocolSslConfigurationProxy;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.impl.DefaultFtpServer;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.ftpserver.ssl.SslConfigurationFactory;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.junit.jupiter.api.Assertions;

abstract class AbstractFtpsProviderTestCase
extends AbstractProviderTestConfig {
    private static final String LISTENER_NAME = "default";
    private static int socketPort;
    private static String connectionUri;
    private static FtpServer embeddedFtpServer;
    private static final String TEST_URI = "test.ftps.uri";
    private static final String USER_PROPS_RES = "org.apache.ftpsserver/users.properties";
    private static final String SERVER_JKS_RES = "org.apache.ftpsserver/ftpserver.jks";
    protected FileSystemOptions fileSystemOptions;

    AbstractFtpsProviderTestCase() {
    }

    static String getConnectionUri() {
        return connectionUri;
    }

    static int getSocketPort() {
        return socketPort;
    }

    static String getSystemTestUriOverride() {
        return System.getProperty(TEST_URI);
    }

    static synchronized void setUpClass(boolean implicit) throws FtpException {
        if (embeddedFtpServer != null) {
            return;
        }
        socketPort = 0;
        FtpServerFactory serverFactory = new FtpServerFactory();
        PropertiesUserManagerFactory propertiesUserManagerFactory = new PropertiesUserManagerFactory();
        URL userPropsResource = ClassLoader.getSystemClassLoader().getResource(USER_PROPS_RES);
        Assertions.assertNotNull((Object)userPropsResource, (String)USER_PROPS_RES);
        propertiesUserManagerFactory.setUrl(userPropsResource);
        UserManager userManager = propertiesUserManagerFactory.createUserManager();
        BaseUser user = (BaseUser)userManager.getUserByName("test");
        user.setHomeDirectory(VfsTestUtils.getTestDirectory());
        serverFactory.setUserManager(userManager);
        ListenerFactory listenerFactory = new ListenerFactory();
        listenerFactory.setPort(socketPort);
        URL serverJksResource = ClassLoader.getSystemClassLoader().getResource(SERVER_JKS_RES);
        Assertions.assertNotNull((Object)serverJksResource, (String)SERVER_JKS_RES);
        SslConfigurationFactory sllConfigFactory = new SslConfigurationFactory();
        File keyStoreFile = FileUtils.toFile((URL)serverJksResource);
        Assertions.assertTrue((boolean)keyStoreFile.exists(), (String)keyStoreFile.toString());
        sllConfigFactory.setKeystoreFile(keyStoreFile);
        sllConfigFactory.setKeystorePassword("password");
        SslConfiguration sslConfiguration = sllConfigFactory.createSslConfiguration();
        NoProtocolSslConfigurationProxy noProtocolSslConfigurationProxy = new NoProtocolSslConfigurationProxy(sslConfiguration);
        listenerFactory.setSslConfiguration((SslConfiguration)noProtocolSslConfigurationProxy);
        listenerFactory.setImplicitSsl(implicit);
        serverFactory.addListener(LISTENER_NAME, listenerFactory.createListener());
        embeddedFtpServer = serverFactory.createServer();
        embeddedFtpServer.start();
        Thread.yield();
        if (embeddedFtpServer.isStopped() || embeddedFtpServer.isSuspended()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        socketPort = ((DefaultFtpServer)embeddedFtpServer).getListener(LISTENER_NAME).getPort();
        connectionUri = "ftps://test:test@localhost:" + socketPort;
    }

    static synchronized void tearDownClass() {
        if (embeddedFtpServer != null) {
            embeddedFtpServer.suspend();
            embeddedFtpServer.stop();
            Thread.yield();
            int count = 10;
            while (count-- > 0 && !embeddedFtpServer.isStopped()) {
                int millis = 200;
                System.out.println(String.format("Waiting %,d milliseconds for %s to stop", 200, embeddedFtpServer));
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            embeddedFtpServer = null;
        }
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = AbstractFtpsProviderTestCase.getSystemTestUriOverride();
        if (uri == null) {
            uri = connectionUri;
        }
        return manager.resolveFile(uri, this.getFileSystemOptions());
    }

    protected FileSystemOptions getFileSystemOptions() {
        if (this.fileSystemOptions == null) {
            this.fileSystemOptions = new FileSystemOptions();
            this.setupOptions(FtpsFileSystemConfigBuilder.getInstance());
        }
        return this.fileSystemOptions;
    }

    protected abstract boolean isImplicit();

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("ftps", (FileProvider)new FtpsFileProvider());
    }

    protected void setupOptions(FtpsFileSystemConfigBuilder builder) {
        builder.setConnectTimeout(this.fileSystemOptions, Duration.ofSeconds(10L));
        builder.setDataTimeout(this.fileSystemOptions, Duration.ofSeconds(10L));
    }

    static final class FtpProviderTestSuite
    extends ProviderTestSuite {
        private final boolean implicit;

        public FtpProviderTestSuite(AbstractFtpsProviderTestCase providerConfig) throws Exception {
            super(providerConfig);
            this.implicit = providerConfig.isImplicit();
        }

        @Override
        protected void setUp() throws Exception {
            if (AbstractFtpsProviderTestCase.getSystemTestUriOverride() == null) {
                AbstractFtpsProviderTestCase.setUpClass(this.implicit);
            }
            super.setUp();
        }

        @Override
        protected void tearDown() throws Exception {
            try {
                super.tearDown();
            }
            finally {
                AbstractFtpsProviderTestCase.tearDownClass();
            }
        }
    }
}

