/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.util.Random;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SchurTransformer;
import org.junit.Assert;
import org.junit.Test;

public class SchurTransformerTest {
    private double[][] testSquare5 = new double[][]{{5.0, 4.0, 3.0, 2.0, 1.0}, {1.0, 4.0, 0.0, 3.0, 3.0}, {2.0, 0.0, 3.0, 0.0, 0.0}, {3.0, 2.0, 1.0, 2.0, 5.0}, {4.0, 2.0, 1.0, 4.0, 1.0}};
    private double[][] testSquare3 = new double[][]{{2.0, -1.0, 1.0}, {-1.0, 2.0, 1.0}, {1.0, -1.0, 2.0}};
    private double[][] testRandom = new double[][]{{0.68, -0.33, -0.27, -0.717, -0.687, 0.0259}, {-0.211, 0.536, 0.0268, 0.214, -0.198, 0.678}, {0.566, -0.444, 0.904, -0.967, -0.74, 0.225}, {0.597, 0.108, 0.832, -0.514, -0.782, -0.408}, {0.823, -0.0452, 0.271, -0.726, 0.998, 0.275}, {-0.605, 0.258, 0.435, 0.608, -0.563, 0.0486}};

    @Test
    public void testNonSquare() {
        try {
            new SchurTransformer(MatrixUtils.createRealMatrix((double[][])new double[3][2]));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NonSquareMatrixException nonSquareMatrixException) {
            // empty catch block
        }
    }

    @Test
    public void testAEqualPTPt() {
        this.checkAEqualPTPt(MatrixUtils.createRealMatrix((double[][])this.testSquare5));
        this.checkAEqualPTPt(MatrixUtils.createRealMatrix((double[][])this.testSquare3));
        this.checkAEqualPTPt(MatrixUtils.createRealMatrix((double[][])this.testRandom));
    }

    @Test
    public void testPOrthogonal() {
        this.checkOrthogonal(new SchurTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare5)).getP());
        this.checkOrthogonal(new SchurTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare3)).getP());
        this.checkOrthogonal(new SchurTransformer(MatrixUtils.createRealMatrix((double[][])this.testRandom)).getP());
    }

    @Test
    public void testPTOrthogonal() {
        this.checkOrthogonal(new SchurTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare5)).getPT());
        this.checkOrthogonal(new SchurTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare3)).getPT());
        this.checkOrthogonal(new SchurTransformer(MatrixUtils.createRealMatrix((double[][])this.testRandom)).getPT());
    }

    @Test
    public void testSchurForm() {
        this.checkSchurForm(new SchurTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare5)).getT());
        this.checkSchurForm(new SchurTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare3)).getT());
        this.checkSchurForm(new SchurTransformer(MatrixUtils.createRealMatrix((double[][])this.testRandom)).getT());
    }

    @Test
    public void testRandomData() {
        for (int run = 0; run < 100; ++run) {
            Random r = new Random(System.currentTimeMillis());
            int size = r.nextInt(20) + 4;
            double[][] data = new double[size][size];
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    data[i][j] = r.nextInt(100);
                }
            }
            RealMatrix m = MatrixUtils.createRealMatrix((double[][])data);
            RealMatrix s = this.checkAEqualPTPt(m);
            this.checkSchurForm(s);
        }
    }

    @Test
    public void testRandomDataNormalDistribution() {
        for (int run = 0; run < 100; ++run) {
            Random r = new Random(System.currentTimeMillis());
            NormalDistribution dist = new NormalDistribution(0.0, r.nextDouble() * 5.0);
            int size = r.nextInt(20) + 4;
            double[][] data = new double[size][size];
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    data[i][j] = dist.sample();
                }
            }
            RealMatrix m = MatrixUtils.createRealMatrix((double[][])data);
            RealMatrix s = this.checkAEqualPTPt(m);
            this.checkSchurForm(s);
        }
    }

    @Test
    public void testMath848() {
        double[][] data = new double[][]{{0.184944928, -0.0646971046, 0.0774755812, -0.0969651755, -0.0692648806, 0.3282344352, -0.0177423074, 0.206313634}, {-0.0742700134, -0.028906303, -0.001726946, -0.0375550146, -0.0487737922, -0.2616837868, -0.0821201295, -0.2530000167}, {0.2549910127, 0.0995733692, -9.718388E-4, 0.0149282808, 0.1791878897, -0.0823182816, 0.0582629256, 0.3219545182}, {-0.0694747557, -0.1880649148, -0.2740630911, 0.0720096468, -0.1800836914, -0.3518996425, 0.2486747833, 0.6257938167}, {0.0536360918, -0.1339297778, 0.2241579764, -0.0195327484, -0.0054103808, 0.0347564518, 0.5120802482, -0.0329902864}, {-0.5933332356, -0.2488721082, 0.2357173629, 0.0177285473, 0.0856630593, -0.35671263, -0.1600668126, -0.1010899621}, {-0.0514349819, -0.0854319435, 0.1125050061, 0.006345356, -0.2250000688, -0.220934309, 0.1964623477, -0.1512329924}, {0.0197395947, -0.1997170581, -0.1425959019, -0.274947791, -0.0969467073, 0.060368852, -0.2826905192, 0.1794315473}};
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])data);
        RealMatrix s = this.checkAEqualPTPt(m);
        this.checkSchurForm(s);
    }

    private RealMatrix checkAEqualPTPt(RealMatrix matrix) {
        SchurTransformer transformer = new SchurTransformer(matrix);
        RealMatrix p = transformer.getP();
        RealMatrix t = transformer.getT();
        RealMatrix pT = transformer.getPT();
        RealMatrix result = p.multiply(t).multiply(pT);
        double norm = result.subtract(matrix).getNorm();
        Assert.assertEquals((double)0.0, (double)norm, (double)1.0E-9);
        return t;
    }

    private void checkOrthogonal(RealMatrix m) {
        RealMatrix mTm = m.transpose().multiply(m);
        RealMatrix id = MatrixUtils.createRealIdentityMatrix((int)mTm.getRowDimension());
        Assert.assertEquals((double)0.0, (double)mTm.subtract(id).getNorm(), (double)1.0E-14);
    }

    private void checkSchurForm(RealMatrix m) {
        int rows = m.getRowDimension();
        int cols = m.getColumnDimension();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                if (i <= j + 1) continue;
                Assert.assertEquals((double)0.0, (double)m.getEntry(i, j), (double)1.0E-16);
            }
        }
    }

    private void checkMatricesValues(double[][] matrix, double[][] pRef, double[][] hRef) {
        SchurTransformer transformer = new SchurTransformer(MatrixUtils.createRealMatrix((double[][])matrix));
        RealMatrix p = transformer.getP();
        Assert.assertEquals((double)0.0, (double)p.subtract(MatrixUtils.createRealMatrix((double[][])pRef)).getNorm(), (double)1.0E-14);
        RealMatrix t = transformer.getT();
        Assert.assertEquals((double)0.0, (double)t.subtract(MatrixUtils.createRealMatrix((double[][])hRef)).getNorm(), (double)1.0E-14);
        Assert.assertTrue((p == transformer.getP() ? 1 : 0) != 0);
        Assert.assertTrue((t == transformer.getT() ? 1 : 0) != 0);
    }
}

