/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache.jmx;

import javax.cache.management.CacheStatisticsMXBean;
import org.apache.commons.jcs3.jcache.Statistics;

public class JCSCacheStatisticsMXBean
implements CacheStatisticsMXBean {
    private final Statistics statistics;

    public JCSCacheStatisticsMXBean(Statistics stats) {
        this.statistics = stats;
    }

    public void clear() {
        this.statistics.reset();
    }

    public long getCacheHits() {
        return this.statistics.getHits();
    }

    public float getCacheHitPercentage() {
        long hits = this.getCacheHits();
        if (hits == 0L) {
            return 0.0f;
        }
        return (float)hits / (float)this.getCacheGets() * 100.0f;
    }

    public long getCacheMisses() {
        return this.statistics.getMisses();
    }

    public float getCacheMissPercentage() {
        long misses = this.getCacheMisses();
        if (misses == 0L) {
            return 0.0f;
        }
        return (float)misses / (float)this.getCacheGets() * 100.0f;
    }

    public long getCacheGets() {
        return this.getCacheHits() + this.getCacheMisses();
    }

    public long getCachePuts() {
        return this.statistics.getPuts();
    }

    public long getCacheRemovals() {
        return this.statistics.getRemovals();
    }

    public long getCacheEvictions() {
        return this.statistics.getEvictions();
    }

    public float getAverageGetTime() {
        return this.averageTime(this.statistics.getTimeTakenForGets());
    }

    public float getAveragePutTime() {
        return this.averageTime(this.statistics.getTimeTakenForPuts());
    }

    public float getAverageRemoveTime() {
        return this.averageTime(this.statistics.getTimeTakenForRemovals());
    }

    private float averageTime(long timeTaken) {
        long gets = this.getCacheGets();
        if (timeTaken == 0L || gets == 0L) {
            return 0.0f;
        }
        return timeTaken / gets;
    }
}

