/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.issues;

import java.io.File;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.TestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Exec44Test {
    private final Executor exec = DefaultExecutor.builder().get();
    private final File testDir = new File("src/test/scripts");
    private final File foreverTestScript = TestUtil.resolveScriptFileForOS(this.testDir + "/forever");

    @Test
    public void testExec44() throws Exception {
        CommandLine cl = new CommandLine(this.foreverTestScript);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(-1L);
        this.exec.setWatchdog(watchdog);
        this.exec.execute(cl, (ExecuteResultHandler)resultHandler);
        Thread.sleep(5000L);
        Assertions.assertTrue((boolean)watchdog.isWatching(), (String)"The watchdog is watching the process");
        watchdog.destroyProcess();
        Assertions.assertTrue((boolean)watchdog.killedProcess(), (String)"The watchdog has killed the process");
        Assertions.assertFalse((boolean)watchdog.isWatching(), (String)"The watchdog is no longer watching any process");
    }
}

