/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.beanutils;

import org.apache.commons.configuration2.beanutils.BeanDeclaration;
import org.apache.commons.configuration2.beanutils.ConstructorArg;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestConstructorArg {
    @Test
    public void testForBeanDeclarationNull() {
        Assertions.assertThrows(NullPointerException.class, () -> ConstructorArg.forBeanDeclaration(null));
    }

    @Test
    public void testIsNestedBeanDeclarationFalse() {
        ConstructorArg arg = ConstructorArg.forValue((Object)"test");
        Assertions.assertFalse((boolean)arg.isNestedBeanDeclaration());
    }

    @Test
    public void testIsNestedBeanDeclarationTrue() {
        BeanDeclaration decl = (BeanDeclaration)Mockito.mock(BeanDeclaration.class);
        ConstructorArg arg = ConstructorArg.forBeanDeclaration((BeanDeclaration)decl);
        Assertions.assertTrue((boolean)arg.isNestedBeanDeclaration());
    }

    @Test
    public void testMatchesNoType() {
        ConstructorArg arg = ConstructorArg.forValue((Object)42);
        Assertions.assertTrue((boolean)arg.matches(String.class));
        Assertions.assertTrue((boolean)arg.matches(this.getClass()));
    }

    @Test
    public void testMatchesNull() {
        ConstructorArg arg = ConstructorArg.forValue((Object)0);
        Assertions.assertFalse((boolean)arg.matches(null));
    }

    @Test
    public void testMatchesWithType() {
        ConstructorArg arg = ConstructorArg.forValue((Object)"42", (String)Integer.TYPE.getName());
        Assertions.assertTrue((boolean)arg.matches(Integer.TYPE));
        Assertions.assertFalse((boolean)arg.matches(Integer.class));
        Assertions.assertFalse((boolean)arg.matches(String.class));
    }
}

