/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.io.ConfigurationLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.commons.logging.impl.NoOpLog;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestConfigurationLogger {
    private static final String MSG = "Interesting log output";

    @Test
    public void testAbstractConfigurationDefaultLogger() {
        BaseConfiguration config = new BaseConfiguration();
        Assertions.assertInstanceOf(NoOpLog.class, (Object)config.getLogger().getLog());
    }

    @Test
    public void testAbstractConfigurationSetLogger() {
        ConfigurationLogger logger = new ConfigurationLogger(this.getClass());
        BaseConfiguration config = new BaseConfiguration();
        config.setLogger(logger);
        Assertions.assertSame((Object)logger, (Object)config.getLogger());
    }

    @Test
    public void testAbstractConfigurationSetLoggerNull() {
        BaseConfiguration config = new BaseConfiguration();
        config.setLogger(new ConfigurationLogger(this.getClass()));
        config.setLogger(null);
        Assertions.assertInstanceOf(NoOpLog.class, (Object)config.getLogger().getLog());
    }

    @Test
    public void testDebug() {
        Log log = (Log)Mockito.mock(Log.class);
        ConfigurationLogger logger = new ConfigurationLogger(log);
        logger.debug(MSG);
        ((Log)Mockito.verify((Object)log)).debug((Object)MSG);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{log});
    }

    @Test
    public void testDummyLogger() {
        ConfigurationLogger logger = ConfigurationLogger.newDummyLogger();
        Assertions.assertInstanceOf(NoOpLog.class, (Object)logger.getLog());
    }

    @Test
    public void testError() {
        Log log = (Log)Mockito.mock(Log.class);
        ConfigurationLogger logger = new ConfigurationLogger(log);
        logger.error(MSG);
        ((Log)Mockito.verify((Object)log)).error((Object)MSG);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{log});
    }

    @Test
    public void testErrorWithException() {
        Log log = (Log)Mockito.mock(Log.class);
        Exception ex = new Exception("Test exception");
        ConfigurationLogger logger = new ConfigurationLogger(log);
        logger.error(MSG, (Throwable)ex);
        ((Log)Mockito.verify((Object)log)).error((Object)MSG, (Throwable)ex);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{log});
    }

    @Test
    public void testInfo() {
        Log log = (Log)Mockito.mock(Log.class);
        ConfigurationLogger logger = new ConfigurationLogger(log);
        logger.info(MSG);
        ((Log)Mockito.verify((Object)log)).info((Object)MSG);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{log});
    }

    @Test
    public void testInitNoLoggerClass() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConfigurationLogger((Class)null));
    }

    @Test
    public void testInitNoLoggerName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConfigurationLogger((String)null));
    }

    @Test
    public void testInitWithLoggerSpec() {
        ConfigurationLogger logger1 = new ConfigurationLogger(this.getClass().getName());
        ConfigurationLogger logger2 = new ConfigurationLogger(this.getClass());
        Assertions.assertNotNull((Object)logger1.getLog());
        if (logger1.getLog() instanceof Log4JLogger) {
            Assertions.assertEquals((Object)logger1.getLog(), (Object)logger2.getLog());
        }
    }

    @Test
    public void testIsDebugEnabled() {
        Log log = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)log.isDebugEnabled()).thenReturn((Object)Boolean.TRUE);
        ConfigurationLogger logger = new ConfigurationLogger(log);
        Assertions.assertTrue((boolean)logger.isDebugEnabled());
        ((Log)Mockito.verify((Object)log)).isDebugEnabled();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{log});
    }

    @Test
    public void testIsInfoEnabled() {
        Log log = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)log.isInfoEnabled()).thenReturn((Object)Boolean.FALSE);
        ConfigurationLogger logger = new ConfigurationLogger(log);
        Assertions.assertFalse((boolean)logger.isInfoEnabled());
        ((Log)Mockito.verify((Object)log)).isInfoEnabled();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{log});
    }

    @Test
    public void testSubClass() {
        final StringBuilder buf = new StringBuilder();
        ConfigurationLogger logger = new ConfigurationLogger(){

            public void info(String msg) {
                buf.append(msg);
            }
        };
        Assertions.assertNull((Object)logger.getLog());
        logger.info(MSG);
        Assertions.assertEquals((Object)MSG, (Object)buf.toString());
    }

    @Test
    public void testWarn() {
        Log log = (Log)Mockito.mock(Log.class);
        ConfigurationLogger logger = new ConfigurationLogger(log);
        logger.warn(MSG);
        ((Log)Mockito.verify((Object)log)).warn((Object)MSG);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{log});
    }

    @Test
    public void testWarnWithException() {
        Log log = (Log)Mockito.mock(Log.class);
        Exception ex = new Exception("Test exception");
        ConfigurationLogger logger = new ConfigurationLogger(log);
        logger.warn(MSG, (Throwable)ex);
        ((Log)Mockito.verify((Object)log)).warn((Object)MSG, (Throwable)ex);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{log});
    }
}

