/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.util.CelebornHadoopUtils$;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.shaded.com.google.common.base.Strings;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.net.TableMapping;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001\u0002\n\u0014\u0001yA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006a\u0001!\t!\r\u0005\nk\u0001\u0001\r\u00111A\u0005\nYB\u0011\"\u0011\u0001A\u0002\u0003\u0007I\u0011\u0002\"\t\u0013!\u0003\u0001\u0019!A!B\u00139\u0004bB%\u0001\u0001\u0004%IA\u0013\u0005\b\u001d\u0002\u0001\r\u0011\"\u0003P\u0011\u0019\t\u0006\u0001)Q\u0005\u0017\"9!\u000b\u0001b\u0001\n\u0013\u0019\u0006B\u0002/\u0001A\u0003%A\u000bC\u0003^\u0001\u0011\u0005a\fC\u0003`\u0001\u0011\u0005\u0001\rC\u0003`\u0001\u0011\u0005\u0011\u000fC\u0003\u007f\u0001\u0011\u0005q\u0010\u0003\u0004\u007f\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003+\u0001A\u0011BA\f\u0011\u001d\tY\u0002\u0001C\u0001\u0003;\u0011AcQ3mK\n|'O\u001c*bG.\u0014Vm]8mm\u0016\u0014(B\u0001\u000b\u0016\u0003\u001dqW\r^<pe.T!AF\f\u0002\r\r|W.\\8o\u0015\tA\u0012$\u0001\u0005dK2,'m\u001c:o\u0015\tQ2$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aH\u0013\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1\u0013&D\u0001(\u0015\tAS#\u0001\u0005j]R,'O\\1m\u0013\tQsEA\u0004M_\u001e<\u0017N\\4\u0002\u0019\r,G.\u001a2pe:\u001cuN\u001c4\u0011\u00055rS\"A\u000b\n\u0005=*\"\u0001D\"fY\u0016\u0014wN\u001d8D_:4\u0017A\u0002\u001fj]&$h\b\u0006\u00023iA\u00111\u0007A\u0007\u0002'!)1F\u0001a\u0001Y\u0005a\"/Y2l%\u0016\u001cx\u000e\u001c<f%\u00164'/Z:i)\"\u0014X-\u00193Q_>dW#A\u001c\u0011\u0005azT\"A\u001d\u000b\u0005iZ\u0014AC2p]\u000e,(O]3oi*\u0011A(P\u0001\u0005kRLGNC\u0001?\u0003\u0011Q\u0017M^1\n\u0005\u0001K$\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\u0006\u0001#/Y2l%\u0016\u001cx\u000e\u001c<f%\u00164'/Z:i)\"\u0014X-\u00193Q_>dw\fJ3r)\t\u0019e\t\u0005\u0002!\t&\u0011Q)\t\u0002\u0005+:LG\u000fC\u0004H\t\u0005\u0005\t\u0019A\u001c\u0002\u0007a$\u0013'A\u000fsC\u000e\\'+Z:pYZ,'+\u001a4sKNDG\u000b\u001b:fC\u0012\u0004vn\u001c7!\u0003m\u0011\u0018mY6SKN|GN^3MCN$Xj\u001c3jM&,G\rV5nKV\t1\n\u0005\u0002!\u0019&\u0011Q*\t\u0002\u0005\u0019>tw-A\u0010sC\u000e\\'+Z:pYZ,G*Y:u\u001b>$\u0017NZ5fIRKW.Z0%KF$\"a\u0011)\t\u000f\u001d;\u0011\u0011!a\u0001\u0017\u0006a\"/Y2l%\u0016\u001cx\u000e\u001c<f\u0019\u0006\u001cH/T8eS\u001aLW\r\u001a+j[\u0016\u0004\u0013A\u00053ogR{7k^5uG\"l\u0015\r\u001d9j]\u001e,\u0012\u0001\u0016\t\u0003+jk\u0011A\u0016\u0006\u0003/b\u000b1A\\3u\u0015\tI\u0016$\u0001\u0004iC\u0012|w\u000e]\u0005\u00037Z\u0013!\u0003\u0012(T)>\u001cv/\u001b;dQ6\u000b\u0007\u000f]5oO\u0006\u0019BM\\:U_N;\u0018\u000e^2i\u001b\u0006\u0004\b/\u001b8hA\u0005!1\u000f^8q)\u0005\u0019\u0015a\u0002:fg>dg/\u001a\u000b\u0003C\u0012\u0004\"!\u00162\n\u0005\r4&\u0001\u0002(pI\u0016DQ!\u001a\u0007A\u0002\u0019\f\u0001\u0002[8ti:\u000bW.\u001a\t\u0003O:t!\u0001\u001b7\u0011\u0005%\fS\"\u00016\u000b\u0005-l\u0012A\u0002\u001fs_>$h(\u0003\u0002nC\u00051\u0001K]3eK\u001aL!a\u001c9\u0003\rM#(/\u001b8h\u0015\ti\u0017\u0005\u0006\u0002swB\u00191\u000f_1\u000f\u0005Q4hBA5v\u0013\u0005\u0011\u0013BA<\"\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001f>\u0003\u0007M+\u0017O\u0003\u0002xC!)A0\u0004a\u0001{\u0006I\u0001n\\:u\u001d\u0006lWm\u001d\t\u0004gb4\u0017\u0001\u0004:fg>dg/\u001a+p\u001b\u0006\u0004H\u0003BA\u0001\u0003\u000f\u0001RaZA\u0002M\u0006L1!!\u0002q\u0005\ri\u0015\r\u001d\u0005\u0007y:\u0001\r!!\u0003\u0011\u000b\u0005-\u0011Q\u00024\u000e\u0003mJ1!a\u0004<\u0005\u0011a\u0015n\u001d;\u0015\t\u0005\u0005\u00111\u0003\u0005\u0006y>\u0001\r!`\u0001\fG>\u0014XMU3t_24X\rF\u0002s\u00033AQ\u0001 \tA\u0002u\fA\"[:P]N\u000bW.\u001a*bG.$b!a\b\u0002&\u0005%\u0002c\u0001\u0011\u0002\"%\u0019\u00111E\u0011\u0003\u000f\t{w\u000e\\3b]\"1\u0011qE\tA\u0002\u0019\f1\u0002\u001d:j[\u0006\u0014\u0018\u0010S8ti\"1\u00111F\tA\u0002\u0019\f1B]3qY&\u001c\u0017\rS8ti\u0002")
public class CelebornRackResolver
implements Logging {
    private ScheduledExecutorService rackResolveRefreshThreadPool;
    private long org$apache$celeborn$common$network$CelebornRackResolver$$rackResolveLastModifiedTime;
    private final DNSToSwitchMapping dnsToSwitchMapping;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        CelebornRackResolver celebornRackResolver = this;
        synchronized (celebornRackResolver) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    private ScheduledExecutorService rackResolveRefreshThreadPool() {
        return this.rackResolveRefreshThreadPool;
    }

    private void rackResolveRefreshThreadPool_$eq(ScheduledExecutorService x$1) {
        this.rackResolveRefreshThreadPool = x$1;
    }

    public long org$apache$celeborn$common$network$CelebornRackResolver$$rackResolveLastModifiedTime() {
        return this.org$apache$celeborn$common$network$CelebornRackResolver$$rackResolveLastModifiedTime;
    }

    public void org$apache$celeborn$common$network$CelebornRackResolver$$rackResolveLastModifiedTime_$eq(long x$1) {
        this.org$apache$celeborn$common$network$CelebornRackResolver$$rackResolveLastModifiedTime = x$1;
    }

    private DNSToSwitchMapping dnsToSwitchMapping() {
        return this.dnsToSwitchMapping;
    }

    public void stop() {
        if (this.rackResolveRefreshThreadPool() != null) {
            this.rackResolveRefreshThreadPool().shutdownNow();
            return;
        }
    }

    public Node resolve(String hostName) {
        return (Node)this.coreResolve((scala.collection.immutable.Seq<String>)new .colon.colon((Object)hostName, (List)Nil$.MODULE$)).head();
    }

    public scala.collection.immutable.Seq<Node> resolve(scala.collection.immutable.Seq<String> hostNames) {
        return this.coreResolve(hostNames);
    }

    public Map<String, Node> resolveToMap(java.util.List<String> hostNames) {
        return this.resolveToMap((scala.collection.immutable.Seq<String>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(hostNames).asScala()).toSeq());
    }

    public Map<String, Node> resolveToMap(scala.collection.immutable.Seq<String> hostNames) {
        return ((IterableOnceOps)hostNames.zip(this.resolve(hostNames))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private scala.collection.immutable.Seq<Node> coreResolve(scala.collection.immutable.Seq<String> hostNames) {
        if (hostNames.isEmpty()) {
            return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        }
        ArrayBuffer nodes = new ArrayBuffer();
        Buffer rNameList = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.dnsToSwitchMapping().resolve((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)hostNames.toList()).asJava())).asScala();
        if (rNameList == null || rNameList.isEmpty()) {
            hostNames.foreach((Function1 & Serializable)x$2 -> (ArrayBuffer)nodes.$plus$eq((Object)new NodeBase(x$2, "/default-rack")));
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Got an error when resolving hostNames. Falling back to /default-rack for all");
        } else {
            ((IterableOps)hostNames.zip((IterableOnce)rNameList)).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CelebornRackResolver.$anonfun$coreResolve$3(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
                Tuple2 tuple2 = x$3;
                if (tuple2 != null) {
                    String hostName = (String)tuple2._1();
                    String rName = (String)tuple2._2();
                    if (Strings.isNullOrEmpty(rName)) {
                        nodes.$plus$eq((Object)new NodeBase(hostName, "/default-rack"));
                        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(49).append("Could not resolve ").append(hostName).append(". ").append("Falling back to /default-rack").toString());
                        return BoxedUnit.UNIT;
                    }
                    return nodes.$plus$eq((Object)new NodeBase(hostName, rName));
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return nodes.toList();
    }

    public boolean isOnSameRack(String primaryHost, String replicaHost) {
        scala.collection.immutable.Seq<Node> nodes = this.resolve((scala.collection.immutable.Seq<String>)new .colon.colon((Object)primaryHost, (List)new .colon.colon((Object)replicaHost, (List)Nil$.MODULE$)));
        Tuple2 tuple2 = new Tuple2(nodes.head(), nodes.last());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Node primaryNode = (Node)tuple2._1();
        Node replicaNode = (Node)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)primaryNode, (Object)replicaNode);
        Node primaryNode2 = (Node)tuple22._1();
        Node replicaNode2 = (Node)tuple22._2();
        if (primaryNode2 == null || replicaNode2 == null) {
            return false;
        }
        String string = primaryNode2.getNetworkLocation();
        String string2 = replicaNode2.getNetworkLocation();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$coreResolve$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public CelebornRackResolver(CelebornConf celebornConf) {
        ScheduledFuture<?> scheduledFuture;
        String fileName;
        CachedDNSToSwitchMapping cachedDNSToSwitchMapping;
        DNSToSwitchMapping switchMapping;
        Logging.$init$(this);
        this.org$apache$celeborn$common$network$CelebornRackResolver$$rackResolveLastModifiedTime = 0L;
        Configuration conf = CelebornHadoopUtils$.MODULE$.newConfiguration(celebornConf);
        Class dnsToSwitchMappingClass = conf.getClass("net.topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class);
        DNSToSwitchMapping dNSToSwitchMapping = switchMapping = (DNSToSwitchMapping)ReflectionUtils.newInstance((Class)dnsToSwitchMappingClass, (Configuration)conf);
        CachedDNSToSwitchMapping mapping = dNSToSwitchMapping instanceof CachedDNSToSwitchMapping ? (cachedDNSToSwitchMapping = (CachedDNSToSwitchMapping)dNSToSwitchMapping) : new CachedDNSToSwitchMapping(dNSToSwitchMapping);
        long refreshInterval = celebornConf.rackResolverRefreshInterval();
        this.rackResolveRefreshThreadPool_$eq(ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("master-rack-resolver-refresher"));
        DNSToSwitchMapping dNSToSwitchMapping2 = switchMapping;
        String string = dNSToSwitchMapping2 instanceof ScriptBasedMapping ? conf.get("net.topology.script.file.name") : (fileName = dNSToSwitchMapping2 instanceof TableMapping ? conf.get("net.topology.table.file.name") : null);
        if (fileName != null) {
            ObjectRef scriptFile = ObjectRef.create((Object)new File(fileName));
            this.org$apache$celeborn$common$network$CelebornRackResolver$$rackResolveLastModifiedTime_$eq(((File)scriptFile.elem).lastModified());
            scheduledFuture = this.rackResolveRefreshThreadPool().scheduleWithFixedDelay(new Runnable(this, scriptFile, fileName, mapping){
                private final /* synthetic */ CelebornRackResolver $outer;
                private final ObjectRef scriptFile$1;
                private final String fileName$1;
                private final CachedDNSToSwitchMapping mapping$1;

                public void run() {
                    this.scriptFile$1.elem = new File(this.fileName$1);
                    if (((File)this.scriptFile$1.elem).canRead()) {
                        long currentLastModifiedTime = ((File)this.scriptFile$1.elem).lastModified();
                        if (currentLastModifiedTime != this.$outer.org$apache$celeborn$common$network$CelebornRackResolver$$rackResolveLastModifiedTime()) {
                            this.$outer.org$apache$celeborn$common$network$CelebornRackResolver$$rackResolveLastModifiedTime_$eq(currentLastModifiedTime);
                            this.mapping$1.reloadCachedMappings();
                            return;
                        }
                        return;
                    }
                    this.$outer.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Script file ").append($this.fileName$1).append(" is not readable, reload cache directly").toString());
                    this.mapping$1.reloadCachedMappings();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.scriptFile$1 = scriptFile$1;
                    this.fileName$1 = fileName$1;
                    this.mapping$1 = mapping$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.celeborn.common.network.CelebornRackResolver$$anon$1 )}, serializedLambda);
                }
            }, refreshInterval, refreshInterval, TimeUnit.MILLISECONDS);
        } else {
            scheduledFuture = this.rackResolveRefreshThreadPool().scheduleWithFixedDelay(new Runnable(null, mapping){
                private final CachedDNSToSwitchMapping mapping$1;

                public void run() {
                    this.mapping$1.reloadCachedMappings();
                }
                {
                    this.mapping$1 = mapping$1;
                }
            }, refreshInterval, refreshInterval, TimeUnit.MILLISECONDS);
        }
        this.dnsToSwitchMapping = mapping;
    }
}

