/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.serializer;

import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.celeborn.common.network.protocol.SerdeVersion;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.serializer.DeserializationStream;
import org.apache.celeborn.common.serializer.JavaDeserializationStream;
import org.apache.celeborn.common.serializer.JavaSerializationStream;
import org.apache.celeborn.common.serializer.SerializationStream;
import org.apache.celeborn.common.serializer.SerializerInstance;
import org.apache.celeborn.common.util.ByteBufferInputStream;
import org.apache.celeborn.common.util.ByteBufferOutputStream;
import org.apache.celeborn.common.util.Utils$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005%a!B\u0001\u0003\u0001\u0019a!A\u0006&bm\u0006\u001cVM]5bY&TXM]%ogR\fgnY3\u000b\u0005\r!\u0011AC:fe&\fG.\u001b>fe*\u0011QAB\u0001\u0007G>lWn\u001c8\u000b\u0005\u001dA\u0011\u0001C2fY\u0016\u0014wN\u001d8\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0003\u00015\u0001\"AD\b\u000e\u0003\tI!\u0001\u0005\u0002\u0003%M+'/[1mSj,'/\u00138ti\u0006t7-\u001a\u0005\t%\u0001\u0011\t\u0011)A\u0005)\u0005a1m\\;oi\u0016\u0014(+Z:fi\u000e\u0001\u0001CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"aA%oi\"A1\u0004\u0001B\u0001B\u0003%A$\u0001\bfqR\u0014\u0018\rR3ck\u001eLeNZ8\u0011\u0005Ui\u0012B\u0001\u0010\u0017\u0005\u001d\u0011un\u001c7fC:D\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!I\u0001\u0013I\u00164\u0017-\u001e7u\u00072\f7o\u001d'pC\u0012,'\u000f\u0005\u0002#O5\t1E\u0003\u0002%K\u0005!A.\u00198h\u0015\u00051\u0013\u0001\u00026bm\u0006L!\u0001K\u0012\u0003\u0017\rc\u0017m]:M_\u0006$WM\u001d\u0005\u0006U\u0001!\taK\u0001\u0007y%t\u0017\u000e\u001e \u0015\t1jcf\f\t\u0003\u001d\u0001AQAE\u0015A\u0002QAQaG\u0015A\u0002qAQ\u0001I\u0015A\u0002\u0005BQ!\r\u0001\u0005BI\n\u0011b]3sS\u0006d\u0017N_3\u0016\u0005M*EC\u0001\u001bO)\t)4\b\u0005\u00027s5\tqG\u0003\u00029K\u0005\u0019a.[8\n\u0005i:$A\u0003\"zi\u0016\u0014UO\u001a4fe\"9A\bMA\u0001\u0002\bi\u0014AC3wS\u0012,gnY3%gA\u0019a(Q\"\u000e\u0003}R!\u0001\u0011\f\u0002\u000fI,g\r\\3di&\u0011!i\u0010\u0002\t\u00072\f7o\u001d+bOB\u0011A)\u0012\u0007\u0001\t\u00151\u0005G1\u0001H\u0005\u0005!\u0016C\u0001%L!\t)\u0012*\u0003\u0002K-\t9aj\u001c;iS:<\u0007CA\u000bM\u0013\tieCA\u0002B]fDQa\u0014\u0019A\u0002\r\u000b\u0011\u0001\u001e\u0005\u0006#\u0002!\tEU\u0001\fI\u0016\u001cXM]5bY&TX-\u0006\u0002T-R\u0011AK\u0017\u000b\u0003+^\u0003\"\u0001\u0012,\u0005\u000b\u0019\u0003&\u0019A$\t\u000fa\u0003\u0016\u0011!a\u00023\u0006QQM^5eK:\u001cW\r\n\u001b\u0011\u0007y\nU\u000bC\u0003\\!\u0002\u0007Q'A\u0003csR,7\u000fC\u0003R\u0001\u0011\u0005S,\u0006\u0002_CR\u0019q,\u001a4\u0015\u0005\u0001\u0014\u0007C\u0001#b\t\u00151EL1\u0001H\u0011\u001d\u0019G,!AA\u0004\u0011\f!\"\u001a<jI\u0016t7-\u001a\u00136!\rq\u0014\t\u0019\u0005\u00067r\u0003\r!\u000e\u0005\u0006Or\u0003\r!I\u0001\u0007Y>\fG-\u001a:\t\u000b%\u0004A\u0011\t6\u0002\u001fM,'/[1mSj,7\u000b\u001e:fC6$\"a\u001b8\u0011\u00059a\u0017BA7\u0003\u0005M\u0019VM]5bY&T\u0018\r^5p]N#(/Z1n\u0011\u0015y\u0007\u000e1\u0001q\u0003\u0005\u0019\bCA9u\u001b\u0005\u0011(BA:&\u0003\tIw.\u0003\u0002ve\naq*\u001e;qkR\u001cFO]3b[\")q\u000f\u0001C!q\u0006\tB-Z:fe&\fG.\u001b>f'R\u0014X-Y7\u0015\u0005ed\bC\u0001\b{\u0013\tY(AA\u000bEKN,'/[1mSj\fG/[8o'R\u0014X-Y7\t\u000b=4\b\u0019A?\u0011\u0005Et\u0018BA@s\u0005-Ie\u000e];u'R\u0014X-Y7\t\r]\u0004A\u0011AA\u0002)\u0015I\u0018QAA\u0004\u0011\u0019y\u0017\u0011\u0001a\u0001{\"1q-!\u0001A\u0002\u0005\u0002")
public class JavaSerializerInstance
extends SerializerInstance {
    private final int counterReset;
    private final boolean extraDebugInfo;
    private final ClassLoader defaultClassLoader;

    @Override
    public <T> ByteBuffer serialize(T t, ClassTag<T> evidence$3) {
        ByteBufferOutputStream bos = new ByteBufferOutputStream();
        Object msg = Utils$.MODULE$.toTransportMessage(t);
        Object object = msg;
        if (object instanceof TransportMessage) {
            TransportMessage transportMessage = (TransportMessage)object;
            SerdeVersion serdeVersion = transportMessage.getSerdeVersion();
            SerdeVersion serdeVersion2 = SerdeVersion.V2;
            if (!(serdeVersion != null ? !((Object)((Object)serdeVersion)).equals((Object)serdeVersion2) : serdeVersion2 != null)) {
                DataOutputStream out = new DataOutputStream(bos);
                out.writeByte(SerdeVersion.V2.getMarker());
                out.write(transportMessage.toByteBuffer().array());
                out.close();
                return bos.toByteBuffer();
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        SerializationStream out = this.serializeStream(bos);
        out.writeObject(Utils$.MODULE$.toTransportMessage(t), ClassTag$.MODULE$.Any());
        out.close();
        return bos.toByteBuffer();
    }

    @Override
    public <T> T deserialize(ByteBuffer bytes, ClassTag<T> evidence$4) {
        bytes.mark();
        byte serdeVersion = bytes.get();
        if (serdeVersion == SerdeVersion.V2.getMarker()) {
            return (T)Utils$.MODULE$.fromTransportMessage(TransportMessage.fromByteBuffer(bytes, SerdeVersion.V2));
        }
        bytes.reset();
        ByteBufferInputStream bis = new ByteBufferInputStream(bytes);
        DeserializationStream in = this.deserializeStream(bis);
        return (T)Utils$.MODULE$.fromTransportMessage(in.readObject(evidence$4));
    }

    @Override
    public <T> T deserialize(ByteBuffer bytes, ClassLoader loader, ClassTag<T> evidence$5) {
        bytes.mark();
        byte serdeVersion = bytes.get();
        if (serdeVersion == SerdeVersion.V2.getMarker()) {
            return (T)Utils$.MODULE$.fromTransportMessage(TransportMessage.fromByteBuffer(bytes, SerdeVersion.V2));
        }
        bytes.reset();
        ByteBufferInputStream bis = new ByteBufferInputStream(bytes);
        DeserializationStream in = this.deserializeStream(bis, loader);
        return (T)Utils$.MODULE$.fromTransportMessage(in.readObject(evidence$5));
    }

    @Override
    public SerializationStream serializeStream(OutputStream s) {
        return new JavaSerializationStream(s, this.counterReset, this.extraDebugInfo);
    }

    @Override
    public DeserializationStream deserializeStream(InputStream s) {
        return new JavaDeserializationStream(s, this.defaultClassLoader);
    }

    public DeserializationStream deserializeStream(InputStream s, ClassLoader loader) {
        return new JavaDeserializationStream(s, loader);
    }

    public JavaSerializerInstance(int counterReset, boolean extraDebugInfo, ClassLoader defaultClassLoader) {
        this.counterReset = counterReset;
        this.extraDebugInfo = extraDebugInfo;
        this.defaultClassLoader = defaultClassLoader;
    }
}

