/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import java.io.EOFException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.shaded.com.google.common.base.Preconditions;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.celeborn.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.celeborn.shaded.io.netty.handler.stream.ChunkedInput;
import org.apache.celeborn.shaded.io.netty.handler.stream.ChunkedStream;

public class EncryptedMessageWithHeader
implements ChunkedInput<ByteBuf> {
    @Nullable
    private final ManagedBuffer managedBuffer;
    private final ByteBuf header;
    private final int headerLength;
    private final Object body;
    private final long bodyLength;
    private long totalBytesTransferred;

    public EncryptedMessageWithHeader(@Nullable ManagedBuffer managedBuffer, ByteBuf header, Object body, long bodyLength) {
        Preconditions.checkArgument(body instanceof InputStream || body instanceof ChunkedStream, "Body must be an InputStream or a ChunkedStream.");
        this.managedBuffer = managedBuffer;
        this.header = header;
        this.headerLength = header.readableBytes();
        this.body = body;
        this.bodyLength = bodyLength;
        this.totalBytesTransferred = 0L;
    }

    @Override
    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    @Override
    public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
        if (this.isEndOfInput()) {
            return null;
        }
        if (this.totalBytesTransferred < (long)this.headerLength) {
            this.totalBytesTransferred += (long)this.headerLength;
            return this.header.retain();
        }
        if (this.body instanceof InputStream) {
            int toRead;
            InputStream stream = (InputStream)this.body;
            int available = stream.available();
            available = available <= 0 ? (int)(this.length() - this.totalBytesTransferred) : (int)Math.min((long)available, this.length() - this.totalBytesTransferred);
            ByteBuf buffer = allocator.buffer(available);
            int read2 = buffer.writeBytes(stream, toRead = Math.min(available, buffer.writableBytes()));
            if (read2 >= 0) {
                this.totalBytesTransferred += (long)read2;
                return buffer;
            }
            throw new EOFException("Unable to read bytes from InputStream");
        }
        if (this.body instanceof ChunkedStream) {
            ChunkedStream stream = (ChunkedStream)this.body;
            long old = stream.transferredBytes();
            ByteBuf buffer = stream.readChunk(allocator);
            long read3 = stream.transferredBytes() - old;
            if (read3 >= 0L) {
                this.totalBytesTransferred += read3;
                assert (this.totalBytesTransferred <= this.length());
                return buffer;
            }
            throw new EOFException("Unable to read bytes from ChunkedStream");
        }
        return null;
    }

    @Override
    public long length() {
        return (long)this.headerLength + this.bodyLength;
    }

    @Override
    public long progress() {
        return this.totalBytesTransferred;
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        return (long)this.headerLength + this.bodyLength == this.totalBytesTransferred;
    }

    @Override
    public void close() throws Exception {
        this.header.release();
        if (this.managedBuffer != null) {
            this.managedBuffer.release();
        }
        if (this.body instanceof InputStream) {
            ((InputStream)this.body).close();
        } else if (this.body instanceof ChunkedStream) {
            ((ChunkedStream)this.body).close();
        }
    }
}

