/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.tiered;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.DriverChangedException;
import org.apache.celeborn.common.exception.PartitionUnRetryAbleException;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.plugin.flink.RemoteShuffleResource;
import org.apache.celeborn.plugin.flink.ShuffleResourceDescriptor;
import org.apache.celeborn.plugin.flink.buffer.ReceivedNoHeaderBufferPacker;
import org.apache.celeborn.plugin.flink.client.FlinkShuffleClientImpl;
import org.apache.celeborn.plugin.flink.tiered.CelebornChannelBufferReader;
import org.apache.celeborn.plugin.flink.tiered.TierShuffleDescriptorImpl;
import org.apache.celeborn.plugin.flink.utils.Utils;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.PartitionNotFoundException;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageInputChannelId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.AvailabilityNotifier;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageConsumerSpec;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierConsumerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleDescriptor;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CelebornTierConsumerAgent
implements TierConsumerAgent {
    private static final Logger LOG = LoggerFactory.getLogger(CelebornTierConsumerAgent.class);
    private final CelebornConf conf;
    private final int gateIndex;
    private final List<TieredStorageConsumerSpec> consumerSpecs;
    private final List<TierShuffleDescriptor> shuffleDescriptors;
    private final Map<TieredStoragePartitionId, Map<TieredStorageSubpartitionId, CelebornChannelBufferReader>> bufferReaders;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final Map<TieredStoragePartitionId, Map<TieredStorageSubpartitionId, Queue<Buffer>>> receivedBuffers;
    @GuardedBy(value="lock")
    private final Set<Tuple2<TieredStoragePartitionId, TieredStorageSubpartitionId>> subPartitionsNeedNotifyAvailable;
    @GuardedBy(value="lock")
    private boolean started = false;
    @GuardedBy(value="lock")
    private Throwable cause;
    @GuardedBy(value="lock")
    private boolean closed;
    private FlinkShuffleClientImpl shuffleClient;
    private AvailabilityNotifier availabilityNotifier;
    private TieredStorageMemoryManager memoryManager;
    private final int bufferSizeBytes;

    public CelebornTierConsumerAgent(CelebornConf conf, List<TieredStorageConsumerSpec> tieredStorageConsumerSpecs, List<TierShuffleDescriptor> shuffleDescriptors, int bufferSizeBytes) {
        Utils.checkArgument(!shuffleDescriptors.isEmpty(), "Wrong shuffle descriptors size.");
        Utils.checkArgument(tieredStorageConsumerSpecs.size() == shuffleDescriptors.size(), "Wrong consumer spec size.");
        this.conf = conf;
        this.gateIndex = tieredStorageConsumerSpecs.get(0).getGateIndex();
        this.consumerSpecs = tieredStorageConsumerSpecs;
        this.shuffleDescriptors = shuffleDescriptors;
        this.bufferReaders = new HashMap<TieredStoragePartitionId, Map<TieredStorageSubpartitionId, CelebornChannelBufferReader>>();
        this.receivedBuffers = new HashMap<TieredStoragePartitionId, Map<TieredStorageSubpartitionId, Queue<Buffer>>>();
        this.subPartitionsNeedNotifyAvailable = new HashSet<Tuple2<TieredStoragePartitionId, TieredStorageSubpartitionId>>();
        this.bufferSizeBytes = bufferSizeBytes;
        for (TierShuffleDescriptor shuffleDescriptor : shuffleDescriptors) {
            if (!(shuffleDescriptor instanceof TierShuffleDescriptorImpl)) continue;
            this.initShuffleClient((TierShuffleDescriptorImpl)shuffleDescriptor);
            break;
        }
        Utils.checkNotNull(this.shuffleClient);
        this.initBufferReaders();
    }

    public void setup(TieredStorageMemoryManager memoryManager) {
        this.memoryManager = memoryManager;
        for (Map<TieredStorageSubpartitionId, CelebornChannelBufferReader> subPartitionReaders : this.bufferReaders.values()) {
            subPartitionReaders.forEach((partitionId, reader) -> reader.setup(memoryManager));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        HashSet<Tuple2<TieredStoragePartitionId, TieredStorageSubpartitionId>> needNotifyAvailable;
        Iterator<TieredStorageConsumerSpec> iterator = this.lock;
        synchronized (iterator) {
            needNotifyAvailable = new HashSet<Tuple2<TieredStoragePartitionId, TieredStorageSubpartitionId>>(this.subPartitionsNeedNotifyAvailable);
            this.subPartitionsNeedNotifyAvailable.clear();
            this.started = true;
        }
        try {
            needNotifyAvailable.forEach(partitionIdTuple -> this.notifyAvailable((TieredStoragePartitionId)partitionIdTuple.f0, (TieredStorageSubpartitionId)partitionIdTuple.f1));
        }
        catch (Throwable t) {
            LOG.error("Error occurred when notifying sub partitions available", t);
            this.recycleAllResources();
            ExceptionUtils.rethrow((Throwable)t);
        }
        needNotifyAvailable.clear();
        for (TieredStorageConsumerSpec spec : this.consumerSpecs) {
            Iterator iterator2 = spec.getSubpartitionIds().values().iterator();
            while (iterator2.hasNext()) {
                int subpartitionId = (Integer)iterator2.next();
                CelebornChannelBufferReader bufferReader = this.getBufferReader(spec.getPartitionId(), new TieredStorageSubpartitionId(subpartitionId));
                if (bufferReader == null) continue;
                boolean openReaderSuccess = this.openReader(bufferReader);
                if (!openReaderSuccess) {
                    LOG.error("Failed to open reader.");
                    this.recycleAllResources();
                    ExceptionUtils.rethrow((Throwable)new IOException("Failed to open reader."));
                }
                bufferReader.notifyRequiredSegmentIfNeeded(0, subpartitionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int peekNextBufferSubpartitionId(TieredStoragePartitionId tieredStoragePartitionId, ResultSubpartitionIndexSet resultSubpartitionIndexSet) {
        Object object = this.lock;
        synchronized (object) {
            this.healthCheck();
            Map<TieredStorageSubpartitionId, Queue<Buffer>> subPartitionReceivedBuffers = this.receivedBuffers.get(tieredStoragePartitionId);
            if (subPartitionReceivedBuffers == null) {
                return -1;
            }
            for (int subPartitionIndex = resultSubpartitionIndexSet.getStartIndex(); subPartitionIndex <= resultSubpartitionIndexSet.getEndIndex(); ++subPartitionIndex) {
                Queue<Buffer> buffers = subPartitionReceivedBuffers.get(new TieredStorageSubpartitionId(subPartitionIndex));
                if (buffers == null || buffers.isEmpty()) continue;
                return subPartitionIndex;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Buffer> getNextBuffer(TieredStoragePartitionId tieredStoragePartitionId, TieredStorageSubpartitionId tieredStorageSubpartitionId, int segmentId) {
        Object object = this.lock;
        synchronized (object) {
            this.healthCheck();
        }
        if (!this.bufferReaders.containsKey(tieredStoragePartitionId) || !this.bufferReaders.get(tieredStoragePartitionId).containsKey(tieredStorageSubpartitionId)) {
            return Optional.empty();
        }
        try {
            boolean openReaderSuccess = this.openReader(tieredStoragePartitionId, tieredStorageSubpartitionId);
            if (!openReaderSuccess) {
                return Optional.empty();
            }
        }
        catch (Throwable throwable) {
            LOG.error("Failed to open reader.", throwable);
            this.recycleAllResources();
            ExceptionUtils.rethrow((Throwable)throwable);
        }
        Object object2 = this.lock;
        synchronized (object2) {
            CelebornChannelBufferReader bufferReader = this.getBufferReader(tieredStoragePartitionId, tieredStorageSubpartitionId);
            bufferReader.notifyRequiredSegmentIfNeeded(segmentId, tieredStorageSubpartitionId.getSubpartitionId());
            Map<TieredStorageSubpartitionId, Queue<Buffer>> partitionBuffers = this.receivedBuffers.get(tieredStoragePartitionId);
            if (partitionBuffers == null || partitionBuffers.isEmpty()) {
                return Optional.empty();
            }
            Queue<Buffer> subPartitionBuffers = partitionBuffers.get(tieredStorageSubpartitionId);
            if (subPartitionBuffers == null || subPartitionBuffers.isEmpty()) {
                return Optional.empty();
            }
            return Optional.ofNullable(subPartitionBuffers.poll());
        }
    }

    public void registerAvailabilityNotifier(AvailabilityNotifier availabilityNotifier) {
        this.availabilityNotifier = availabilityNotifier;
        LOG.info("Registered availability notifier for gate {}.", (Object)this.gateIndex);
    }

    public void updateTierShuffleDescriptor(TieredStoragePartitionId tieredStoragePartitionId, TieredStorageInputChannelId tieredStorageInputChannelId, TieredStorageSubpartitionId subpartitionId, TierShuffleDescriptor tierShuffleDescriptor) {
        if (!(tierShuffleDescriptor instanceof TierShuffleDescriptorImpl)) {
            return;
        }
        TierShuffleDescriptorImpl shuffleDescriptor = (TierShuffleDescriptorImpl)tierShuffleDescriptor;
        Utils.checkState(shuffleDescriptor.getResultPartitionID().equals((Object)tieredStoragePartitionId.getPartitionID()), "Wrong result partition id: " + shuffleDescriptor.getResultPartitionID());
        ResultSubpartitionIndexSet subpartitionIndexSet = new ResultSubpartitionIndexSet(subpartitionId.getSubpartitionId());
        if (!this.bufferReaders.containsKey(tieredStoragePartitionId) || !this.bufferReaders.get(tieredStoragePartitionId).containsKey(subpartitionId)) {
            ShuffleResourceDescriptor shuffleResourceDescriptor = shuffleDescriptor.getShuffleResource().getMapPartitionShuffleDescriptor();
            this.createBufferReader(shuffleResourceDescriptor, tieredStoragePartitionId, tieredStorageInputChannelId, subpartitionIndexSet);
            CelebornChannelBufferReader bufferReader = Utils.checkNotNull(this.getBufferReader(tieredStoragePartitionId, subpartitionId));
            bufferReader.setup(Utils.checkNotNull(this.memoryManager));
            this.openReader(bufferReader);
        }
    }

    public void close() {
        Throwable closeException = null;
        try {
            this.recycleAllResources();
        }
        catch (Throwable throwable) {
            closeException = throwable;
            LOG.error("Failed to recycle all resources.", throwable);
        }
        if (closeException != null) {
            ExceptionUtils.rethrow((Throwable)closeException);
        }
    }

    private void initShuffleClient(TierShuffleDescriptorImpl remoteShuffleDescriptor) {
        RemoteShuffleResource shuffleResource = remoteShuffleDescriptor.getShuffleResource();
        try {
            String appUniqueId = remoteShuffleDescriptor.getCelebornAppId();
            this.shuffleClient = FlinkShuffleClientImpl.get(appUniqueId, shuffleResource.getLifecycleManagerHost(), shuffleResource.getLifecycleManagerPort(), shuffleResource.getLifecycleManagerTimestamp(), this.conf, new UserIdentifier("default", "default"), this.bufferSizeBytes);
        }
        catch (DriverChangedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private CelebornChannelBufferReader getBufferReader(TieredStoragePartitionId tieredStoragePartitionId, TieredStorageSubpartitionId tieredStorageSubpartitionId) {
        return this.bufferReaders.get(tieredStoragePartitionId).get(tieredStorageSubpartitionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleAllResources() {
        ArrayList buffersToRecycle = new ArrayList();
        for (Map<TieredStorageSubpartitionId, CelebornChannelBufferReader> subPartitionReaders : this.bufferReaders.values()) {
            subPartitionReaders.values().forEach(CelebornChannelBufferReader::close);
        }
        Object object = this.lock;
        synchronized (object) {
            for (Map<TieredStorageSubpartitionId, Queue<Buffer>> subPartitionMap : this.receivedBuffers.values()) {
                buffersToRecycle.addAll(subPartitionMap.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(LinkedList::new)));
            }
            this.receivedBuffers.clear();
            this.bufferReaders.clear();
            this.availabilityNotifier = null;
            this.closed = true;
        }
        try {
            buffersToRecycle.forEach(Buffer::recycleBuffer);
        }
        catch (Throwable throwable) {
            LOG.error("Failed to recycle buffers.", throwable);
            throw throwable;
        }
    }

    private boolean openReader(TieredStoragePartitionId partitionId, TieredStorageSubpartitionId subPartitionId) {
        CelebornChannelBufferReader bufferReader = Utils.checkNotNull(Utils.checkNotNull(this.bufferReaders.get(partitionId)).get(subPartitionId));
        return this.openReader(bufferReader);
    }

    private boolean openReader(CelebornChannelBufferReader bufferReader) {
        if (!bufferReader.isOpened()) {
            try {
                bufferReader.open(0, true);
            }
            catch (Exception e) {
                this.recycleAllResources();
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
        bufferReader.setOpened(true);
        return true;
    }

    private void initBufferReaders() {
        for (int i = 0; i < this.shuffleDescriptors.size(); ++i) {
            if (!(this.shuffleDescriptors.get(i) instanceof TierShuffleDescriptorImpl)) continue;
            TierShuffleDescriptorImpl shuffleDescriptor = (TierShuffleDescriptorImpl)this.shuffleDescriptors.get(i);
            ResultPartitionID resultPartitionID = shuffleDescriptor.getResultPartitionID();
            ShuffleResourceDescriptor shuffleResourceDescriptor = shuffleDescriptor.getShuffleResource().getMapPartitionShuffleDescriptor();
            TieredStoragePartitionId partitionId = new TieredStoragePartitionId(resultPartitionID);
            Utils.checkState(this.consumerSpecs.get(i).getPartitionId().equals((Object)partitionId), "Wrong partition id.");
            ResultSubpartitionIndexSet subPartitionIdSet = this.consumerSpecs.get(i).getSubpartitionIds();
            LOG.debug("create shuffle reader for gate {} descriptor {} partitionId {}, subPartitionId start {} and end {}", new Object[]{this.gateIndex, shuffleResourceDescriptor, partitionId, subPartitionIdSet.getStartIndex(), subPartitionIdSet.getEndIndex()});
            this.createBufferReader(shuffleResourceDescriptor, partitionId, this.consumerSpecs.get(i).getInputChannelId(), subPartitionIdSet);
        }
    }

    private void createBufferReader(ShuffleResourceDescriptor shuffleDescriptor, TieredStoragePartitionId partitionId, TieredStorageInputChannelId inputChannelId, ResultSubpartitionIndexSet subPartitionIdSet) {
        CelebornChannelBufferReader reader = new CelebornChannelBufferReader(this.shuffleClient, shuffleDescriptor, inputChannelId, subPartitionIdSet.getStartIndex(), subPartitionIdSet.getEndIndex(), this.getDataListener(partitionId), this.getFailureListener(partitionId));
        for (int id = subPartitionIdSet.getStartIndex(); id <= subPartitionIdSet.getEndIndex(); ++id) {
            TieredStorageSubpartitionId subPartitionId = new TieredStorageSubpartitionId(id);
            Utils.checkState(!this.bufferReaders.containsKey(partitionId) || !this.bufferReaders.get(partitionId).containsKey(subPartitionId), "Duplicate shuffle reader.");
            this.bufferReaders.computeIfAbsent(partitionId, partition -> new HashMap()).put(subPartitionId, reader);
        }
    }

    @GuardedBy(value="lock")
    private void healthCheck() {
        if (this.closed || this.cause != null) {
            IOException e = this.closed ? new IOException("Celeborn consumer agent already closed.") : new IOException(this.cause);
            this.recycleAllResources();
            LOG.error("Failed to check health.", (Throwable)e);
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBuffer(TieredStoragePartitionId partitionId, TieredStorageSubpartitionId subPartitionId, Buffer buffer) {
        boolean wasEmpty;
        Object object = this.lock;
        synchronized (object) {
            if (this.closed || this.cause != null) {
                buffer.recycleBuffer();
                this.recycleAllResources();
                throw new IllegalStateException("Input gate already closed or failed.");
            }
            Queue buffers = this.receivedBuffers.computeIfAbsent(partitionId, partition -> new HashMap()).computeIfAbsent(subPartitionId, subpartition -> new LinkedList());
            wasEmpty = buffers.isEmpty();
            buffers.add(buffer);
            if (wasEmpty && !this.started) {
                this.subPartitionsNeedNotifyAvailable.add((Tuple2<TieredStoragePartitionId, TieredStorageSubpartitionId>)Tuple2.of((Object)partitionId, (Object)subPartitionId));
                return;
            }
        }
        if (wasEmpty) {
            this.notifyAvailable(partitionId, subPartitionId);
        }
    }

    private BiConsumer<ByteBuf, TieredStorageSubpartitionId> getDataListener(TieredStoragePartitionId partitionId) {
        return (byteBuf, subPartitionId) -> {
            Queue<Buffer> unpackedBuffers = null;
            try {
                unpackedBuffers = ReceivedNoHeaderBufferPacker.unpack(byteBuf);
                while (!unpackedBuffers.isEmpty()) {
                    this.onBuffer(partitionId, (TieredStorageSubpartitionId)subPartitionId, unpackedBuffers.poll());
                }
            }
            catch (Throwable throwable) {
                Object object = this.lock;
                synchronized (object) {
                    LOG.error("Failed to process the received buffer, cause: {} throwable {}.", this.cause == null ? "" : this.cause, (Object)throwable);
                    if (this.cause == null) {
                        this.cause = throwable;
                    }
                }
                this.notifyAvailable(partitionId, (TieredStorageSubpartitionId)subPartitionId);
                if (unpackedBuffers != null) {
                    unpackedBuffers.forEach(Buffer::recycleBuffer);
                }
                this.recycleAllResources();
            }
        };
    }

    private BiConsumer<Throwable, TieredStorageSubpartitionId> getFailureListener(TieredStoragePartitionId partitionId) {
        return (throwable, subPartitionId) -> {
            Object object = this.lock;
            synchronized (object) {
                if (this.cause != null) {
                    return;
                }
                Class<PartitionUnRetryAbleException> clazz = PartitionUnRetryAbleException.class;
                if (throwable.getMessage() != null && throwable.getMessage().contains(clazz.getName())) {
                    this.cause = new PartitionNotFoundException(TieredStorageIdMappingUtils.convertId((TieredStoragePartitionId)partitionId));
                    LOG.error("The consumer agent received an PartitionUnRetryAbleException.", throwable);
                } else {
                    LOG.error("The consumer agent received an exception.", throwable);
                    this.cause = throwable;
                }
            }
            this.notifyAvailable(partitionId, (TieredStorageSubpartitionId)subPartitionId);
        };
    }

    private void notifyAvailable(TieredStoragePartitionId partitionId, TieredStorageSubpartitionId subPartitionId) {
        CelebornChannelBufferReader channelBufferReader;
        Map<TieredStorageSubpartitionId, CelebornChannelBufferReader> subPartitionReaders = this.bufferReaders.get(partitionId);
        if (subPartitionReaders != null && (channelBufferReader = subPartitionReaders.get(subPartitionId)) != null) {
            this.availabilityNotifier.notifyAvailable(partitionId, channelBufferReader.getInputChannelId());
        }
    }
}

