/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport;

import java.util.function.BiFunction;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.editor.dbimport.DbImportModel;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTree;

public class PrintColumnsBiFunction
implements BiFunction<FilterContainer, DbImportTreeNode, Void> {
    private final DbImportTree dbImportTree;

    public PrintColumnsBiFunction(DbImportTree dbImportTree) {
        this.dbImportTree = dbImportTree;
    }

    @Override
    public Void apply(FilterContainer filterContainer, DbImportTreeNode root) {
        if (filterContainer != null) {
            filterContainer.getIncludeTables().forEach(tableFilter -> this.processTable((IncludeTable)tableFilter, root));
        }
        return null;
    }

    private void processTable(IncludeTable tableFilter, DbImportTreeNode root) {
        DbImportModel model = (DbImportModel)this.dbImportTree.getModel();
        DbImportTreeNode container = this.dbImportTree.findNodeInParent(root, tableFilter);
        if (container == null) {
            return;
        }
        if (container.getChildCount() != 0) {
            container.removeAllChildren();
        }
        this.dbImportTree.packColumns(tableFilter, container);
        container.setLoaded(true);
        this.dbImportTree.reloadModelKeepingExpanded(container);
    }
}

