/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.welcome;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ModelerPreferences;
import org.apache.cayenne.modeler.action.NewProjectAction;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.modeler.dialog.welcome.RecentFileListModel;
import org.apache.cayenne.modeler.dialog.welcome.RecentFileListRenderer;
import org.apache.cayenne.modeler.event.RecentFileListListener;
import org.apache.cayenne.modeler.util.BackgroundPanel;
import org.apache.cayenne.modeler.util.ModelerUtil;

public class WelcomeScreen
extends JScrollPane
implements RecentFileListListener,
RecentFileListRenderer.OnFileClickListener {
    private static final Color TOP_GRADIENT = new Color(153, 153, 153);
    private static final Color BOTTOM_GRADIENT = new Color(230, 230, 230);
    private JList<String> recentProjectsList;
    private JPanel buttonsPanel;
    private JPanel mainPanel;

    public WelcomeScreen() {
        this.initView();
    }

    protected void initView() {
        this.mainPanel = new JPanel(new GridBagLayout()){

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                GradientPaint paint = new GradientPaint(0.0f, 0.0f, TOP_GRADIENT, 0.0f, this.getHeight(), BOTTOM_GRADIENT);
                g2.setPaint(paint);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2.dispose();
            }
        };
        this.setBorder(BorderFactory.createEmptyBorder());
        this.initButtonsPane();
        this.initFileListPane();
        this.setViewportView(this.mainPanel);
    }

    private void initFileListPane() {
        BackgroundPanel fileListPanel = new BackgroundPanel("welcome/welcome-screen-right-bg.jpg");
        int padding = 20;
        this.recentProjectsList = new JList();
        this.recentProjectsList.setOpaque(false);
        this.recentProjectsList.setLocation(20, 20);
        this.recentProjectsList.setSize(fileListPanel.getWidth() - 40, fileListPanel.getHeight() - 40);
        this.recentProjectsList.setCellRenderer(new RecentFileListRenderer(this.recentProjectsList, this));
        fileListPanel.add(this.recentProjectsList);
        this.mainPanel.add(fileListPanel);
    }

    private void initButtonsPane() {
        int padding = 24;
        int buttonHeight = 36;
        this.buttonsPanel = new BackgroundPanel("welcome/welcome-screen-left-bg.jpg");
        int openButtonY = this.buttonsPanel.getHeight() - 24 - 36;
        int newButtonY = openButtonY - 10 - 36;
        this.initButton("open", openButtonY, OpenProjectAction.class);
        this.initButton("new", newButtonY, NewProjectAction.class);
        this.mainPanel.add(this.buttonsPanel);
    }

    private void initButton(String name, int y, Class<? extends Action> actionClass) {
        ImageIcon icon = ModelerUtil.buildIcon("welcome/welcome-screen-" + name + "-btn.png");
        ImageIcon hoverIcon = ModelerUtil.buildIcon("welcome/welcome-screen-" + name + "-btn-hover.png");
        JButton button = this.createButton(icon, hoverIcon);
        button.setLocation(24, y);
        button.addActionListener(Application.getInstance().getActionManager().getAction(actionClass));
        this.buttonsPanel.add(button);
    }

    @Override
    public void onFileSelect(File file) {
        ActionEvent event = new ActionEvent(file, 0, null);
        Application.getInstance().getActionManager().getAction(OpenProjectAction.class).performAction(event);
    }

    private JButton createButton(Icon outIcon, Icon overIcon) {
        JButton button = new JButton();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setContentAreaFilled(false);
        button.setPressedIcon(overIcon);
        button.setRolloverIcon(overIcon);
        button.setIcon(outIcon);
        button.setSize(outIcon.getIconWidth(), outIcon.getIconHeight());
        return button;
    }

    @Override
    public void recentFileListChanged() {
        List<File> arr = ModelerPreferences.getLastProjFiles();
        this.recentProjectsList.setModel(new RecentFileListModel(arr));
    }
}

