/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.event.EventListenerList;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.event.DataMapEvent;
import org.apache.cayenne.configuration.event.DataMapListener;
import org.apache.cayenne.configuration.event.DataNodeEvent;
import org.apache.cayenne.configuration.event.DataNodeListener;
import org.apache.cayenne.configuration.event.DomainEvent;
import org.apache.cayenne.configuration.event.DomainListener;
import org.apache.cayenne.configuration.event.ProcedureEvent;
import org.apache.cayenne.configuration.event.ProcedureListener;
import org.apache.cayenne.configuration.event.ProcedureParameterEvent;
import org.apache.cayenne.configuration.event.ProcedureParameterListener;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.configuration.event.QueryListener;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.DbAttributeListener;
import org.apache.cayenne.map.event.DbEntityListener;
import org.apache.cayenne.map.event.DbRelationshipListener;
import org.apache.cayenne.map.event.EmbeddableAttributeEvent;
import org.apache.cayenne.map.event.EmbeddableAttributeListener;
import org.apache.cayenne.map.event.EmbeddableEvent;
import org.apache.cayenne.map.event.EmbeddableListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjAttributeListener;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.map.event.ObjRelationshipListener;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.CayenneModelerController;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.ProjectFileChangeTracker;
import org.apache.cayenne.modeler.action.NavigateBackwardAction;
import org.apache.cayenne.modeler.action.NavigateForwardAction;
import org.apache.cayenne.modeler.action.RevertAction;
import org.apache.cayenne.modeler.action.SaveAction;
import org.apache.cayenne.modeler.action.SaveAsAction;
import org.apache.cayenne.modeler.editor.CallbackType;
import org.apache.cayenne.modeler.editor.ObjCallbackMethod;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.CallbackMethodEvent;
import org.apache.cayenne.modeler.event.CallbackMethodListener;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.event.DataMapDisplayListener;
import org.apache.cayenne.modeler.event.DataNodeDisplayEvent;
import org.apache.cayenne.modeler.event.DataNodeDisplayListener;
import org.apache.cayenne.modeler.event.DataSourceModificationEvent;
import org.apache.cayenne.modeler.event.DataSourceModificationListener;
import org.apache.cayenne.modeler.event.DbAttributeDisplayListener;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.DbRelationshipDisplayListener;
import org.apache.cayenne.modeler.event.DisplayEvent;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.modeler.event.DomainDisplayListener;
import org.apache.cayenne.modeler.event.EmbeddableAttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableAttributeDisplayListener;
import org.apache.cayenne.modeler.event.EmbeddableDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.EntityListenerEvent;
import org.apache.cayenne.modeler.event.EntityListenerListener;
import org.apache.cayenne.modeler.event.MultipleObjectsDisplayEvent;
import org.apache.cayenne.modeler.event.MultipleObjectsDisplayListener;
import org.apache.cayenne.modeler.event.ObjAttributeDisplayListener;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.ObjRelationshipDisplayListener;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureDisplayListener;
import org.apache.cayenne.modeler.event.ProcedureParameterDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureParameterDisplayListener;
import org.apache.cayenne.modeler.event.ProjectOnSaveEvent;
import org.apache.cayenne.modeler.event.ProjectOnSaveListener;
import org.apache.cayenne.modeler.event.ProjectSavedEvent;
import org.apache.cayenne.modeler.event.ProjectSavedListener;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.event.QueryDisplayListener;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.event.ValidationConfigDisplayEvent;
import org.apache.cayenne.modeler.event.ValidationConfigDisplayListener;
import org.apache.cayenne.modeler.pref.DataMapDefaults;
import org.apache.cayenne.modeler.pref.DataNodeDefaults;
import org.apache.cayenne.modeler.pref.ProjectStatePreferences;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.CircularArray;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.project.ConfigurationNodeParentGetter;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.util.IDUtil;

public class ProjectController
extends CayenneController {
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean dirty;
    protected int entityTabSelection;
    protected Project project;
    protected Preferences projectControllerPreferences;
    protected ControllerState currentState;
    protected CircularArray<ControllerState> controllerStateHistory = new CircularArray(this.maxHistorySize);
    protected int maxHistorySize = 20;
    private EntityResolver entityResolver;
    private ProjectFileChangeTracker fileChangeTracker;

    public ProjectController(CayenneModelerController parent) {
        super(parent);
        this.currentState = new ControllerState();
    }

    @Override
    public Component getView() {
        return this.parent.getView();
    }

    public void setCurrentDataMap(DataMap dataMap) {
        this.currentState.map = dataMap;
    }

    public Project getProject() {
        return this.project;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setProject(Project currentProject) {
        if (this.project != currentProject) {
            this.project = currentProject;
            this.projectControllerPreferences = null;
            if (this.project == null) {
                this.entityResolver = null;
                if (this.fileChangeTracker != null) {
                    this.fileChangeTracker.interrupt();
                    this.fileChangeTracker = null;
                }
            } else {
                if (this.fileChangeTracker == null) {
                    this.fileChangeTracker = new ProjectFileChangeTracker(this);
                    this.fileChangeTracker.setDaemon(true);
                    this.fileChangeTracker.start();
                }
                this.fileChangeTracker.reconfigure();
                this.entityResolver = new EntityResolver();
                this.updateEntityResolver();
            }
        }
    }

    public void updateEntityResolver() {
        Collection<DataMap> dataMaps = ((DataChannelDescriptor)this.project.getRootNode()).getDataMaps();
        for (DataMap dataMap : dataMaps) {
            this.entityResolver.addDataMap(dataMap);
            dataMap.setNamespace(this.entityResolver);
        }
    }

    public Preferences getPreferenceForProject() {
        if (this.getProject() == null) {
            throw new CayenneRuntimeException("No Project selected", new Object[0]);
        }
        if (this.projectControllerPreferences == null) {
            this.updateProjectControllerPreferences();
        }
        return this.projectControllerPreferences;
    }

    public Preferences getPreferenceForDataDomain() {
        DataChannelDescriptor dataDomain = (DataChannelDescriptor)this.getProject().getRootNode();
        if (dataDomain == null) {
            throw new CayenneRuntimeException("No DataDomain selected", new Object[0]);
        }
        return this.getPreferenceForProject().node(dataDomain.getName());
    }

    public DataMapDefaults getDataMapPreferences(String nameSuffix) {
        DataMap map = this.getCurrentDataMap();
        if (map == null) {
            throw new CayenneRuntimeException("No DataMap selected", new Object[0]);
        }
        Preferences pref = nameSuffix == null || nameSuffix.length() == 0 ? this.getPreferenceForDataDomain().node("DataMap").node(map.getName()) : this.getPreferenceForDataDomain().node("DataMap").node(map.getName()).node(nameSuffix);
        return (DataMapDefaults)this.application.getCayenneProjectPreferences().getProjectDetailObject(DataMapDefaults.class, pref);
    }

    public DataMapDefaults getDataMapPreferences(DataMap dataMap) {
        Preferences pref = this.getPreferenceForDataDomain().node("DataMap").node(dataMap.getName());
        return (DataMapDefaults)this.application.getCayenneProjectPreferences().getProjectDetailObject(DataMapDefaults.class, pref);
    }

    public DataMapDefaults getDataMapPreferences(String nameSuffix, DataMap map) {
        Preferences pref = nameSuffix == null || nameSuffix.length() == 0 ? this.getPreferenceForDataDomain().node("DataMap").node(map.getName()) : this.getPreferenceForDataDomain().node("DataMap").node(map.getName()).node(nameSuffix);
        return (DataMapDefaults)this.application.getCayenneProjectPreferences().getProjectDetailObject(DataMapDefaults.class, pref);
    }

    public DataNodeDefaults getDataNodePreferences() {
        DataNodeDescriptor node = this.getCurrentDataNode();
        if (node == null) {
            throw new CayenneRuntimeException("No DataNode selected", new Object[0]);
        }
        return (DataNodeDefaults)this.application.getCayenneProjectPreferences().getProjectDetailObject(DataNodeDefaults.class, this.getPreferenceForDataDomain().node("DataNode").node(node.getName()));
    }

    public ProjectStatePreferences getProjectStatePreferences() {
        return (ProjectStatePreferences)this.application.getCayenneProjectPreferences().getProjectDetailObject(ProjectStatePreferences.class, this.getPreferenceForDataDomain());
    }

    public void projectOpened() {
        CayenneModelerFrame frame = (CayenneModelerFrame)this.getView();
        this.addDataNodeDisplayListener(frame);
        this.addDataMapDisplayListener(frame);
        this.addObjEntityDisplayListener(frame);
        this.addDbEntityDisplayListener(frame);
        this.addQueryDisplayListener(frame);
        this.addProcedureDisplayListener(frame);
        this.addMultipleObjectsDisplayListener(frame);
        this.addEmbeddableDisplayListener(frame);
    }

    public void reset() {
        this.clearState();
        this.setDirty(false);
        this.setEntityTabSelection(0);
        this.listenerList = new EventListenerList();
        this.controllerStateHistory.clear();
    }

    public void setHistorySize(int newSize) {
        this.controllerStateHistory.resize(newSize);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void clearState() {
        if (this.currentState.isRefiring) {
            return;
        }
        this.currentState = new ControllerState();
    }

    private void saveState(DisplayEvent e) {
        if (!this.controllerStateHistory.contains(this.currentState)) {
            this.currentState.event = e;
            this.controllerStateHistory.add(this.currentState);
        }
    }

    private void removeFromHistory(EventObject e) {
        int count = this.controllerStateHistory.size();
        ArrayList<ControllerState> removeList = new ArrayList<ControllerState>();
        for (int i = 0; i < count; ++i) {
            ControllerState cs = this.controllerStateHistory.get(i);
            if (cs == null || cs.event == null) continue;
            DisplayEvent csEvent = cs.event;
            if (e instanceof EntityEvent && csEvent instanceof EntityDisplayEvent) {
                if (((EntityEvent)e).getEntity() != ((EntityDisplayEvent)csEvent).getEntity()) continue;
                removeList.add(cs);
                continue;
            }
            if (e instanceof EmbeddableEvent && csEvent instanceof EmbeddableDisplayEvent) {
                if (((EmbeddableEvent)e).getEmbeddable() != ((EmbeddableDisplayEvent)csEvent).getEmbeddable()) continue;
                removeList.add(cs);
                continue;
            }
            if (e instanceof ProcedureEvent && csEvent instanceof ProcedureDisplayEvent) {
                if (((ProcedureEvent)e).getProcedure() != ((ProcedureDisplayEvent)csEvent).getProcedure()) continue;
                removeList.add(cs);
                continue;
            }
            if (e instanceof QueryEvent && csEvent instanceof QueryDisplayEvent) {
                if (((QueryEvent)e).getQuery() != ((QueryDisplayEvent)csEvent).getQuery()) continue;
                removeList.add(cs);
                continue;
            }
            if (e instanceof DataMapEvent && csEvent instanceof DataMapDisplayEvent) {
                if (((DataMapEvent)e).getDataMap() != ((DataMapDisplayEvent)csEvent).getDataMap()) continue;
                removeList.add(cs);
                continue;
            }
            if (e instanceof DataNodeEvent && csEvent instanceof DataNodeDisplayEvent) {
                if (((DataNodeEvent)e).getDataNode() != ((DataNodeDisplayEvent)csEvent).getDataNode()) continue;
                removeList.add(cs);
                continue;
            }
            if (!(e instanceof DomainEvent) || !(csEvent instanceof DomainDisplayEvent) || ((DomainEvent)e).getDomain() != ((DomainDisplayEvent)csEvent).getDomain()) continue;
            removeList.add(cs);
        }
        for (ControllerState o : removeList) {
            this.controllerStateHistory.remove(o);
        }
    }

    public DataChannelDescriptor getCurrentDataChanel() {
        return this.currentState.domain;
    }

    public DataNodeDescriptor getCurrentDataNode() {
        return this.currentState.node;
    }

    public DataMap getCurrentDataMap() {
        return this.currentState.map;
    }

    public ObjEntity getCurrentObjEntity() {
        return this.currentState.objEntity;
    }

    public Embeddable getCurrentEmbeddable() {
        return this.currentState.embeddable;
    }

    public DbEntity getCurrentDbEntity() {
        return this.currentState.dbEntity;
    }

    public ObjAttribute[] getCurrentObjAttributes() {
        return this.currentState.objAttrs;
    }

    public DbAttribute[] getCurrentDbAttributes() {
        return this.currentState.dbAttrs;
    }

    public EmbeddableAttribute[] getCurrentEmbAttributes() {
        return this.currentState.embAttrs;
    }

    public ObjRelationship[] getCurrentObjRelationships() {
        return this.currentState.objRels;
    }

    public DbRelationship[] getCurrentDbRelationships() {
        return this.currentState.dbRels;
    }

    public QueryDescriptor getCurrentQuery() {
        return this.currentState.query;
    }

    public Procedure getCurrentProcedure() {
        return this.currentState.procedure;
    }

    public ProcedureParameter[] getCurrentProcedureParameters() {
        return this.currentState.procedureParameters;
    }

    public ConfigurationNode[] getCurrentPaths() {
        return this.currentState.paths;
    }

    public ConfigurationNode getCurrentParentPath() {
        return this.currentState.parentPath;
    }

    public DisplayEvent getLastDisplayEvent() {
        return this.currentState.event;
    }

    public void addDomainDisplayListener(DomainDisplayListener listener) {
        this.listenerList.add(DomainDisplayListener.class, listener);
    }

    public void addDomainListener(DomainListener listener) {
        this.listenerList.add(DomainListener.class, listener);
    }

    public void removeDomainListener(DomainListener listener) {
        this.listenerList.remove(DomainListener.class, listener);
    }

    public void addValidationConfigDisplayListener(ValidationConfigDisplayListener listener) {
        this.listenerList.add(ValidationConfigDisplayListener.class, listener);
    }

    public void removeValidationConfigDisplayListener(ValidationConfigDisplayListener listener) {
        this.listenerList.remove(ValidationConfigDisplayListener.class, listener);
    }

    public void addDataNodeDisplayListener(DataNodeDisplayListener listener) {
        this.listenerList.add(DataNodeDisplayListener.class, listener);
    }

    public void addDataNodeListener(DataNodeListener listener) {
        this.listenerList.add(DataNodeListener.class, listener);
    }

    public void addDataMapDisplayListener(DataMapDisplayListener listener) {
        this.listenerList.add(DataMapDisplayListener.class, listener);
    }

    public void addDataMapListener(DataMapListener listener) {
        this.listenerList.add(DataMapListener.class, listener);
    }

    public void removeDataMapListener(DataMapListener listener) {
        this.listenerList.remove(DataMapListener.class, listener);
    }

    public void addDbEntityListener(DbEntityListener listener) {
        this.listenerList.add(DbEntityListener.class, listener);
    }

    public void removeDbEntityListener(DbEntityListener listener) {
        this.listenerList.remove(DbEntityListener.class, listener);
    }

    public void addProjectOnSaveListener(ProjectOnSaveListener listener) {
        this.listenerList.add(ProjectOnSaveListener.class, listener);
    }

    public void removeProjectOnSaveListener(ProjectOnSaveListener listener) {
        this.listenerList.remove(ProjectOnSaveListener.class, listener);
    }

    public void addProjectSavedListener(ProjectSavedListener listener) {
        this.listenerList.add(ProjectSavedListener.class, listener);
    }

    public void removeProjectSavedListener(ProjectSavedListener listener) {
        this.listenerList.remove(ProjectSavedListener.class, listener);
    }

    public void addObjEntityListener(ObjEntityListener listener) {
        this.listenerList.add(ObjEntityListener.class, listener);
    }

    public void removeObjEntityListener(ObjEntityListener listener) {
        this.listenerList.remove(ObjEntityListener.class, listener);
    }

    public void addDbEntityDisplayListener(DbEntityDisplayListener listener) {
        this.listenerList.add(DbEntityDisplayListener.class, listener);
    }

    public void addObjEntityDisplayListener(ObjEntityDisplayListener listener) {
        this.listenerList.add(ObjEntityDisplayListener.class, listener);
    }

    public void addEmbeddableDisplayListener(EmbeddableDisplayListener listener) {
        this.listenerList.add(EmbeddableDisplayListener.class, listener);
    }

    public void addEmbeddableAttributeDisplayListener(EmbeddableAttributeDisplayListener listener) {
        this.listenerList.add(EmbeddableAttributeDisplayListener.class, listener);
    }

    public void addDbAttributeListener(DbAttributeListener listener) {
        this.listenerList.add(DbAttributeListener.class, listener);
    }

    public void removeDbAttributeListener(DbAttributeListener listener) {
        this.listenerList.remove(DbAttributeListener.class, listener);
    }

    public void addDbAttributeDisplayListener(DbAttributeDisplayListener listener) {
        this.listenerList.add(DbAttributeDisplayListener.class, listener);
    }

    public void addObjAttributeListener(ObjAttributeListener listener) {
        this.listenerList.add(ObjAttributeListener.class, listener);
    }

    public void removeObjAttributeListener(ObjAttributeListener listener) {
        this.listenerList.remove(ObjAttributeListener.class, listener);
    }

    public void addObjAttributeDisplayListener(ObjAttributeDisplayListener listener) {
        this.listenerList.add(ObjAttributeDisplayListener.class, listener);
    }

    public void addDbRelationshipListener(DbRelationshipListener listener) {
        this.listenerList.add(DbRelationshipListener.class, listener);
    }

    public void removeDbRelationshipListener(DbRelationshipListener listener) {
        this.listenerList.add(DbRelationshipListener.class, listener);
    }

    public void addDbRelationshipDisplayListener(DbRelationshipDisplayListener listener) {
        this.listenerList.add(DbRelationshipDisplayListener.class, listener);
    }

    public void addObjRelationshipListener(ObjRelationshipListener listener) {
        this.listenerList.add(ObjRelationshipListener.class, listener);
    }

    public void removeObjRelationshipListener(ObjRelationshipListener listener) {
        this.listenerList.remove(ObjRelationshipListener.class, listener);
    }

    public void addObjRelationshipDisplayListener(ObjRelationshipDisplayListener listener) {
        this.listenerList.add(ObjRelationshipDisplayListener.class, listener);
    }

    public void addQueryDisplayListener(QueryDisplayListener listener) {
        this.listenerList.add(QueryDisplayListener.class, listener);
    }

    public void addQueryListener(QueryListener listener) {
        this.listenerList.add(QueryListener.class, listener);
    }

    public void addProcedureDisplayListener(ProcedureDisplayListener listener) {
        this.listenerList.add(ProcedureDisplayListener.class, listener);
    }

    public void addProcedureListener(ProcedureListener listener) {
        this.listenerList.add(ProcedureListener.class, listener);
    }

    public void addProcedureParameterListener(ProcedureParameterListener listener) {
        this.listenerList.add(ProcedureParameterListener.class, listener);
    }

    public void addProcedureParameterDisplayListener(ProcedureParameterDisplayListener listener) {
        this.listenerList.add(ProcedureParameterDisplayListener.class, listener);
    }

    public void addMultipleObjectsDisplayListener(MultipleObjectsDisplayListener listener) {
        this.listenerList.add(MultipleObjectsDisplayListener.class, listener);
    }

    public void fireDomainDisplayEvent(DomainDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getDomain() != this.currentState.domain;
        if (!changed) {
            boolean bl2 = changed = this.currentState.node != null || this.currentState.map != null || this.currentState.dbEntity != null || this.currentState.objEntity != null || this.currentState.procedure != null || this.currentState.query != null || this.currentState.embeddable != null;
        }
        if (!e.isRefired()) {
            e.setDomainChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        for (DomainDisplayListener listener : (DomainDisplayListener[])this.listenerList.getListeners(DomainDisplayListener.class)) {
            listener.currentDomainChanged(e);
        }
        if (e.getDomain() == null) {
            this.getApplication().getActionManager().projectOpened();
        } else {
            this.getApplication().getActionManager().domainSelected();
        }
    }

    public void fireValidationConfigDisplayEvent(ValidationConfigDisplayEvent event) {
        for (ValidationConfigDisplayListener listener : (ValidationConfigDisplayListener[])this.listenerList.getListeners(ValidationConfigDisplayListener.class)) {
            listener.validationOptionChanged(event);
        }
    }

    public void fireDomainEvent(DomainEvent e) {
        this.setDirty(true);
        if (e.getId() == 3) {
            this.removeFromHistory(e);
        }
        block3: for (DomainListener listener : (DomainListener[])this.listenerList.getListeners(DomainListener.class)) {
            switch (e.getId()) {
                case 1: {
                    listener.domainChanged(e);
                    continue block3;
                }
                default: {
                    throw new IllegalArgumentException("Invalid DomainEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireDataNodeDisplayEvent(DataNodeDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getDataNode() != this.currentState.node;
        if (!changed) {
            boolean bl2 = changed = this.currentState.map != null || this.currentState.dbEntity != null || this.currentState.objEntity != null || this.currentState.procedure != null || this.currentState.query != null || this.currentState.embeddable != null;
        }
        if (!e.isRefired()) {
            e.setDataNodeChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.node = e.getDataNode();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        for (DataNodeDisplayListener listener : (DataNodeDisplayListener[])this.listenerList.getListeners(DataNodeDisplayListener.class)) {
            listener.currentDataNodeChanged(e);
        }
    }

    public void fireDataNodeEvent(DataNodeEvent e) {
        this.setDirty(true);
        if (e.getId() == 3) {
            this.removeFromHistory(e);
        }
        block5: for (DataNodeListener listener : (DataNodeListener[])this.listenerList.getListeners(DataNodeListener.class)) {
            switch (e.getId()) {
                case 2: {
                    listener.dataNodeAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.dataNodeChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.dataNodeRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid DataNodeEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireDataMapDisplayEvent(DataMapDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getDataMap() != this.currentState.map;
        if (!changed) {
            changed = this.currentState.dbEntity != null || this.currentState.objEntity != null || this.currentState.procedure != null || this.currentState.query != null || this.currentState.embeddable != null;
            this.currentState.node = e.getDataNode();
        }
        if (!e.isRefired()) {
            e.setDataMapChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.node = e.getDataNode();
                this.currentState.map = e.getDataMap();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        for (DataMapDisplayListener listener : (DataMapDisplayListener[])this.listenerList.getListeners(DataMapDisplayListener.class)) {
            listener.currentDataMapChanged(e);
        }
    }

    public void fireProjectSavedEvent(ProjectSavedEvent e) {
        for (ProjectSavedListener eventListener : (ProjectSavedListener[])this.listenerList.getListeners(ProjectSavedListener.class)) {
            eventListener.onProjectSaved(e);
        }
    }

    public void fireDataMapEvent(DataMapEvent e) {
        this.setDirty(true);
        if (e.getId() == 3) {
            this.removeFromHistory(e);
        }
        block5: for (DataMapListener eventListener : (DataMapListener[])this.listenerList.getListeners(DataMapListener.class)) {
            switch (e.getId()) {
                case 2: {
                    eventListener.dataMapAdded(e);
                    continue block5;
                }
                case 1: {
                    eventListener.dataMapChanged(e);
                    continue block5;
                }
                case 3: {
                    eventListener.dataMapRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid DataMapEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireObjEntityEvent(EntityEvent e) {
        this.setDirty(true);
        if (e.getEntity().getDataMap() != null && e.getId() == 1) {
            e.getEntity().getDataMap().objEntityChanged(e);
        }
        if (e.getId() == 3) {
            this.removeFromHistory(e);
        }
        block5: for (ObjEntityListener listener : (ObjEntityListener[])this.listenerList.getListeners(ObjEntityListener.class)) {
            switch (e.getId()) {
                case 2: {
                    listener.objEntityAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.objEntityChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.objEntityRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid EntityEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireDbEntityEvent(EntityEvent e) {
        this.setDirty(true);
        if (e.getEntity().getDataMap() != null && e.getId() == 1) {
            e.getEntity().getDataMap().dbEntityChanged(e);
        }
        if (e.getId() == 3) {
            this.removeFromHistory(e);
        }
        block5: for (DbEntityListener listener : (DbEntityListener[])this.listenerList.getListeners(DbEntityListener.class)) {
            switch (e.getId()) {
                case 2: {
                    listener.dbEntityAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.dbEntityChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.dbEntityRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid EntityEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireQueryEvent(QueryEvent e) {
        this.setDirty(true);
        if (e.getId() == 3) {
            this.removeFromHistory(e);
        }
        block5: for (QueryListener eventListener : (QueryListener[])this.listenerList.getListeners(QueryListener.class)) {
            switch (e.getId()) {
                case 2: {
                    eventListener.queryAdded(e);
                    continue block5;
                }
                case 1: {
                    eventListener.queryChanged(e);
                    continue block5;
                }
                case 3: {
                    eventListener.queryRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid ProcedureEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireProcedureEvent(ProcedureEvent e) {
        this.setDirty(true);
        if (e.getId() == 3) {
            this.removeFromHistory(e);
        }
        block5: for (ProcedureListener eventListener : (ProcedureListener[])this.listenerList.getListeners(ProcedureListener.class)) {
            switch (e.getId()) {
                case 2: {
                    eventListener.procedureAdded(e);
                    continue block5;
                }
                case 1: {
                    eventListener.procedureChanged(e);
                    continue block5;
                }
                case 3: {
                    eventListener.procedureRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid ProcedureEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireProcedureParameterEvent(ProcedureParameterEvent e) {
        EventListener[] list;
        this.setDirty(true);
        block5: for (EventListener eventListener : list = this.listenerList.getListeners(ProcedureParameterListener.class)) {
            ProcedureParameterListener listener = (ProcedureParameterListener)eventListener;
            switch (e.getId()) {
                case 2: {
                    listener.procedureParameterAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.procedureParameterChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.procedureParameterRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid ProcedureParameterEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireNavigationEvent(EventObject e) {
        int counter;
        ControllerState cs;
        Object source = e.getSource();
        if (source == null) {
            return;
        }
        int size = this.controllerStateHistory.size();
        if (size == 0) {
            return;
        }
        int i = this.controllerStateHistory.indexOf(this.currentState);
        if (size == 1) {
            cs = this.controllerStateHistory.get(0);
        } else if (source instanceof NavigateForwardAction) {
            counter = 0;
            while ((cs = i < 0 ? this.controllerStateHistory.get(0) : (i + 1 < size ? this.controllerStateHistory.get(i + 1) : this.controllerStateHistory.get(0))).isEquivalent(this.currentState) && ++counter <= 5) {
                ++i;
            }
        } else if (source instanceof NavigateBackwardAction) {
            counter = 0;
            while (true) {
                if (i < 0) {
                    try {
                        cs = this.controllerStateHistory.get(size - 2);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        cs = this.controllerStateHistory.get(size - 1);
                    }
                } else {
                    cs = i - 1 >= 0 ? this.controllerStateHistory.get(i - 1) : this.controllerStateHistory.get(size - 1);
                }
                if (cs.isEquivalent(this.currentState) && ++counter <= 5) {
                    --i;
                    continue;
                }
                break;
            }
        } else {
            throw new IllegalStateException("Unknown source for navigation event: " + String.valueOf(e.getSource()));
        }
        this.currentState = cs;
        DisplayEvent de = cs.event;
        if (de == null) {
            return;
        }
        this.currentState.isRefiring = true;
        de.setRefired(true);
        if (de instanceof EntityDisplayEvent) {
            EntityDisplayEvent ede = (EntityDisplayEvent)de;
            ede.setEntityChanged(true);
            if (ede.getEntity() instanceof ObjEntity) {
                this.fireObjEntityDisplayEvent(ede);
            } else if (ede.getEntity() instanceof DbEntity) {
                this.fireDbEntityDisplayEvent(ede);
            }
        } else if (de instanceof EmbeddableDisplayEvent) {
            EmbeddableDisplayEvent ede = (EmbeddableDisplayEvent)de;
            ede.setEmbeddableChanged(true);
            this.fireEmbeddableDisplayEvent(ede);
        } else if (de instanceof ProcedureDisplayEvent) {
            ProcedureDisplayEvent pde = (ProcedureDisplayEvent)de;
            pde.setProcedureChanged(true);
            this.fireProcedureDisplayEvent(pde);
        } else if (de instanceof QueryDisplayEvent) {
            QueryDisplayEvent qde = (QueryDisplayEvent)de;
            qde.setQueryChanged(true);
            this.fireQueryDisplayEvent(qde);
        } else if (de instanceof DataMapDisplayEvent) {
            DataMapDisplayEvent dmde = (DataMapDisplayEvent)de;
            dmde.setDataMapChanged(true);
            this.fireDataMapDisplayEvent(dmde);
        } else if (de instanceof DataNodeDisplayEvent) {
            DataNodeDisplayEvent dnde = (DataNodeDisplayEvent)de;
            dnde.setDataNodeChanged(true);
            this.fireDataNodeDisplayEvent(dnde);
        } else if (de instanceof DomainDisplayEvent) {
            DomainDisplayEvent dde = (DomainDisplayEvent)de;
            dde.setDomainChanged(true);
            this.fireDomainDisplayEvent(dde);
        }
        this.currentState.isRefiring = false;
    }

    public void fireObjEntityDisplayEvent(EntityDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getEntity() != this.currentState.objEntity;
        if (!e.isRefired()) {
            e.setEntityChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.node = e.getDataNode();
                this.currentState.map = e.getDataMap();
                this.currentState.objEntity = (ObjEntity)e.getEntity();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        for (ObjEntityDisplayListener listener : (ObjEntityDisplayListener[])this.listenerList.getListeners(ObjEntityDisplayListener.class)) {
            listener.currentObjEntityChanged(e);
        }
    }

    public void fireEmbeddableDisplayEvent(EmbeddableDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getEmbeddable() != this.currentState.embeddable;
        if (!e.isRefired()) {
            e.setEmbeddableChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.node = e.getDataNode();
                this.currentState.map = e.getDataMap();
                this.currentState.embeddable = e.getEmbeddable();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        for (EmbeddableDisplayListener listener : (EmbeddableDisplayListener[])this.listenerList.getListeners(EmbeddableDisplayListener.class)) {
            listener.currentEmbeddableChanged(e);
        }
    }

    public void fireQueryDisplayEvent(QueryDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getQuery() != this.currentState.query;
        if (!e.isRefired()) {
            e.setQueryChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.query = e.getQuery();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        for (QueryDisplayListener eventListener : (QueryDisplayListener[])this.listenerList.getListeners(QueryDisplayListener.class)) {
            eventListener.currentQueryChanged(e);
        }
    }

    public void fireProcedureDisplayEvent(ProcedureDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getProcedure() != this.currentState.procedure;
        if (!e.isRefired()) {
            e.setProcedureChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.procedure = e.getProcedure();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        for (ProcedureDisplayListener eventListener : (ProcedureDisplayListener[])this.listenerList.getListeners(ProcedureDisplayListener.class)) {
            eventListener.currentProcedureChanged(e);
        }
    }

    public void fireProcedureParameterDisplayEvent(ProcedureParameterDisplayEvent e) {
        EventListener[] list;
        boolean changed;
        boolean bl = changed = !Arrays.equals(e.getProcedureParameters(), this.currentState.procedureParameters);
        if (changed) {
            if (this.currentState.procedure != e.getProcedure()) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.procedure = e.getProcedure();
            }
            this.currentState.procedureParameters = e.getProcedureParameters();
        }
        for (EventListener eventListener : list = this.listenerList.getListeners(ProcedureParameterDisplayListener.class)) {
            ProcedureParameterDisplayListener listener = (ProcedureParameterDisplayListener)eventListener;
            listener.currentProcedureParameterChanged(e);
        }
    }

    public void fireDbEntityDisplayEvent(EntityDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getEntity() != this.currentState.dbEntity;
        if (!e.isRefired()) {
            e.setEntityChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.node = e.getDataNode();
                this.currentState.map = e.getDataMap();
                this.currentState.dbEntity = (DbEntity)e.getEntity();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        for (DbEntityDisplayListener listener : (DbEntityDisplayListener[])this.listenerList.getListeners(DbEntityDisplayListener.class)) {
            listener.currentDbEntityChanged(e);
        }
    }

    public void fireDbAttributeEvent(AttributeEvent e) {
        this.setDirty(true);
        block5: for (DbAttributeListener listener : (DbAttributeListener[])this.listenerList.getListeners(DbAttributeListener.class)) {
            switch (e.getId()) {
                case 2: {
                    listener.dbAttributeAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.dbAttributeChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.dbAttributeRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid AttributeEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireDbAttributeDisplayEvent(AttributeDisplayEvent e) {
        boolean changed;
        boolean bl = changed = !Arrays.equals(e.getAttributes(), this.currentState.dbAttrs);
        if (changed) {
            if (e.getEntity() != this.currentState.dbEntity) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.dbEntity = (DbEntity)e.getEntity();
            }
            this.currentState.dbAttrs = new DbAttribute[e.getAttributes().length];
            System.arraycopy(e.getAttributes(), 0, this.currentState.dbAttrs, 0, this.currentState.dbAttrs.length);
        }
        for (DbAttributeDisplayListener listener : (DbAttributeDisplayListener[])this.listenerList.getListeners(DbAttributeDisplayListener.class)) {
            listener.currentDbAttributeChanged(e);
        }
    }

    public void fireObjAttributeEvent(AttributeEvent e) {
        this.setDirty(true);
        block5: for (ObjAttributeListener listener : (ObjAttributeListener[])this.listenerList.getListeners(ObjAttributeListener.class)) {
            switch (e.getId()) {
                case 2: {
                    listener.objAttributeAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.objAttributeChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.objAttributeRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid AttributeEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireObjAttributeDisplayEvent(AttributeDisplayEvent e) {
        EventListener[] list;
        boolean changed;
        boolean bl = changed = !Arrays.equals(e.getAttributes(), this.currentState.objAttrs);
        if (changed) {
            if (e.getEntity() != this.currentState.objEntity) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.objEntity = (ObjEntity)e.getEntity();
            }
            this.currentState.objAttrs = new ObjAttribute[e.getAttributes().length];
            System.arraycopy(e.getAttributes(), 0, this.currentState.objAttrs, 0, this.currentState.objAttrs.length);
        }
        for (EventListener listener : list = this.listenerList.getListeners(ObjAttributeDisplayListener.class)) {
            ObjAttributeDisplayListener temp = (ObjAttributeDisplayListener)listener;
            temp.currentObjAttributeChanged(e);
        }
    }

    public void fireEmbeddableAttributeDisplayEvent(EmbeddableAttributeDisplayEvent ev) {
        EventListener[] list;
        boolean changed;
        boolean bl = changed = !Arrays.equals(ev.getEmbeddableAttributes(), this.currentState.embAttrs);
        if (changed) {
            if (ev.getEmbeddable() != this.currentState.embeddable) {
                this.clearState();
                this.currentState.domain = ev.getDomain();
                this.currentState.map = ev.getDataMap();
                this.currentState.embeddable = ev.getEmbeddable();
            }
            this.currentState.embAttrs = new EmbeddableAttribute[ev.getEmbeddableAttributes().length];
            System.arraycopy(ev.getEmbeddableAttributes(), 0, this.currentState.embAttrs, 0, this.currentState.embAttrs.length);
        }
        for (EventListener listener : list = this.listenerList.getListeners(EmbeddableAttributeDisplayListener.class)) {
            EmbeddableAttributeDisplayListener temp = (EmbeddableAttributeDisplayListener)listener;
            temp.currentEmbeddableAttributeChanged(ev);
        }
    }

    public void fireDbRelationshipEvent(RelationshipEvent e) {
        this.setDirty(true);
        if (e.getId() == 1 && e.getEntity() instanceof DbEntity) {
            ((DbEntity)e.getEntity()).dbRelationshipChanged(e);
        }
        block5: for (DbRelationshipListener listener : (DbRelationshipListener[])this.listenerList.getListeners(DbRelationshipListener.class)) {
            switch (e.getId()) {
                case 2: {
                    listener.dbRelationshipAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.dbRelationshipChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.dbRelationshipRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid RelationshipEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireDbRelationshipDisplayEvent(RelationshipDisplayEvent e) {
        boolean changed;
        boolean bl = changed = !Arrays.equals(e.getRelationships(), this.currentState.dbRels);
        if (changed) {
            if (e.getEntity() != this.currentState.dbEntity) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.dbEntity = (DbEntity)e.getEntity();
            }
            this.currentState.dbRels = new DbRelationship[e.getRelationships().length];
            System.arraycopy(e.getRelationships(), 0, this.currentState.dbRels, 0, this.currentState.dbRels.length);
        }
        for (DbRelationshipDisplayListener listener : (DbRelationshipDisplayListener[])this.listenerList.getListeners(DbRelationshipDisplayListener.class)) {
            listener.currentDbRelationshipChanged(e);
        }
    }

    public void fireObjRelationshipEvent(RelationshipEvent e) {
        this.setDirty(true);
        block5: for (ObjRelationshipListener listener : (ObjRelationshipListener[])this.listenerList.getListeners(ObjRelationshipListener.class)) {
            switch (e.getId()) {
                case 2: {
                    listener.objRelationshipAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.objRelationshipChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.objRelationshipRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid RelationshipEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireMultipleObjectsDisplayEvent(MultipleObjectsDisplayEvent e) {
        EventListener[] list;
        this.clearState();
        this.currentState.paths = e.getNodes();
        this.currentState.parentPath = e.getParentNode();
        for (EventListener listener : list = this.listenerList.getListeners(MultipleObjectsDisplayListener.class)) {
            MultipleObjectsDisplayListener temp = (MultipleObjectsDisplayListener)listener;
            temp.currentObjectsChanged(e, this.getApplication());
        }
    }

    public void fireObjRelationshipDisplayEvent(RelationshipDisplayEvent e) {
        boolean changed = !Arrays.equals(e.getRelationships(), this.currentState.objRels);
        e.setRelationshipChanged(changed);
        if (changed) {
            if (e.getEntity() != this.currentState.objEntity) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.objEntity = (ObjEntity)e.getEntity();
            }
            this.currentState.objRels = new ObjRelationship[e.getRelationships().length];
            System.arraycopy(e.getRelationships(), 0, this.currentState.objRels, 0, this.currentState.objRels.length);
        }
        for (ObjRelationshipDisplayListener listener : (ObjRelationshipDisplayListener[])this.listenerList.getListeners(ObjRelationshipDisplayListener.class)) {
            listener.currentObjRelationshipChanged(e);
        }
    }

    public void addDataMap(Object src, DataMap map) {
        this.addDataMap(src, map, true);
    }

    public void addDataMap(Object src, DataMap map, boolean makeCurrent) {
        map.setDataChannelDescriptor(this.currentState.domain);
        this.currentState.domain.getDataMaps().add(map);
        if (this.currentState.node != null && !this.currentState.node.getDataMapNames().contains(map.getName())) {
            this.currentState.node.getDataMapNames().add(map.getName());
            this.fireDataNodeEvent(new DataNodeEvent((Object)this, this.currentState.node));
        }
        this.fireDataMapEvent(new DataMapEvent(src, map, 2));
        if (makeCurrent) {
            this.fireDataMapDisplayEvent(new DataMapDisplayEvent(src, map, this.currentState.domain, this.currentState.node));
        }
    }

    public void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            this.enableSave(dirty);
            this.application.getActionManager().getAction(RevertAction.class).setEnabled(dirty);
            if (dirty) {
                ((CayenneModelerController)this.getParent()).projectModifiedAction();
            }
        }
    }

    public String getCurrentListenerClass() {
        return this.currentState.listenerClass;
    }

    public CallbackType getCurrentCallbackType() {
        return this.currentState.callbackType;
    }

    public ObjCallbackMethod[] getCurrentCallbackMethods() {
        return this.currentState.callbackMethods;
    }

    public void setCurrentListenerClass(String listenerClass) {
        this.currentState.listenerClass = listenerClass;
    }

    public void setCurrentCallbackType(CallbackType callbackType) {
        this.currentState.callbackType = callbackType;
    }

    public void setCurrentCallbackMethods(ObjCallbackMethod[] callbackMethods) {
        this.currentState.callbackMethods = callbackMethods;
    }

    public void addCallbackMethodListener(CallbackMethodListener listener) {
        this.listenerList.add(CallbackMethodListener.class, listener);
    }

    public void fireCallbackMethodEvent(CallbackMethodEvent e) {
        this.setDirty(true);
        block5: for (CallbackMethodListener listener : (CallbackMethodListener[])this.listenerList.getListeners(CallbackMethodListener.class)) {
            switch (e.getId()) {
                case 2: {
                    listener.callbackMethodAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.callbackMethodChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.callbackMethodRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid CallbackEvent type: " + e.getId());
                }
            }
        }
    }

    public void addEntityListenerListener(EntityListenerListener listener) {
        this.listenerList.add(EntityListenerListener.class, listener);
    }

    public void fireEntityListenerEvent(EntityListenerEvent e) {
        this.setDirty(true);
        block5: for (EntityListenerListener listener : (EntityListenerListener[])this.listenerList.getListeners(EntityListenerListener.class)) {
            switch (e.getId()) {
                case 2: {
                    listener.entityListenerAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.entityListenerChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.entityListenerRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid CallbackEvent type: " + e.getId());
                }
            }
        }
    }

    public ProjectFileChangeTracker getFileChangeTracker() {
        return this.fileChangeTracker;
    }

    public Object getCurrentObject() {
        if (this.getCurrentObjEntity() != null) {
            return this.getCurrentObjEntity();
        }
        if (this.getCurrentDbEntity() != null) {
            return this.getCurrentDbEntity();
        }
        if (this.getCurrentEmbeddable() != null) {
            return this.getCurrentEmbeddable();
        }
        if (this.getCurrentQuery() != null) {
            return this.getCurrentQuery();
        }
        if (this.getCurrentProcedure() != null) {
            return this.getCurrentProcedure();
        }
        if (this.getCurrentDataMap() != null) {
            return this.getCurrentDataMap();
        }
        if (this.getCurrentDataNode() != null) {
            return this.getCurrentDataNode();
        }
        if (this.getCurrentDataChanel() != null) {
            return this.getCurrentDataChanel();
        }
        if (this.getCurrentPaths() != null) {
            ConfigurationNode[] paths = this.getCurrentPaths();
            ConfigurationNodeParentGetter parentGetter = this.getApplication().getInjector().getInstance(ConfigurationNodeParentGetter.class);
            ConfigurationNode parent = parentGetter.getParent(paths[0]);
            ArrayList<ConfigurationNode> result = new ArrayList<ConfigurationNode>(Arrays.asList(paths));
            result.sort(parent instanceof DataMap ? Comparators.getDataMapChildrenComparator() : Comparators.getDataDomainChildrenComparator());
            return result;
        }
        return null;
    }

    public void addEmbeddableAttributeListener(EmbeddableAttributeListener listener) {
        this.listenerList.add(EmbeddableAttributeListener.class, listener);
    }

    public void addEmbeddableListener(EmbeddableListener listener) {
        this.listenerList.add(EmbeddableListener.class, listener);
    }

    public void fireEmbeddableEvent(EmbeddableEvent e, DataMap map) {
        this.setDirty(true);
        block5: for (EmbeddableListener listener : (EmbeddableListener[])this.listenerList.getListeners(EmbeddableListener.class)) {
            switch (e.getId()) {
                case 2: {
                    listener.embeddableAdded(e, map);
                    continue block5;
                }
                case 1: {
                    listener.embeddableChanged(e, map);
                    continue block5;
                }
                case 3: {
                    listener.embeddableRemoved(e, map);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid RelationshipEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireEmbeddableAttributeEvent(EmbeddableAttributeEvent e) {
        this.setDirty(true);
        block5: for (EmbeddableAttributeListener listener : (EmbeddableAttributeListener[])this.listenerList.getListeners(EmbeddableAttributeListener.class)) {
            switch (e.getId()) {
                case 2: {
                    listener.embeddableAttributeAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.embeddableAttributeChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.embeddableAttributeRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid RelationshipEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireProjectOnSaveEvent(ProjectOnSaveEvent e) {
        for (ProjectOnSaveListener listener : (ProjectOnSaveListener[])this.listenerList.getListeners(ProjectOnSaveListener.class)) {
            listener.beforeSaveChanges(e);
        }
    }

    public void addDataSourceModificationListener(DataSourceModificationListener listener) {
        this.listenerList.add(DataSourceModificationListener.class, listener);
    }

    public void removeDataSourceModificationListener(DataSourceModificationListener listener) {
        this.listenerList.remove(DataSourceModificationListener.class, listener);
    }

    public void fireDataSourceModificationEvent(DataSourceModificationEvent e) {
        block4: for (DataSourceModificationListener listener : (DataSourceModificationListener[])this.listenerList.getListeners(DataSourceModificationListener.class)) {
            switch (e.getId()) {
                case 2: {
                    listener.callbackDataSourceAdded(e);
                    continue block4;
                }
                case 3: {
                    listener.callbackDataSourceRemoved(e);
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Invalid RelationshipEvent type: " + e.getId());
                }
            }
        }
    }

    public ArrayList<Embeddable> getEmbeddablesInCurrentDataDomain() {
        DataChannelDescriptor dataChannelDescriptor = (DataChannelDescriptor)this.getProject().getRootNode();
        Collection<DataMap> maps = dataChannelDescriptor.getDataMaps();
        Iterator<DataMap> it = maps.iterator();
        ArrayList<Embeddable> embs = new ArrayList<Embeddable>();
        while (it.hasNext()) {
            embs.addAll(it.next().getEmbeddables());
        }
        return embs;
    }

    public Set<String> getEmbeddableNamesInCurrentDataDomain() {
        ArrayList<Embeddable> embs = this.getEmbeddablesInCurrentDataDomain();
        HashSet<String> embNames = new HashSet<String>(embs.size());
        for (Embeddable emb : embs) {
            embNames.add(emb.getClassName());
        }
        return embNames;
    }

    public void updateProjectControllerPreferences() {
        String key = this.getProject().getConfigurationResource() == null ? new String(IDUtil.pseudoUniqueByteSequence16()) : this.project.getConfigurationResource().getURL().getPath();
        this.projectControllerPreferences = Preferences.userNodeForPackage(Project.class);
        if (key.trim().length() > 0) {
            this.projectControllerPreferences = key.contains(".xml") ? this.projectControllerPreferences.node(this.projectControllerPreferences.absolutePath() + key.replace(".xml", "")) : this.projectControllerPreferences.node(this.projectControllerPreferences.absolutePath()).node(this.getApplication().getNewProjectTemporaryName());
        }
    }

    public int getEntityTabSelection() {
        return this.entityTabSelection;
    }

    public void setEntityTabSelection(int entityTabSelection) {
        this.entityTabSelection = entityTabSelection;
    }

    public void enableSave(boolean enable) {
        this.application.getActionManager().getAction(SaveAction.class).setEnabled(enable);
        this.application.getActionManager().getAction(SaveAsAction.class).setEnabled(enable);
    }

    public void setCurrentObjAttributes(ObjAttribute[] attrs) {
        this.currentState.objAttrs = attrs;
    }

    public void setCurrentObjRelationships(ObjRelationship[] rels) {
        this.currentState.objRels = rels;
    }

    public void setCurrentDbAttributes(DbAttribute[] attrs) {
        this.currentState.dbAttrs = attrs;
    }

    public void setCurrentDbRelationships(DbRelationship[] rels) {
        this.currentState.dbRels = rels;
    }

    public static class ControllerState {
        private boolean isRefiring;
        private DisplayEvent event;
        private DataChannelDescriptor domain;
        private DataNodeDescriptor node;
        private DataMap map;
        private ObjEntity objEntity;
        private DbEntity dbEntity;
        private Embeddable embeddable;
        private EmbeddableAttribute[] embAttrs = new EmbeddableAttribute[0];
        private ObjAttribute[] objAttrs;
        private DbAttribute[] dbAttrs = new DbAttribute[0];
        private ObjRelationship[] objRels;
        private DbRelationship[] dbRels = new DbRelationship[0];
        private Procedure procedure;
        private ProcedureParameter[] procedureParameters = new ProcedureParameter[0];
        private QueryDescriptor query;
        private ConfigurationNode[] paths;
        private ConfigurationNode parentPath;
        private String listenerClass;
        private CallbackType callbackType;
        private ObjCallbackMethod[] callbackMethods;

        public ControllerState() {
            this.objAttrs = new ObjAttribute[0];
            this.objRels = new ObjRelationship[0];
            this.callbackMethods = new ObjCallbackMethod[0];
        }

        public boolean isEquivalent(ControllerState val) {
            if (val == null) {
                return false;
            }
            if (this.event instanceof EntityDisplayEvent && val.event instanceof EntityDisplayEvent) {
                if (((EntityDisplayEvent)val.event).getEntity() instanceof ObjEntity) {
                    return this.objEntity == val.objEntity;
                }
                return this.dbEntity == val.dbEntity;
            }
            if (this.event instanceof ProcedureDisplayEvent && val.event instanceof ProcedureDisplayEvent) {
                return this.procedure == val.procedure;
            }
            if (this.event instanceof QueryDisplayEvent && val.event instanceof QueryDisplayEvent) {
                return this.query == val.query;
            }
            if (this.event instanceof EmbeddableDisplayEvent && val.event instanceof EmbeddableDisplayEvent) {
                return this.embeddable == val.embeddable;
            }
            if (this.event.getClass() == DataMapDisplayEvent.class && this.event.getClass() == val.event.getClass()) {
                return this.map == val.map;
            }
            if (this.event.getClass() == DataNodeDisplayEvent.class && this.event.getClass() == val.event.getClass()) {
                return this.node == val.node;
            }
            if (this.event.getClass() == DomainDisplayEvent.class && this.event.getClass() == val.event.getClass()) {
                return this.domain == val.domain;
            }
            return false;
        }
    }
}

