/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.EmbeddableObject;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.exp.property.BaseIdProperty;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.EmbeddableProperty;
import org.apache.cayenne.exp.property.EntityProperty;
import org.apache.cayenne.exp.property.ListProperty;
import org.apache.cayenne.exp.property.MapProperty;
import org.apache.cayenne.exp.property.NumericIdProperty;
import org.apache.cayenne.exp.property.PathProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.PropertyUtils;
import org.apache.cayenne.exp.property.SetProperty;
import org.apache.cayenne.query.PrefetchTreeNode;

public interface RelationshipProperty<E>
extends PathProperty<E> {
    public BaseProperty<E> outer();

    default public PrefetchTreeNode joint() {
        if (!this.getExpression().getPathAliases().isEmpty()) {
            throw new CayenneRuntimeException("Can't use aliases with prefetch", new Object[0]);
        }
        return PrefetchTreeNode.withPath(this.getPath(), 1);
    }

    default public PrefetchTreeNode disjoint() {
        if (!this.getExpression().getPathAliases().isEmpty()) {
            throw new CayenneRuntimeException("Can't use aliases with prefetch", new Object[0]);
        }
        return PrefetchTreeNode.withPath(this.getPath(), 2);
    }

    default public PrefetchTreeNode disjointById() {
        if (!this.getExpression().getPathAliases().isEmpty()) {
            throw new CayenneRuntimeException("Can't use aliases with prefetch", new Object[0]);
        }
        return PrefetchTreeNode.withPath(this.getPath(), 3);
    }

    @Override
    default public <T> BaseIdProperty<T> dot(BaseIdProperty<T> property) {
        return PropertyFactory.createBaseId(property.getAttributeName(), this.getPath(), property.getEntityName(), property.getType());
    }

    @Override
    default public <T extends Number> NumericIdProperty<T> dot(NumericIdProperty<T> property) {
        return PropertyFactory.createNumericId(property.getAttributeName(), this.getPath(), property.getEntityName(), property.getType());
    }

    @Override
    default public <T extends Persistent> EntityProperty<T> dot(EntityProperty<T> property) {
        CayennePath path = this.getPath().dot(property.getPath());
        return PropertyFactory.createEntity(path, (Expression)PropertyUtils.buildExp(path, this.getExpression().getPathAliases()), property.getType());
    }

    @Override
    default public <T extends Persistent> ListProperty<T> dot(ListProperty<T> property) {
        CayennePath path = this.getPath().dot(property.getPath());
        return PropertyFactory.createList(path, (Expression)PropertyUtils.buildExp(path, this.getExpression().getPathAliases()), property.getEntityType());
    }

    @Override
    default public <T extends Persistent> SetProperty<T> dot(SetProperty<T> property) {
        CayennePath path = this.getPath().dot(property.getPath());
        return PropertyFactory.createSet(path, (Expression)PropertyUtils.buildExp(path, this.getExpression().getPathAliases()), property.getEntityType());
    }

    default public <K, V extends Persistent> MapProperty<K, V> dot(MapProperty<K, V> property) {
        CayennePath path = this.getPath().dot(property.getPath());
        return PropertyFactory.createMap(path, (Expression)PropertyUtils.buildExp(path, this.getExpression().getPathAliases()), property.getKeyType(), property.getEntityType());
    }

    @Override
    default public <T extends EmbeddableObject> EmbeddableProperty<T> dot(EmbeddableProperty<T> property) {
        CayennePath path = this.getPath().dot(property.getPath());
        return PropertyFactory.createEmbeddable(path, (Expression)PropertyUtils.buildExp(path, this.getExpression().getPathAliases()), property.getType());
    }

    default public Expression exists() {
        return ExpressionFactory.exists(this.getExpression());
    }

    default public Expression notExists() {
        return ExpressionFactory.notExists(this.getExpression());
    }
}

