package org.apache.cayenne.testdo.reflexive.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

import org.apache.cayenne.PersistentObject;
import org.apache.cayenne.exp.property.EntityProperty;
import org.apache.cayenne.exp.property.ListProperty;
import org.apache.cayenne.exp.property.NumericIdProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.SelfProperty;
import org.apache.cayenne.exp.property.StringProperty;
import org.apache.cayenne.testdo.reflexive.Other;
import org.apache.cayenne.testdo.reflexive.Reflexive;

/**
 * Class _Reflexive was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _Reflexive extends PersistentObject {

    private static final long serialVersionUID = 1L;

    public static final SelfProperty<Reflexive> SELF = PropertyFactory.createSelf(Reflexive.class);

    public static final NumericIdProperty<Integer> ID_PK_PROPERTY = PropertyFactory.createNumericId("ID", "Reflexive", Integer.class);
    public static final String ID_PK_COLUMN = "ID";

    public static final StringProperty<String> NAME = PropertyFactory.createString("name", String.class);
    public static final ListProperty<Reflexive> CHILDREN = PropertyFactory.createList("children", Reflexive.class);
    public static final EntityProperty<Other> TO_OTHER = PropertyFactory.createEntity("toOther", Other.class);
    public static final EntityProperty<Reflexive> TO_PARENT = PropertyFactory.createEntity("toParent", Reflexive.class);

    protected String name;

    protected Object children;
    protected Object toOther;
    protected Object toParent;

    public void setName(String name) {
        beforePropertyWrite("name", this.name, name);
        this.name = name;
    }

    public String getName() {
        beforePropertyRead("name");
        return this.name;
    }

    public void addToChildren(Reflexive obj) {
        addToManyTarget("children", obj, true);
    }

    public void removeFromChildren(Reflexive obj) {
        removeToManyTarget("children", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<Reflexive> getChildren() {
        return (List<Reflexive>)readProperty("children");
    }

    public void setToOther(Other toOther) {
        setToOneTarget("toOther", toOther, true);
    }

    public Other getToOther() {
        return (Other)readProperty("toOther");
    }

    public void setToParent(Reflexive toParent) {
        setToOneTarget("toParent", toParent, true);
    }

    public Reflexive getToParent() {
        return (Reflexive)readProperty("toParent");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "name":
                return this.name;
            case "children":
                return this.children;
            case "toOther":
                return this.toOther;
            case "toParent":
                return this.toParent;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "name":
                this.name = (String)val;
                break;
            case "children":
                this.children = val;
                break;
            case "toOther":
                this.toOther = val;
                break;
            case "toParent":
                this.toParent = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.name);
        out.writeObject(this.children);
        out.writeObject(this.toOther);
        out.writeObject(this.toParent);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.name = (String)in.readObject();
        this.children = in.readObject();
        this.toOther = in.readObject();
        this.toParent = in.readObject();
    }

}
