package org.apache.cayenne.testdo.mt.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

import org.apache.cayenne.PersistentObject;
import org.apache.cayenne.exp.property.ListProperty;
import org.apache.cayenne.exp.property.NumericIdProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.SelfProperty;
import org.apache.cayenne.exp.property.StringProperty;
import org.apache.cayenne.testdo.mt.MtTable1;
import org.apache.cayenne.testdo.mt.MtTable2;

/**
 * Class _MtTable1 was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _MtTable1 extends PersistentObject {

    private static final long serialVersionUID = 1L;

    public static final SelfProperty<MtTable1> SELF = PropertyFactory.createSelf(MtTable1.class);

    public static final NumericIdProperty<Integer> TABLE1_ID_PK_PROPERTY = PropertyFactory.createNumericId("TABLE1_ID", "MtTable1", Integer.class);
    public static final String TABLE1_ID_PK_COLUMN = "TABLE1_ID";

    public static final StringProperty<String> GLOBAL_ATTRIBUTE1 = PropertyFactory.createString("globalAttribute1", String.class);
    public static final StringProperty<String> SERVER_ATTRIBUTE1 = PropertyFactory.createString("serverAttribute1", String.class);
    public static final ListProperty<MtTable2> TABLE2ARRAY = PropertyFactory.createList("table2Array", MtTable2.class);

    protected String globalAttribute1;
    protected String serverAttribute1;

    protected Object table2Array;

    public void setGlobalAttribute1(String globalAttribute1) {
        beforePropertyWrite("globalAttribute1", this.globalAttribute1, globalAttribute1);
        this.globalAttribute1 = globalAttribute1;
    }

    public String getGlobalAttribute1() {
        beforePropertyRead("globalAttribute1");
        return this.globalAttribute1;
    }

    public void setServerAttribute1(String serverAttribute1) {
        beforePropertyWrite("serverAttribute1", this.serverAttribute1, serverAttribute1);
        this.serverAttribute1 = serverAttribute1;
    }

    public String getServerAttribute1() {
        beforePropertyRead("serverAttribute1");
        return this.serverAttribute1;
    }

    public void addToTable2Array(MtTable2 obj) {
        addToManyTarget("table2Array", obj, true);
    }

    public void removeFromTable2Array(MtTable2 obj) {
        removeToManyTarget("table2Array", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<MtTable2> getTable2Array() {
        return (List<MtTable2>)readProperty("table2Array");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "globalAttribute1":
                return this.globalAttribute1;
            case "serverAttribute1":
                return this.serverAttribute1;
            case "table2Array":
                return this.table2Array;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "globalAttribute1":
                this.globalAttribute1 = (String)val;
                break;
            case "serverAttribute1":
                this.serverAttribute1 = (String)val;
                break;
            case "table2Array":
                this.table2Array = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.globalAttribute1);
        out.writeObject(this.serverAttribute1);
        out.writeObject(this.table2Array);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.globalAttribute1 = (String)in.readObject();
        this.serverAttribute1 = (String)in.readObject();
        this.table2Array = in.readObject();
    }

}
