package org.apache.cayenne.testdo.inheritance_people.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.apache.cayenne.BaseDataObject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.EntityProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.StringProperty;
import org.apache.cayenne.testdo.inheritance_people.AbstractPerson;

/**
 * Class _PersonNotes was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _PersonNotes extends BaseDataObject {

    private static final long serialVersionUID = 1L; 

    public static final NumericProperty<Integer> ID_PK_PROPERTY = PropertyFactory.createNumeric(ExpressionFactory.dbPathExp("ID"), Integer.class);
    public static final String ID_PK_COLUMN = "ID";

    public static final StringProperty<String> NOTES = PropertyFactory.createString("notes", String.class);
    public static final EntityProperty<AbstractPerson> PERSON = PropertyFactory.createEntity("person", AbstractPerson.class);

    protected String notes;

    protected Object person;

    public void setNotes(String notes) {
        beforePropertyWrite("notes", this.notes, notes);
        this.notes = notes;
    }

    public String getNotes() {
        beforePropertyRead("notes");
        return this.notes;
    }

    public void setPerson(AbstractPerson person) {
        setToOneTarget("person", person, true);
    }

    public AbstractPerson getPerson() {
        return (AbstractPerson)readProperty("person");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "notes":
                return this.notes;
            case "person":
                return this.person;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "notes":
                this.notes = (String)val;
                break;
            case "person":
                this.person = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.notes);
        out.writeObject(this.person);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.notes = (String)in.readObject();
        this.person = in.readObject();
    }

}
