/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.dbsync.filter.NameFilter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjEntity;

class CayenneGeneratorEntityFilterAction {
    private NameFilter nameFilter;
    private boolean client;

    CayenneGeneratorEntityFilterAction() {
    }

    Collection<Embeddable> getFilteredEmbeddables(DataMap mainDataMap) {
        ArrayList<Embeddable> embeddables = new ArrayList<Embeddable>(mainDataMap.getEmbeddables());
        Iterator it = embeddables.iterator();
        while (it.hasNext()) {
            Embeddable e = (Embeddable)it.next();
            if (this.nameFilter.isIncluded(e.getClassName())) continue;
            it.remove();
        }
        return embeddables;
    }

    Collection<ObjEntity> getFilteredEntities(DataMap mainDataMap) throws MalformedURLException {
        ArrayList<ObjEntity> entities = new ArrayList<ObjEntity>(mainDataMap.getObjEntities());
        Iterator it = entities.iterator();
        while (it.hasNext()) {
            ObjEntity e = (ObjEntity)it.next();
            if (!e.isGeneric() && (!this.client || e.isClientAllowed()) && this.nameFilter.isIncluded(e.getName())) continue;
            it.remove();
        }
        return entities;
    }

    void setClient(boolean client) {
        this.client = client;
    }

    public void setNameFilter(NameFilter nameFilter) {
        this.nameFilter = nameFilter;
    }
}

