/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.types.ExtendedType;

public class CharType
implements ExtendedType<String> {
    private static final int BUF_SIZE = 8192;
    private static final int TRIM_VALUES_THRESHOLD = 30;
    protected boolean trimmingChars;
    protected boolean usingClobs;

    public CharType(boolean trimmingChars, boolean usingClobs) {
        this.trimmingChars = trimmingChars;
        this.usingClobs = usingClobs;
    }

    @Override
    public String getClassName() {
        return String.class.getName();
    }

    @Override
    public String materializeObject(ResultSet rs, int index, int type) throws Exception {
        if (type == 2005 || type == 2011) {
            return this.isUsingClobs() ? this.readClob(rs.getClob(index)) : this.readCharStream(rs, index);
        }
        return this.handleString(rs.getString(index), type);
    }

    @Override
    public String materializeObject(CallableStatement cs, int index, int type) throws Exception {
        if (type == 2005 || type == 2011) {
            if (!this.isUsingClobs()) {
                throw new CayenneException("Character streams are not supported in stored procedure parameters.", new Object[0]);
            }
            return this.readClob(cs.getClob(index));
        }
        return this.handleString(cs.getString(index), type);
    }

    private String handleString(String val, int type) throws SQLException {
        if (val != null && (type == 1 || type == -15) && this.isTrimmingChars()) {
            return this.rtrim(val);
        }
        return val;
    }

    protected String rtrim(String value) {
        int end2;
        int count = end2 = value.length() - 1;
        while (end2 >= 0 && value.charAt(end2) <= ' ') {
            --end2;
        }
        return end2 == count ? value : value.substring(0, end2 + 1);
    }

    @Override
    public void setJdbcObject(PreparedStatement st, String value, int pos, int type, int scale) throws Exception {
        if (type == 2005 || type == 2011) {
            st.setString(pos, value);
        } else if (scale != -1) {
            st.setObject(pos, (Object)value, type, scale);
        } else {
            st.setObject(pos, (Object)value, type);
        }
    }

    @Override
    public String toString(String value) {
        if (value == null) {
            return "NULL";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('\'');
        String literal = value;
        if (literal.length() > 30) {
            literal = literal.substring(0, 30) + "...";
        }
        int curPos = 0;
        int endPos = 0;
        while ((endPos = literal.indexOf(39, curPos)) >= 0) {
            buffer.append(literal.substring(curPos, endPos + 1)).append('\'');
            curPos = endPos + 1;
        }
        if (curPos < literal.length()) {
            buffer.append(literal.substring(curPos));
        }
        buffer.append('\'');
        return buffer.toString();
    }

    protected String readClob(Clob clob) throws IOException, SQLException {
        if (clob == null) {
            return null;
        }
        if (clob.length() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("CLOB is too big to be read as String in memory: " + clob.length());
        }
        int size = (int)clob.length();
        if (size == 0) {
            return "";
        }
        return clob.getSubString(1L, size);
    }

    protected String readCharStream(ResultSet rs, int index) throws IOException, SQLException {
        try (Reader in = rs.getCharacterStream(index);){
            String string = in != null ? this.readValueStream(in, -1, 8192) : null;
            return string;
        }
    }

    protected String readValueStream(Reader in, int streamSize, int bufSize) throws IOException {
        int read;
        StringWriter out;
        char[] buf = new char[bufSize];
        StringWriter stringWriter = out = streamSize > 0 ? new StringWriter(streamSize) : new StringWriter();
        while ((read = in.read(buf, 0, bufSize)) >= 0) {
            out.write(buf, 0, read);
        }
        return out.toString();
    }

    public boolean isTrimmingChars() {
        return this.trimmingChars;
    }

    public void setTrimmingChars(boolean trimingChars) {
        this.trimmingChars = trimingChars;
    }

    public boolean isUsingClobs() {
        return this.usingClobs;
    }

    public void setUsingClobs(boolean usingClobs) {
        this.usingClobs = usingClobs;
    }
}

