/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.util.XMLEncoder;

public class SQLTemplateDescriptor
extends QueryDescriptor {
    protected String sql;
    protected Map<String, String> adapterSql = new HashMap<String, String>();

    public SQLTemplateDescriptor() {
        super("SQLTemplate");
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public Map<String, String> getAdapterSql() {
        return this.adapterSql;
    }

    public void setAdapterSql(Map<String, String> adapterSql) {
        this.adapterSql = adapterSql;
    }

    @Override
    public SQLTemplate buildQuery() {
        SQLTemplate template = new SQLTemplate();
        if (this.root != null) {
            template.setRoot(this.root);
        }
        template.setName(this.name);
        template.setDataMap(this.dataMap);
        template.initWithProperties(this.getProperties());
        template.setDefaultTemplate(this.getSql());
        Map<String, String> adapterSql = this.getAdapterSql();
        if (adapterSql != null) {
            for (Map.Entry<String, String> entry : adapterSql.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key == null || value == null) continue;
                template.setTemplate(key, value);
            }
        }
        return template;
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<query name=\"");
        encoder.print(this.getName());
        encoder.print("\" type=\"");
        encoder.print(this.type);
        String rootString = null;
        String rootType = null;
        if (this.root instanceof String) {
            rootType = "obj-entity";
            rootString = this.root.toString();
        } else if (this.root instanceof ObjEntity) {
            rootType = "obj-entity";
            rootString = ((ObjEntity)this.root).getName();
        } else if (this.root instanceof DbEntity) {
            rootType = "db-entity";
            rootString = ((DbEntity)this.root).getName();
        } else if (this.root instanceof Procedure) {
            rootType = "procedure";
            rootString = ((Procedure)this.root).getName();
        } else if (this.root instanceof Class) {
            rootType = "java-class";
            rootString = ((Class)this.root).getName();
        } else if (this.root instanceof DataMap) {
            rootType = "data-map";
            rootString = ((DataMap)this.root).getName();
        }
        if (rootType != null) {
            encoder.print("\" root=\"");
            encoder.print(rootType);
            encoder.print("\" root-name=\"");
            encoder.print(rootString);
        }
        encoder.println("\">");
        encoder.indent(1);
        this.encodeProperties(encoder);
        if (this.sql != null) {
            encoder.print("<sql><![CDATA[");
            encoder.print(this.sql);
            encoder.println("]]></sql>");
        }
        if (this.adapterSql != null && !this.adapterSql.isEmpty()) {
            TreeSet<String> keys = new TreeSet<String>(this.adapterSql.keySet());
            for (String key : keys) {
                String sql;
                String value = this.adapterSql.get(key);
                if (key == null || value == null || (sql = value.trim()).length() <= 0) continue;
                encoder.print("<sql adapter-class=\"");
                encoder.print(key);
                encoder.print("\"><![CDATA[");
                encoder.print(sql);
                encoder.println("]]></sql>");
            }
        }
        encoder.indent(-1);
        encoder.println("</query>");
    }
}

