/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.data;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import org.apache.cassandra.sidecar.common.server.data.QualifiedTableName;
import org.apache.cassandra.sidecar.handlers.data.SSTableUploads;
import org.apache.cassandra.sidecar.utils.RequestUtils;

public class SSTableImportRequestParam
extends SSTableUploads {
    private final boolean resetLevel;
    private final boolean clearRepaired;
    private final boolean verifySSTables;
    private final boolean verifyTokens;
    private final boolean invalidateCaches;
    private final boolean extendedVerify;
    private final boolean copyData;

    public SSTableImportRequestParam(QualifiedTableName qualifiedTableName, String uploadId, boolean resetLevel, boolean clearRepaired, boolean verifySSTables, boolean verifyTokens, boolean invalidateCaches, boolean extendedVerify, boolean copyData) {
        super(qualifiedTableName, uploadId);
        this.resetLevel = resetLevel;
        this.clearRepaired = clearRepaired;
        this.verifySSTables = verifySSTables;
        this.verifyTokens = verifyTokens;
        this.invalidateCaches = invalidateCaches;
        this.extendedVerify = extendedVerify;
        this.copyData = copyData;
    }

    public boolean resetLevel() {
        return this.resetLevel;
    }

    public boolean clearRepaired() {
        return this.clearRepaired;
    }

    public boolean verifySSTables() {
        return this.verifySSTables;
    }

    public boolean verifyTokens() {
        return this.verifyTokens;
    }

    public boolean invalidateCaches() {
        return this.invalidateCaches;
    }

    public boolean extendedVerify() {
        return this.extendedVerify;
    }

    public boolean copyData() {
        return this.copyData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SSTableImportRequestParam that = (SSTableImportRequestParam)o;
        return this.resetLevel == that.resetLevel && this.clearRepaired == that.clearRepaired && this.verifySSTables == that.verifySSTables && this.verifyTokens == that.verifyTokens && this.invalidateCaches == that.invalidateCaches && this.extendedVerify == that.extendedVerify && this.copyData == that.copyData && this.uploadId().equals(that.uploadId()) && this.keyspace().equals((Object)that.keyspace()) && this.table().equals((Object)that.table());
    }

    public int hashCode() {
        return Objects.hash(this.uploadId(), this.keyspace(), this.table(), this.resetLevel, this.clearRepaired, this.verifySSTables, this.verifyTokens, this.invalidateCaches, this.extendedVerify, this.copyData);
    }

    public String toString() {
        return "SSTableUploadRequest{uploadId='" + this.uploadId() + "', keyspace='" + this.keyspace() + "', tableName='" + this.table() + "', resetLevel=" + this.resetLevel + ", clearRepaired=" + this.clearRepaired + ", verifySSTables=" + this.verifySSTables + ", verifyTokens=" + this.verifyTokens + ", invalidateCaches=" + this.invalidateCaches + ", extendedVerify=" + this.extendedVerify + ", copyData=" + this.copyData + "}";
    }

    public static SSTableImportRequestParam from(QualifiedTableName qualifiedTableName, RoutingContext context) {
        HttpServerRequest request = context.request();
        return new SSTableImportRequestParam(qualifiedTableName, context.pathParam("uploadId"), RequestUtils.parseBooleanQueryParam(request, "resetLevel", true), RequestUtils.parseBooleanQueryParam(request, "clearRepaired", true), RequestUtils.parseBooleanQueryParam(request, "verifySSTables", true), RequestUtils.parseBooleanQueryParam(request, "verifyTokens", true), RequestUtils.parseBooleanQueryParam(request, "invalidateCaches", true), RequestUtils.parseBooleanQueryParam(request, "extendedVerify", true), RequestUtils.parseBooleanQueryParam(request, "copyData", false));
    }
}

