/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db.schema;

import com.datastax.driver.core.Session;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.coordination.ClusterLease;
import org.apache.cassandra.sidecar.coordination.ExecuteOnClusterLeaseholderOnly;
import org.apache.cassandra.sidecar.db.schema.AbstractSchema;
import org.apache.cassandra.sidecar.db.schema.SidecarInternalKeyspace;
import org.apache.cassandra.sidecar.exceptions.CassandraUnavailableException;
import org.apache.cassandra.sidecar.exceptions.SidecarSchemaModificationException;
import org.apache.cassandra.sidecar.metrics.DeltaGauge;
import org.apache.cassandra.sidecar.metrics.server.SchemaMetrics;
import org.apache.cassandra.sidecar.server.SidecarServerEvents;
import org.apache.cassandra.sidecar.tasks.PeriodicTask;
import org.apache.cassandra.sidecar.tasks.PeriodicTaskExecutor;
import org.apache.cassandra.sidecar.tasks.ScheduleDecision;
import org.apache.cassandra.sidecar.utils.EventBusUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidecarSchemaInitializer
implements PeriodicTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidecarSchemaInitializer.class);
    private static final DurationSpec INITIALIZATION_LOOP_DELAY = MillisecondBoundConfiguration.parse((String)"1s");
    private final CQLSessionProvider cqlSessionProvider;
    private final SidecarInternalKeyspace sidecarInternalKeyspace;
    private final SchemaMetrics schemaMetrics;
    private final ClusterLease clusterLease;
    private final boolean isSidecarSchemaEnabled;
    private Vertx vertx;
    private PeriodicTaskExecutor periodicTaskExecutor;

    public SidecarSchemaInitializer(SidecarConfiguration sidecarConfiguration, CQLSessionProvider cqlSessionProvider, SidecarInternalKeyspace sidecarInternalKeyspace, SchemaMetrics schemaMetrics, ClusterLease clusterLease) {
        this.isSidecarSchemaEnabled = sidecarConfiguration.serviceConfiguration().schemaKeyspaceConfiguration().isEnabled();
        this.cqlSessionProvider = cqlSessionProvider;
        this.sidecarInternalKeyspace = sidecarInternalKeyspace;
        this.schemaMetrics = schemaMetrics;
        this.clusterLease = clusterLease;
    }

    @Override
    public void deploy(Vertx vertx, PeriodicTaskExecutor executor) {
        if (!this.isSidecarSchemaEnabled) {
            LOGGER.info("SidecarSchema is disabled. Skip deployment of SidecarSchemaInitializer");
            return;
        }
        this.vertx = vertx;
        this.periodicTaskExecutor = executor;
        EventBusUtils.onceLocalConsumer(vertx.eventBus(), SidecarServerEvents.ON_CASSANDRA_CQL_READY.address(), ignored -> executor.schedule(this));
    }

    @Override
    public ScheduleDecision scheduleDecision() {
        if (this.cqlSessionProvider.getIfConnected() == null) {
            LOGGER.debug("CQL connection is not yet established. Skip this run of initialization.");
            return ScheduleDecision.SKIP;
        }
        return ScheduleDecision.EXECUTE;
    }

    @Override
    public DurationSpec delay() {
        return INITIALIZATION_LOOP_DELAY;
    }

    @Override
    public void execute(Promise<Void> promise) {
        try {
            Session session = this.cqlSessionProvider.get();
            boolean isInitialized = this.sidecarInternalKeyspace.initialize(session, this::shouldCreateSchema);
            if (isInitialized) {
                LOGGER.info("Sidecar schema is initialized. Stopping SchemaSidecarInitializer");
                this.periodicTaskExecutor.unschedule(this);
                this.reportSidecarSchemaInitialized();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to initialize schema. Retry in {}", (Object)this.delay(), (Object)ex);
            if (ex instanceof CassandraUnavailableException) {
                return;
            }
            if (ex instanceof SidecarSchemaModificationException) {
                LOGGER.warn("Failed to modify schema", (Throwable)ex);
                ((DeltaGauge)this.schemaMetrics.failedModifications.metric).update(1L);
            }
            ((DeltaGauge)this.schemaMetrics.failedInitializations.metric).update(1L);
        }
        promise.tryComplete();
    }

    protected void reportSidecarSchemaInitialized() {
        this.vertx.eventBus().publish(SidecarServerEvents.ON_SIDECAR_SCHEMA_INITIALIZED.address(), (Object)"SidecarSchema initialized");
    }

    protected boolean shouldCreateSchema(AbstractSchema schema) {
        if (schema instanceof ExecuteOnClusterLeaseholderOnly) {
            return this.clusterLease.isClaimedByLocalSidecar();
        }
        return true;
    }
}

