/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParameters;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.general.CipherKeyGenerator;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedMACOperatorFactory;
import org.bouncycastle.crypto.general.GuardedSymmetricKeyGenerator;
import org.bouncycastle.crypto.general.PrivilegedUtils;
import org.bouncycastle.crypto.general.SipHashEngine;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.macs.TruncatingMac;

public final class SipHash {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("SipHash");
    public static final GeneralAlgorithm SIPHASH_2_4 = new GeneralAlgorithm("SipHash-2-4");
    public static final GeneralAlgorithm SIPHASH_4_8 = new GeneralAlgorithm("SipHash-4-8");

    private SipHash() {
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey symmetricKey, Parameters parameters) {
        ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
        int n = validatedSymmetricKey.getKeySizeInBits();
        if (SipHash.invalidKeySize(n)) {
            throw new IllegalKeyException("SipHash key must be of length 128 bits");
        }
        Algorithm algorithm = symmetricKey.getAlgorithm();
        if (algorithm != ALGORITHM && algorithm != parameters.getAlgorithm()) {
            throw new IllegalKeyException("Key not for appropriate algorithm");
        }
        return validatedSymmetricKey;
    }

    private static boolean invalidKeySize(int n) {
        return n != 128;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AuthParameters
    extends GeneralParameters<GeneralAlgorithm>
    implements AuthenticationParameters<AuthParameters> {
        private final int macSizeInBits;

        private AuthParameters(GeneralAlgorithm generalAlgorithm, int n) {
            super(generalAlgorithm);
            this.macSizeInBits = n;
        }

        public AuthParameters() {
            this(SIPHASH_2_4);
        }

        public AuthParameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, 64);
        }

        @Override
        public int getMACSizeInBits() {
            return this.macSizeInBits;
        }

        @Override
        public AuthParameters withMACSize(int n) {
            return new AuthParameters((GeneralAlgorithm)this.getAlgorithm(), n);
        }
    }

    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private final GeneralAlgorithm algorithm;
        private final SecureRandom random;

        public KeyGenerator(SecureRandom secureRandom) {
            this(ALGORITHM, secureRandom);
        }

        public KeyGenerator(GeneralAlgorithm generalAlgorithm, SecureRandom secureRandom) {
            this.algorithm = generalAlgorithm;
            this.random = secureRandom;
        }

        public SymmetricKey doGenerateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, 128));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MACOperatorFactory
    extends GuardedMACOperatorFactory<AuthParameters> {
        @Override
        protected Mac createMAC(SymmetricKey symmetricKey, AuthParameters authParameters) {
            Mac mac = this.getMac(authParameters);
            if (mac.getMacSize() != (authParameters.getMACSizeInBits() + 7) / 8) {
                mac = new TruncatingMac(mac, authParameters.macSizeInBits);
            }
            mac.init(Utils.getKeyParameter(SipHash.validateKey(symmetricKey, authParameters)));
            return mac;
        }

        private Mac getMac(AuthParameters authParameters) {
            SipHashEngine sipHashEngine;
            if (authParameters.getAlgorithm() == SIPHASH_2_4) {
                sipHashEngine = new SipHashEngine(2, 4);
            } else if (authParameters.getAlgorithm() == SIPHASH_4_8) {
                sipHashEngine = new SipHashEngine(4, 8);
            } else {
                throw new IllegalArgumentException("Unknown algorithm passed to createMAC: " + authParameters.getAlgorithm());
            }
            return sipHashEngine;
        }

        @Override
        protected int calculateMACSize(AuthParameters authParameters) {
            return this.getMac(authParameters).getMacSize();
        }
    }
}

