/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import org.apache.jute.Record;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.CheckVersionRequest;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.proto.RequestHeader;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class CheckTest
extends ClientBase {
    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        System.setProperty("zookeeper.request.timeout", "2000");
        if (testInfo.getDisplayName().contains("Cluster")) {
            return;
        }
        super.setUp();
    }

    @AfterEach
    public void tearDown(TestInfo testInfo) throws Exception {
        System.clearProperty("zookeeper.request.timeout");
        if (testInfo.getDisplayName().contains("Cluster")) {
            return;
        }
        super.tearDown();
    }

    @Override
    public void setUp() throws Exception {
    }

    @Override
    public void tearDown() throws Exception {
    }

    private static void checkVersion(TestableZooKeeper zk, String path, int version) throws Exception {
        RequestHeader header = new RequestHeader();
        header.setType(13);
        CheckVersionRequest request = new CheckVersionRequest(path, version);
        ReplyHeader replyHeader = zk.submitRequest(header, (Record)request, null, null);
        if (replyHeader.getErr() != 0) {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)replyHeader.getErr()), (String)path);
        }
    }

    private void testOperations(TestableZooKeeper zk) throws Exception {
        Stat stat = new Stat();
        zk.getData("/", false, stat);
        Assertions.assertThrows(KeeperException.UnimplementedException.class, () -> CheckTest.checkVersion(zk, "/", -1));
    }

    @Test
    public void testStandalone() throws Exception {
        this.testOperations(this.createClient());
    }

    @Test
    public void testStandaloneDatabaseReloadAfterCheck() throws Exception {
        try {
            this.testOperations(this.createClient());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.stopServer();
        this.startServer();
    }

    @Test
    public void testCluster() throws Exception {
        QuorumBase qb = new QuorumBase();
        try {
            qb.setUp(true, true);
            this.testOperations(qb.createClient(new ClientBase.CountdownWatcher(), QuorumPeer.ServerState.OBSERVING));
            this.testOperations(qb.createClient(new ClientBase.CountdownWatcher(), QuorumPeer.ServerState.FOLLOWING));
            this.testOperations(qb.createClient(new ClientBase.CountdownWatcher(), QuorumPeer.ServerState.LEADING));
        }
        finally {
            try {
                qb.tearDown();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusterDatabaseReloadAfterCheck() throws Exception {
        QuorumBase qb = new QuorumBase();
        try {
            qb.setUp(true, true);
            File dataDir = qb.getLeaderDataDir();
            QuorumPeer leader = qb.getLeaderQuorumPeer();
            try {
                this.testOperations(qb.createClient(new ClientBase.CountdownWatcher(), QuorumPeer.ServerState.LEADING));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            QuorumBase.shutdown(leader);
            FileTxnSnapLog txnSnapLog = new FileTxnSnapLog(dataDir, dataDir);
            ZKDatabase database = new ZKDatabase(txnSnapLog);
            database.loadDataBase();
        }
        finally {
            try {
                qb.tearDown();
            }
            catch (Exception exception) {}
        }
    }
}

