/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.LearnerSyncThrottler;
import org.apache.zookeeper.server.quorum.SyncThrottleException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LearnerSyncThrottlerTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(LearnerSyncThrottlerTest.class);

    @ParameterizedTest
    @EnumSource(value=LearnerSyncThrottler.SyncType.class)
    public void testTooManySyncsNonessential(LearnerSyncThrottler.SyncType syncType) {
        Assertions.assertThrows(SyncThrottleException.class, () -> {
            LearnerSyncThrottler throttler = new LearnerSyncThrottler(5, syncType);
            for (int i = 0; i < 6; ++i) {
                throttler.beginSync(false);
            }
        });
    }

    @ParameterizedTest
    @EnumSource(value=LearnerSyncThrottler.SyncType.class)
    public void testTooManySyncsEssential(LearnerSyncThrottler.SyncType syncType) {
        Assertions.assertThrows(SyncThrottleException.class, () -> {
            LearnerSyncThrottler throttler = new LearnerSyncThrottler(5, syncType);
            try {
                for (int i = 0; i < 6; ++i) {
                    throttler.beginSync(true);
                }
            }
            catch (SyncThrottleException ex) {
                Assertions.fail((String)"essential syncs should not be throttled");
            }
            throttler.endSync();
            throttler.beginSync(false);
        });
    }

    @ParameterizedTest
    @EnumSource(value=LearnerSyncThrottler.SyncType.class)
    public void testNoThrottle(LearnerSyncThrottler.SyncType syncType) throws Exception {
        int i;
        LearnerSyncThrottler throttler = new LearnerSyncThrottler(5, syncType);
        try {
            for (i = 0; i < 6; ++i) {
                throttler.beginSync(true);
            }
        }
        catch (SyncThrottleException ex) {
            Assertions.fail((String)"essential syncs should not be throttled");
        }
        throttler.endSync();
        for (i = 0; i < 5; ++i) {
            throttler.endSync();
            throttler.beginSync(false);
        }
        Assertions.assertTrue((boolean)true, (String)"should get here without exception");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=LearnerSyncThrottler.SyncType.class)
    public void testTryWithResourceNoThrottle(LearnerSyncThrottler.SyncType syncType) throws Exception {
        LearnerSyncThrottler throttler = new LearnerSyncThrottler(1, syncType);
        for (int i = 0; i < 3; ++i) {
            throttler.beginSync(false);
            try {
                Assertions.assertEquals((int)1, (int)throttler.getSyncInProgress());
                continue;
            }
            finally {
                throttler.endSync();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=LearnerSyncThrottler.SyncType.class)
    public void testTryWithResourceThrottle(LearnerSyncThrottler.SyncType syncType) throws Exception {
        LearnerSyncThrottler throttler = new LearnerSyncThrottler(1, syncType);
        try {
            throttler.beginSync(true);
            try {
                throttler.beginSync(false);
                Assertions.fail((String)"shouldn't be able to have both syncs open");
            }
            catch (SyncThrottleException syncThrottleException) {
                // empty catch block
            }
            throttler.endSync();
        }
        catch (SyncThrottleException e) {
            Assertions.fail((String)"First sync shouldn't be throttled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=LearnerSyncThrottler.SyncType.class)
    public void testParallelNoThrottle(LearnerSyncThrottler.SyncType syncType) {
        int numThreads = 50;
        final LearnerSyncThrottler throttler = new LearnerSyncThrottler(50, syncType);
        ExecutorService threadPool = Executors.newFixedThreadPool(50);
        final CountDownLatch threadStartLatch = new CountDownLatch(50);
        final CountDownLatch syncProgressLatch = new CountDownLatch(50);
        ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>(50);
        for (int i = 0; i < 50; ++i) {
            results.add(threadPool.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    threadStartLatch.countDown();
                    try {
                        threadStartLatch.await();
                        throttler.beginSync(false);
                        syncProgressLatch.countDown();
                        syncProgressLatch.await();
                        throttler.endSync();
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return true;
                }
            }));
        }
        try {
            for (Future future : results) {
                Assertions.assertTrue((boolean)((Boolean)future.get()));
            }
        }
        catch (Exception exception) {
        }
        finally {
            threadPool.shutdown();
        }
    }
}

