/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.DatadirCleanupManager;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DatadirCleanupManagerTest
extends ZKTestCase {
    private DatadirCleanupManager purgeMgr;
    private File snapDir;
    private File dataLogDir;

    @BeforeEach
    public void setUp() throws Exception {
        File dataDir;
        this.snapDir = dataDir = ClientBase.createTmpDir();
        this.dataLogDir = dataDir;
    }

    @Test
    public void testPurgeTask() throws Exception {
        this.purgeMgr = new DatadirCleanupManager(this.snapDir, this.dataLogDir, 3, 1);
        this.purgeMgr.start();
        Assertions.assertEquals((Object)this.dataLogDir, (Object)this.purgeMgr.getDataLogDir(), (String)"Data log directory is not set as configured");
        Assertions.assertEquals((Object)this.snapDir, (Object)this.purgeMgr.getSnapDir(), (String)"Snapshot directory is not set as configured");
        Assertions.assertEquals((int)3, (int)this.purgeMgr.getSnapRetainCount(), (String)"Snapshot retain count is not set as configured");
        Assertions.assertEquals((Object)DatadirCleanupManager.PurgeTaskStatus.STARTED, (Object)this.purgeMgr.getPurgeTaskStatus(), (String)"Purge task is not started");
        this.purgeMgr.shutdown();
        Assertions.assertEquals((Object)DatadirCleanupManager.PurgeTaskStatus.COMPLETED, (Object)this.purgeMgr.getPurgeTaskStatus(), (String)"Purge task is still running after shutdown");
    }

    @Test
    public void testWithZeroPurgeInterval() throws Exception {
        this.purgeMgr = new DatadirCleanupManager(this.snapDir, this.dataLogDir, 3, 0);
        this.purgeMgr.start();
        Assertions.assertEquals((Object)DatadirCleanupManager.PurgeTaskStatus.NOT_STARTED, (Object)this.purgeMgr.getPurgeTaskStatus(), (String)"Purge task is scheduled with zero purge interval");
        this.purgeMgr.shutdown();
        Assertions.assertEquals((Object)DatadirCleanupManager.PurgeTaskStatus.NOT_STARTED, (Object)this.purgeMgr.getPurgeTaskStatus(), (String)"Purge task is scheduled with zero purge interval");
    }

    @Test
    public void testWithNegativePurgeInterval() throws Exception {
        this.purgeMgr = new DatadirCleanupManager(this.snapDir, this.dataLogDir, 3, -1);
        this.purgeMgr.start();
        Assertions.assertEquals((Object)DatadirCleanupManager.PurgeTaskStatus.NOT_STARTED, (Object)this.purgeMgr.getPurgeTaskStatus(), (String)"Purge task is scheduled with negative purge interval");
        this.purgeMgr.shutdown();
        Assertions.assertEquals((Object)DatadirCleanupManager.PurgeTaskStatus.NOT_STARTED, (Object)this.purgeMgr.getPurgeTaskStatus(), (String)"Purge task is scheduled with negative purge interval");
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.purgeMgr != null) {
            this.purgeMgr.shutdown();
        }
    }
}

