/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Quotas;
import org.apache.zookeeper.StatsTrack;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.cli.SetQuotaCommand;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QuorumQuotaTest
extends QuorumBase {
    @Test
    public void testQuotaWithQuorum() throws Exception {
        TestableZooKeeper zk = this.createClient();
        zk.setData("/", "some".getBytes(), -1);
        zk.create("/a", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        int i = 0;
        for (i = 0; i < 300; ++i) {
            zk.create("/a/" + i, "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        StatsTrack quota = new StatsTrack();
        quota.setCount(1000L);
        quota.setBytes(5000L);
        SetQuotaCommand.createQuota((ZooKeeper)zk, (String)"/a", (StatsTrack)quota);
        String statPath = Quotas.statPath((String)"/a");
        byte[] data = zk.getData(statPath, false, new Stat());
        StatsTrack st = new StatsTrack(data);
        Assertions.assertTrue((st.getBytes() == 1204L ? 1 : 0) != 0, (String)"bytes are set");
        Assertions.assertTrue((st.getCount() == 301L ? 1 : 0) != 0, (String)"num count is set");
        for (i = 300; i < 600; ++i) {
            zk.create("/a/" + i, "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        data = zk.getData(statPath, false, new Stat());
        st = new StatsTrack(data);
        Assertions.assertTrue((st.getBytes() == 2404L ? 1 : 0) != 0, (String)"bytes are set");
        Assertions.assertTrue((st.getCount() == 601L ? 1 : 0) != 0, (String)"num count is set");
    }
}

