/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.admin.ZooKeeperAdmin;
import org.apache.zookeeper.common.StringUtils;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.server.quorum.ReconfigLegacyTest;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.ReconfigTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ReconfigBackupTest
extends QuorumPeerTestBase {
    public static String getVersionFromConfigStr(String config) throws IOException {
        Properties props = new Properties();
        props.load(new StringReader(config));
        return props.getProperty("version", "");
    }

    @BeforeEach
    public void setup() {
        ClientBase.setupTestEnv();
        System.setProperty("zookeeper.DigestAuthenticationProvider.superDigest", "super:D/InIHSb7yEEbrWz8b9l71RjZJU=");
    }

    @Test
    public void testBackupStatic() throws Exception {
        int i;
        int SERVER_COUNT = 3;
        int[] clientPorts = new int[3];
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < 3; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            String server = "server." + i2 + "=localhost:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;localhost:" + clientPorts[i2];
            sb.append(server + "\n");
        }
        String currentQuorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[3];
        String[] staticFileContent = new String[3];
        String[] staticBackupContent = new String[3];
        for (i = 0; i < 3; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfgSection, false);
            Assertions.assertNull((Object)mt[i].getFileByName("zoo.cfg.bak"), (String)"static file backup shouldn't exist before bootup");
            staticFileContent[i] = new String(Files.readAllBytes(mt[i].confFile.toPath()), StandardCharsets.UTF_8);
            mt[i].start();
        }
        for (i = 0; i < 3; ++i) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT), (String)("waiting for server " + i + " being up"));
            File backupFile = mt[i].getFileByName("zoo.cfg.bak");
            Assertions.assertNotNull((Object)backupFile, (String)"static file backup should exist");
            staticBackupContent[i] = new String(Files.readAllBytes(backupFile.toPath()), StandardCharsets.UTF_8);
            Assertions.assertEquals((Object)staticFileContent[i], (Object)staticBackupContent[i]);
        }
        for (i = 0; i < 3; ++i) {
            mt[i].shutdown();
        }
    }

    @Test
    public void testReconfigCreateNewVersionFile() throws Exception {
        String configStr;
        String version;
        String filename;
        Properties cfg;
        int i;
        int SERVER_COUNT = 3;
        int NEW_SERVER_COUNT = 5;
        int[] clientPorts = new int[5];
        int[] quorumPorts = new int[5];
        int[] electionPorts = new int[5];
        String[] servers = new String[5];
        StringBuilder sb = new StringBuilder();
        ArrayList<String> oldServers = new ArrayList<String>();
        ArrayList<String> newServers = new ArrayList<String>();
        for (int i2 = 0; i2 < 5; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            quorumPorts[i2] = PortAssignment.unique();
            electionPorts[i2] = PortAssignment.unique();
            servers[i2] = "server." + i2 + "=localhost:" + quorumPorts[i2] + ":" + electionPorts[i2] + ":participant;localhost:" + clientPorts[i2];
            newServers.add(servers[i2]);
            if (i2 >= 3) continue;
            oldServers.add(servers[i2]);
            sb.append(servers[i2] + "\n");
        }
        String quorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[5];
        ZooKeeper[] zk = new ZooKeeper[5];
        ZooKeeperAdmin[] zkAdmin = new ZooKeeperAdmin[5];
        for (int i3 = 0; i3 < 3; ++i3) {
            mt[i3] = new QuorumPeerTestBase.MainThread(i3, clientPorts[i3], quorumCfgSection, "reconfigEnabled=true\n");
            mt[i3].start();
        }
        String firstVersion = null;
        String secondVersion = null;
        for (i = 0; i < 3; ++i) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT), (String)("waiting for server " + i + " being up"));
            zk[i] = ClientBase.createZKClient("127.0.0.1:" + clientPorts[i]);
            zkAdmin[i] = new ZooKeeperAdmin("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
            zkAdmin[i].addAuthInfo("digest", "super:test".getBytes());
            cfg = ReconfigLegacyTest.readPropertiesFromFile(mt[i].confFile);
            filename = cfg.getProperty("dynamicConfigFile", "");
            version = QuorumPeerConfig.getVersionFromFilename((String)filename);
            Assertions.assertNotNull((Object)version);
            configStr = ReconfigTest.testServerHasConfig(zk[i], oldServers, null);
            String configVersion = ReconfigBackupTest.getVersionFromConfigStr(configStr);
            Assertions.assertEquals((Object)version, (Object)configVersion);
            if (i == 0) {
                firstVersion = version;
                continue;
            }
            Assertions.assertEquals((Object)firstVersion, (Object)version);
        }
        ReconfigTest.reconfig(zkAdmin[1], null, null, newServers, -1L);
        for (i = 3; i < 5; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], quorumCfgSection + servers[i]);
            mt[i].start();
        }
        for (i = 3; i < 5; ++i) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT), (String)("waiting for server " + i + " being up"));
            zk[i] = ClientBase.createZKClient("127.0.0.1:" + clientPorts[i]);
        }
        for (i = 0; i < 5; ++i) {
            cfg = ReconfigLegacyTest.readPropertiesFromFile(mt[i].confFile);
            filename = cfg.getProperty("dynamicConfigFile", "");
            version = QuorumPeerConfig.getVersionFromFilename((String)filename);
            Assertions.assertNotNull((Object)version);
            configStr = ReconfigTest.testServerHasConfig(zk[i], newServers, null);
            String quorumVersion = ReconfigBackupTest.getVersionFromConfigStr(configStr);
            Assertions.assertEquals((Object)version, (Object)quorumVersion);
            if (i == 0) {
                secondVersion = version;
                Assertions.assertTrue((Long.parseLong(secondVersion, 16) > Long.parseLong(firstVersion, 16) ? 1 : 0) != 0);
                continue;
            }
            Assertions.assertEquals((Object)secondVersion, (Object)version);
        }
        for (i = 0; i < 3; ++i) {
            mt[i].shutdown();
            zk[i].close();
            zkAdmin[i].close();
        }
    }

    @Test
    public void testVersionOfDynamicFilename() throws Exception {
        int i;
        int SERVER_COUNT = 5;
        int oldServerCount = 3;
        boolean lagOffServerId = false;
        int[] clientPorts = new int[5];
        StringBuilder sb = new StringBuilder();
        StringBuilder oldSb = new StringBuilder();
        ArrayList<String> allServers = new ArrayList<String>();
        for (int i2 = 0; i2 < 5; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            String server = "server." + i2 + "=localhost:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;localhost:" + clientPorts[i2];
            sb.append(server + "\n");
            allServers.add(server);
            if (i2 >= 3) continue;
            oldSb.append(server + "\n");
        }
        String currentQuorumCfgSection = sb.toString();
        String oldQuorumCfg = oldSb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[5];
        for (int i3 = 0; i3 < 5; ++i3) {
            mt[i3] = i3 == 0 ? new QuorumPeerTestBase.MainThread(i3, clientPorts[i3], oldQuorumCfg, true, "100000000") : new QuorumPeerTestBase.MainThread(i3, clientPorts[i3], currentQuorumCfgSection, true, "200000000");
            if (i3 == 0) {
                Assertions.assertNotNull((Object)mt[i3].getFileByName("zoo.cfg.dynamic.100000000"));
                Assertions.assertNull((Object)mt[i3].getFileByName("zoo.cfg.dynamic.200000000"));
                Assertions.assertTrue((boolean)mt[i3].getPropFromStaticFile("dynamicConfigFile").endsWith(".100000000"));
            } else {
                Assertions.assertNotNull((Object)mt[i3].getFileByName("zoo.cfg.dynamic.200000000"));
                Assertions.assertTrue((boolean)mt[i3].getPropFromStaticFile("dynamicConfigFile").endsWith(".200000000"));
            }
            mt[i3].start();
        }
        String dynamicFileContent = null;
        for (i = 0; i < 5; ++i) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT), (String)("waiting for server " + i + " being up"));
            ZooKeeper zk = ClientBase.createZKClient("127.0.0.1:" + clientPorts[i]);
            String configStr = ReconfigTest.testServerHasConfig(zk, allServers, null);
            Assertions.assertEquals((Object)"200000000", (Object)ReconfigBackupTest.getVersionFromConfigStr(configStr));
            List<String> configLines = Arrays.asList(configStr.split("\n"));
            Collections.sort(configLines);
            String sortedConfigStr = StringUtils.joinStrings(configLines, (String)"\n");
            File dynamicConfigFile = mt[i].getFileByName("zoo.cfg.dynamic.200000000");
            Assertions.assertNotNull((Object)dynamicConfigFile);
            if (i == 0) {
                dynamicFileContent = new String(Files.readAllBytes(dynamicConfigFile.toPath()), StandardCharsets.UTF_8);
                Assertions.assertEquals((Object)sortedConfigStr, (Object)(dynamicFileContent + "\nversion=200000000"));
            } else {
                String otherDynamicFileContent = new String(Files.readAllBytes(dynamicConfigFile.toPath()), StandardCharsets.UTF_8);
                Assertions.assertEquals((Object)(dynamicFileContent + "\n"), (Object)otherDynamicFileContent);
            }
            zk.close();
        }
        Assertions.assertTrue((boolean)mt[0].getPropFromStaticFile("dynamicConfigFile").endsWith(".200000000"));
        for (i = 0; i < 5; ++i) {
            mt[i].shutdown();
        }
    }
}

