/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.GetDataRequest;
import org.apache.zookeeper.proto.SetDataRequest;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.RequestRecord;
import org.apache.zookeeper.server.WorkerService;
import org.apache.zookeeper.server.ZooKeeperServerListener;
import org.apache.zookeeper.server.quorum.CommitProcessor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitProcessorConcurrencyTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(CommitProcessorConcurrencyTest.class);
    BlockingQueue<Request> processedRequests;
    MockCommitProcessor processor;
    int defaultSizeOfThreadPool = 16;

    @BeforeEach
    public void setUp() throws Exception {
        this.processedRequests = new LinkedBlockingQueue<Request>();
        this.processor = new MockCommitProcessor();
        CommitProcessor.setMaxReadBatchSize((int)-1);
        CommitProcessor.setMaxCommitBatchSize((int)1);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.processor.shutdown();
    }

    private Request newRequest(Record rec, int type, int sessionId, int xid) throws IOException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)boas);
        rec.serialize((OutputArchive)boa, "request");
        ByteBuffer bb = ByteBuffer.wrap(boas.toByteArray());
        return new Request(null, (long)sessionId, xid, type, RequestRecord.fromBytes((ByteBuffer)bb), new ArrayList());
    }

    @Test
    public void committedAndUncommittedOfTheSameSessionRaceTest() throws Exception {
        String path = "/testCvsUCRace";
        Request readReq = this.newRequest((Record)new GetDataRequest("/testCvsUCRace", false), 4, 0, 0);
        Request writeReq = this.newRequest((Record)new SetDataRequest("/testCvsUCRace", new byte[16], -1), 5, 0, 1);
        this.processor.committedRequests.add(writeReq);
        this.processor.queuedRequests.add(readReq);
        this.processor.queuedRequests.add(writeReq);
        this.processor.queuedWriteRequests.add(writeReq);
        this.processor.initThreads(1);
        this.processor.stoppedMainLoop = true;
        this.processor.run();
        Assertions.assertTrue((this.processedRequests.peek() != null && ((Request)this.processedRequests.peek()).equals(readReq) ? 1 : 0) != 0, (String)("Request was not processed " + readReq + " instead " + this.processedRequests.peek()));
        this.processedRequests.poll();
        Assertions.assertTrue((this.processedRequests.peek() != null && ((Request)this.processedRequests.peek()).equals(writeReq) ? 1 : 0) != 0, (String)("Request was not processed " + writeReq + " instead " + this.processedRequests.peek()));
    }

    @Test
    public void processAsMuchUncommittedRequestsAsPossibleTest() throws Exception {
        String path = "/testAsMuchAsPossible";
        LinkedList<Request> shouldBeProcessed = new LinkedList<Request>();
        HashSet<Request> shouldNotBeProcessed = new HashSet<Request>();
        for (int sessionId = 1; sessionId <= 5; ++sessionId) {
            Request readReq;
            for (int readReqId = 1; readReqId <= sessionId; ++readReqId) {
                readReq = this.newRequest((Record)new GetDataRequest("/testAsMuchAsPossible", false), 4, sessionId, readReqId);
                shouldBeProcessed.add(readReq);
                this.processor.queuedRequests.add(readReq);
            }
            Request writeReq = this.newRequest((Record)new CreateRequest("/testAsMuchAsPossible", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL.toFlag()), 1, sessionId, sessionId + 1);
            readReq = this.newRequest((Record)new GetDataRequest("/testAsMuchAsPossible", false), 4, sessionId, sessionId + 2);
            this.processor.queuedRequests.add(writeReq);
            this.processor.queuedWriteRequests.add(writeReq);
            this.processor.queuedRequests.add(readReq);
            shouldNotBeProcessed.add(writeReq);
            shouldNotBeProcessed.add(readReq);
        }
        this.processor.initThreads(this.defaultSizeOfThreadPool);
        this.processor.stoppedMainLoop = true;
        this.processor.run();
        Thread.sleep(1000L);
        shouldBeProcessed.removeAll(this.processedRequests);
        for (Request r : shouldBeProcessed) {
            LOG.error("Did not process {}", (Object)r);
        }
        Assertions.assertTrue((boolean)shouldBeProcessed.isEmpty(), (String)"Not all requests were processed");
        Assertions.assertFalse((boolean)shouldNotBeProcessed.removeAll(this.processedRequests), (String)"Processed a wrong request");
    }

    @Test
    public void processAllFollowingUncommittedAfterFirstCommitTest() throws Exception {
        String path = "/testUncommittedFollowingCommited";
        HashSet<Request> shouldBeInPending = new HashSet<Request>();
        HashSet<Request> shouldBeProcessedAfterPending = new HashSet<Request>();
        Request writeReq = this.newRequest((Record)new CreateRequest("/testUncommittedFollowingCommited", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL.toFlag()), 1, 1, 1);
        this.processor.queuedRequests.add(writeReq);
        this.processor.queuedWriteRequests.add(writeReq);
        shouldBeInPending.add(writeReq);
        for (int readReqId = 2; readReqId <= 5; ++readReqId) {
            Request readReq = this.newRequest((Record)new GetDataRequest("/testUncommittedFollowingCommited", false), 4, 1, readReqId);
            this.processor.queuedRequests.add(readReq);
            shouldBeInPending.add(readReq);
            shouldBeProcessedAfterPending.add(readReq);
        }
        this.processor.initThreads(this.defaultSizeOfThreadPool);
        this.processor.stoppedMainLoop = true;
        this.processor.run();
        Assertions.assertTrue((boolean)this.processedRequests.isEmpty(), (String)"Processed without waiting for commit");
        Assertions.assertTrue((boolean)this.processor.queuedRequests.isEmpty(), (String)"Did not handled all of queuedRequests' requests");
        Assertions.assertTrue((!this.processor.queuedWriteRequests.isEmpty() ? 1 : 0) != 0, (String)"Removed from blockedQueuedRequests before commit");
        shouldBeInPending.removeAll((Collection)this.processor.pendingRequests.get(writeReq.sessionId));
        for (Request r : shouldBeInPending) {
            LOG.error("Should be in pending {}", (Object)r);
        }
        Assertions.assertTrue((boolean)shouldBeInPending.isEmpty(), (String)"Not all requests moved to pending from queuedRequests");
        this.processor.committedRequests.add(writeReq);
        this.processor.stoppedMainLoop = true;
        this.processor.run();
        this.processor.initThreads(this.defaultSizeOfThreadPool);
        Thread.sleep(500L);
        Assertions.assertTrue((this.processedRequests.peek() == writeReq ? 1 : 0) != 0, (String)"Did not process committed request");
        Assertions.assertTrue((boolean)this.processedRequests.containsAll(shouldBeProcessedAfterPending), (String)"Did not process following read request");
        Assertions.assertTrue((boolean)this.processor.committedRequests.isEmpty(), (String)"Did not process committed request");
        Assertions.assertTrue((boolean)this.processor.pendingRequests.isEmpty(), (String)"Did not process committed request");
        Assertions.assertTrue((boolean)this.processor.queuedWriteRequests.isEmpty(), (String)"Did not remove from blockedQueuedRequests");
    }

    @Test
    public void processAllWritesMaxBatchSize() throws Exception {
        String path = "/processAllWritesMaxBatchSize";
        HashSet<Request> shouldBeProcessedAfterPending = new HashSet<Request>();
        Request writeReq = this.newRequest((Record)new CreateRequest("/processAllWritesMaxBatchSize_1", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL.toFlag()), 1, 1, 1);
        this.processor.queuedRequests.add(writeReq);
        this.processor.queuedWriteRequests.add(writeReq);
        Request writeReq2 = this.newRequest((Record)new CreateRequest("/processAllWritesMaxBatchSize_2", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL.toFlag()), 1, 2, 1);
        this.processor.queuedRequests.add(writeReq2);
        this.processor.queuedWriteRequests.add(writeReq2);
        for (int readReqId = 2; readReqId <= 5; ++readReqId) {
            Request readReq = this.newRequest((Record)new GetDataRequest("/processAllWritesMaxBatchSize", false), 4, 1, readReqId);
            Request readReq2 = this.newRequest((Record)new GetDataRequest("/processAllWritesMaxBatchSize", false), 4, 2, readReqId);
            this.processor.queuedRequests.add(readReq);
            shouldBeProcessedAfterPending.add(readReq);
            this.processor.queuedRequests.add(readReq2);
            shouldBeProcessedAfterPending.add(readReq2);
        }
        Request writeReq3 = this.newRequest((Record)new CreateRequest("/processAllWritesMaxBatchSize_3", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL.toFlag()), 1, 2, 6);
        this.processor.queuedRequests.add(writeReq3);
        this.processor.queuedWriteRequests.add(writeReq3);
        this.processor.initThreads(this.defaultSizeOfThreadPool);
        this.processor.stoppedMainLoop = true;
        CommitProcessor.setMaxCommitBatchSize((int)2);
        this.processor.run();
        Assertions.assertTrue((boolean)this.processedRequests.isEmpty(), (String)"Processed without waiting for commit");
        Assertions.assertTrue((boolean)this.processor.queuedRequests.isEmpty(), (String)"Did not handled all of queuedRequests' requests");
        Assertions.assertTrue((!this.processor.queuedWriteRequests.isEmpty() ? 1 : 0) != 0, (String)"Removed from blockedQueuedRequests before commit");
        Assertions.assertTrue((boolean)this.processor.pendingRequests.containsKey(writeReq.sessionId), (String)"Missing session 1 in pending queue");
        Assertions.assertTrue((boolean)this.processor.pendingRequests.containsKey(writeReq2.sessionId), (String)"Missing session 2 in pending queue");
        this.processor.committedRequests.add(writeReq);
        this.processor.committedRequests.add(writeReq2);
        this.processor.committedRequests.add(writeReq3);
        this.processor.stoppedMainLoop = true;
        CommitProcessor.setMaxCommitBatchSize((int)3);
        this.processor.run();
        this.processor.initThreads(this.defaultSizeOfThreadPool);
        Thread.sleep(500L);
        Assertions.assertTrue((this.processedRequests.peek() == writeReq ? 1 : 0) != 0, (String)"Did not process committed request");
        Assertions.assertTrue((boolean)this.processedRequests.containsAll(shouldBeProcessedAfterPending), (String)"Did not process following read request");
        Assertions.assertTrue((!this.processor.committedRequests.isEmpty() ? 1 : 0) != 0, (String)"Processed committed request");
        Assertions.assertTrue((this.processor.committedRequests.peek() == writeReq3 ? 1 : 0) != 0, (String)"Removed commit for write req 3");
        Assertions.assertTrue((!this.processor.pendingRequests.isEmpty() ? 1 : 0) != 0, (String)"Processed committed request");
        Assertions.assertTrue((boolean)this.processor.pendingRequests.containsKey(writeReq3.sessionId), (String)"Missing session 2 in pending queue");
        Assertions.assertTrue((((Deque)this.processor.pendingRequests.get(writeReq3.sessionId)).peek() == writeReq3 ? 1 : 0) != 0, (String)"Missing write 3 in pending queue");
        Assertions.assertTrue((!this.processor.queuedWriteRequests.isEmpty() ? 1 : 0) != 0, (String)"Removed from blockedQueuedRequests");
        Assertions.assertTrue((this.processor.queuedWriteRequests.peek() == writeReq3 ? 1 : 0) != 0, (String)"Removed write req 3 from blockedQueuedRequests");
        Request readReq3 = this.newRequest((Record)new GetDataRequest("/processAllWritesMaxBatchSize", false), 4, 1, 7);
        this.processor.queuedRequests.add(readReq3);
        shouldBeProcessedAfterPending.add(readReq3);
        Request writeReq4 = this.newRequest((Record)new CreateRequest("/processAllWritesMaxBatchSize_4", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL.toFlag()), 1, 2, 7);
        this.processor.queuedRequests.add(writeReq4);
        this.processor.queuedWriteRequests.add(writeReq4);
        this.processor.committedRequests.add(writeReq4);
        this.processor.stoppedMainLoop = true;
        CommitProcessor.setMaxCommitBatchSize((int)3);
        this.processor.run();
        this.processor.initThreads(this.defaultSizeOfThreadPool);
        Thread.sleep(500L);
        Assertions.assertTrue((this.processedRequests.peek() == writeReq ? 1 : 0) != 0, (String)"Did not process committed request");
        Assertions.assertTrue((boolean)this.processedRequests.containsAll(shouldBeProcessedAfterPending), (String)"Did not process following read request");
        Assertions.assertTrue((!this.processor.committedRequests.isEmpty() ? 1 : 0) != 0, (String)"Processed unexpected committed request");
        Assertions.assertTrue((boolean)this.processor.pendingRequests.isEmpty(), (String)"Unexpected pending request");
        Assertions.assertTrue((!this.processor.queuedWriteRequests.isEmpty() ? 1 : 0) != 0, (String)"Removed from blockedQueuedRequests");
        Assertions.assertTrue((this.processor.queuedWriteRequests.peek() == writeReq4 ? 1 : 0) != 0, (String)"Removed write req 4 from blockedQueuedRequests");
        this.processor.stoppedMainLoop = true;
        CommitProcessor.setMaxCommitBatchSize((int)3);
        this.processor.run();
        this.processor.initThreads(this.defaultSizeOfThreadPool);
        Thread.sleep(500L);
        Assertions.assertTrue((this.processedRequests.peek() == writeReq ? 1 : 0) != 0, (String)"Did not process committed request");
        Assertions.assertTrue((boolean)this.processedRequests.containsAll(shouldBeProcessedAfterPending), (String)"Did not process following read request");
        Assertions.assertTrue((boolean)this.processor.committedRequests.isEmpty(), (String)"Did not process committed request");
        Assertions.assertTrue((boolean)this.processor.pendingRequests.isEmpty(), (String)"Did not process committed request");
        Assertions.assertTrue((boolean)this.processor.queuedWriteRequests.isEmpty(), (String)"Did not remove from blockedQueuedRequests");
    }

    @Test
    @Timeout(value=1L)
    public void noStarvationOfNonLocalCommittedRequestsTest() throws Exception {
        int i;
        String path = "/noStarvationOfCommittedRequests";
        this.processor.queuedRequests = new MockRequestsQueue();
        HashSet<Request> nonLocalCommits = new HashSet<Request>();
        for (i = 0; i < 10; ++i) {
            Request nonLocalCommitReq = this.newRequest((Record)new CreateRequest("/noStarvationOfCommittedRequests", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL.toFlag()), 1, 51, i + 1);
            this.processor.committedRequests.add(nonLocalCommitReq);
            nonLocalCommits.add(nonLocalCommitReq);
        }
        for (i = 0; i < 10; ++i) {
            this.processor.initThreads(this.defaultSizeOfThreadPool);
            this.processor.stoppedMainLoop = true;
            this.processor.run();
        }
        Assertions.assertTrue((boolean)this.processedRequests.containsAll(nonLocalCommits), (String)"commit request was not processed");
    }

    @Test
    public void noStarvationOfReadRequestsTest() throws Exception {
        String path = "/noStarvationOfReadRequests";
        Request firstCommittedReq = this.newRequest((Record)new CreateRequest("/noStarvationOfReadRequests", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL.toFlag()), 1, 3, 1);
        this.processor.queuedRequests.add(firstCommittedReq);
        this.processor.queuedWriteRequests.add(firstCommittedReq);
        this.processor.committedRequests.add(firstCommittedReq);
        HashSet<Request> allReads = new HashSet<Request>();
        Request firstRead = this.newRequest((Record)new GetDataRequest("/noStarvationOfReadRequests", false), 4, 1, 0);
        allReads.add(firstRead);
        this.processor.queuedRequests.add(firstRead);
        Request secondCommittedReq = this.newRequest((Record)new CreateRequest("/noStarvationOfReadRequests", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL.toFlag()), 1, 153, 2);
        this.processor.committedRequests.add(secondCommittedReq);
        HashSet<Request> waitingCommittedRequests = new HashSet<Request>();
        for (int writeReqId = 3; writeReqId < 102; ++writeReqId) {
            Request writeReq = this.newRequest((Record)new CreateRequest("/noStarvationOfReadRequests", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL.toFlag()), 1, 8, writeReqId);
            this.processor.committedRequests.add(writeReq);
            waitingCommittedRequests.add(writeReq);
        }
        for (int readReqId = 1; readReqId <= 50; ++readReqId) {
            Request readReq = this.newRequest((Record)new GetDataRequest("/noStarvationOfReadRequests", false), 4, 5, readReqId);
            allReads.add(readReq);
            this.processor.queuedRequests.add(readReq);
        }
        this.processor.initThreads(this.defaultSizeOfThreadPool);
        this.processor.stoppedMainLoop = true;
        this.processor.run();
        Assertions.assertTrue((boolean)this.processedRequests.contains(firstCommittedReq), (String)"Did not process the first write request");
        for (Request r : allReads) {
            Assertions.assertTrue((!this.processedRequests.contains(r) ? 1 : 0) != 0, (String)"Processed read request");
        }
        this.processor.run();
        Assertions.assertTrue((boolean)this.processedRequests.containsAll(allReads), (String)"did not processed all reads");
        Assertions.assertTrue((boolean)this.processedRequests.contains(secondCommittedReq), (String)"Did not process the second write request");
        for (Request r : waitingCommittedRequests) {
            Assertions.assertTrue((!this.processedRequests.contains(r) ? 1 : 0) != 0, (String)"Processed additional committed request");
        }
    }

    @Test
    @Timeout(value=5L)
    public void noCrashOnCommittedRequestsOfUnseenRequestTest() throws Exception {
        String path = "/noCrash/OnCommittedRequests/OfUnseenRequestTest";
        int numberofReads = 10;
        int sessionid = 1193046;
        int firstCXid = 256;
        int readReqId = 256;
        this.processor.stoppedMainLoop = true;
        HashSet<Request> localRequests = new HashSet<Request>();
        Request firstCommittedReq = this.newRequest((Record)new CreateRequest("/noCrash/OnCommittedRequests/OfUnseenRequestTest", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL.toFlag()), 1, 1193046, readReqId++);
        this.processor.queuedRequests.add(firstCommittedReq);
        this.processor.queuedWriteRequests.add(firstCommittedReq);
        localRequests.add(firstCommittedReq);
        while (readReqId <= 266) {
            Request readReq = this.newRequest((Record)new GetDataRequest("/noCrash/OnCommittedRequests/OfUnseenRequestTest", false), 4, 1193046, readReqId);
            this.processor.queuedRequests.add(readReq);
            localRequests.add(readReq);
            ++readReqId;
        }
        Assertions.assertTrue((boolean)this.processor.queuedRequests.containsAll(localRequests));
        this.processor.initThreads(this.defaultSizeOfThreadPool);
        this.processor.run();
        Thread.sleep(1000L);
        Assertions.assertTrue((boolean)this.processedRequests.isEmpty());
        Request preSessionCommittedReq = this.newRequest((Record)new CreateRequest("/noCrash/OnCommittedRequests/OfUnseenRequestTest", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL.toFlag()), 1, 1193046, 254);
        this.processor.committedRequests.add(preSessionCommittedReq);
        this.processor.committedRequests.add(firstCommittedReq);
        this.processor.run();
        Thread.sleep(1000L);
        Assertions.assertTrue((this.processedRequests.peek() == preSessionCommittedReq ? 1 : 0) != 0);
        this.processor.run();
        Thread.sleep(1000L);
        Assertions.assertTrue((boolean)this.processedRequests.containsAll(localRequests));
    }

    @Test
    @Timeout(value=5L)
    public void noCrashOnOutofOrderCommittedRequestTest() throws Exception {
        String path = "/noCrash/OnCommittedRequests/OfUnSeenRequestTest";
        int sessionid = 1193046;
        int lastCXid = 256;
        int numberofReads = 10;
        this.processor.stoppedMainLoop = true;
        HashSet<Request> localRequests = new HashSet<Request>();
        Request orphanCommittedReq = this.newRequest((Record)new CreateRequest("/noCrash/OnCommittedRequests/OfUnSeenRequestTest", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL.toFlag()), 1, 1193046, 256);
        this.processor.queuedRequests.add(orphanCommittedReq);
        this.processor.queuedWriteRequests.add(orphanCommittedReq);
        localRequests.add(orphanCommittedReq);
        for (int readReqId = 256; readReqId <= 266; ++readReqId) {
            Request readReq = this.newRequest((Record)new GetDataRequest("/noCrash/OnCommittedRequests/OfUnSeenRequestTest", false), 4, 1193046, readReqId);
            this.processor.queuedRequests.add(readReq);
            localRequests.add(readReq);
        }
        this.processor.initThreads(this.defaultSizeOfThreadPool);
        this.processor.run();
        Thread.sleep(1000L);
        Assertions.assertTrue((boolean)this.processedRequests.isEmpty());
        Request otherSessionCommittedReq = this.newRequest((Record)new CreateRequest("/noCrash/OnCommittedRequests/OfUnSeenRequestTest", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL.toFlag()), 1, 1193046, 266);
        this.processor.committedRequests.add(otherSessionCommittedReq);
        this.processor.committedRequests.add(orphanCommittedReq);
        this.processor.run();
        Thread.sleep(1000L);
        Assertions.assertTrue((this.processedRequests.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)this.processedRequests.contains(otherSessionCommittedReq));
        this.processor.run();
        Thread.sleep(1000L);
        Assertions.assertTrue((boolean)this.processedRequests.containsAll(localRequests));
    }

    class MockCommitProcessor
    extends CommitProcessor {
        MockCommitProcessor() {
            super(new RequestProcessor(){

                public void processRequest(Request request) throws RequestProcessor.RequestProcessorException {
                    CommitProcessorConcurrencyTest.this.processedRequests.offer(request);
                }

                public void shutdown() {
                }
            }, "0", false, new ZooKeeperServerListener(){

                public void notifyStopping(String threadName, int errorCode) {
                    Assertions.fail((String)("Commit processor crashed " + errorCode));
                }
            });
        }

        public void initThreads(int poolSize) {
            this.stopped = false;
            this.workerPool = new WorkerService("CommitProcWork", poolSize, true);
        }
    }

    class MockRequestsQueue
    extends LinkedBlockingQueue<Request> {
        private static final long serialVersionUID = 1L;
        int readReqId = 0;

        MockRequestsQueue() {
        }

        @Override
        public Request poll() {
            ++this.readReqId;
            try {
                return CommitProcessorConcurrencyTest.this.newRequest((Record)new GetDataRequest("/", false), 4, this.readReqId % 50, this.readReqId);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public int size() {
            return 42;
        }
    }
}

