/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.source.feature;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.util.Elements;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.QualifiedName;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.processor.source.feature.Feature;
import org.inferred.freebuilder.processor.source.feature.FeatureSet;
import org.inferred.freebuilder.processor.source.feature.FeatureType;

public enum Jsr305 implements Feature<Jsr305>
{
    AVAILABLE("JSR 305"),
    UNAVAILABLE("No JSR 305");

    public static final FeatureType<Jsr305> JSR305;
    private static final QualifiedName NULLABLE;
    private final String humanReadableFormat;

    public static Excerpt nullable() {
        return new NullableExcerpt();
    }

    private Jsr305(String humanReadableFormat) {
        this.humanReadableFormat = humanReadableFormat;
    }

    public String toString() {
        return this.humanReadableFormat;
    }

    private static boolean hasType(Elements elements, QualifiedName type) {
        try {
            return elements.getTypeElement(type.toString()) != null;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    static {
        JSR305 = new FeatureType<Jsr305>(){

            @Override
            protected Jsr305 testDefault(FeatureSet features) {
                return UNAVAILABLE;
            }

            @Override
            protected Jsr305 forEnvironment(ProcessingEnvironment env, FeatureSet features) {
                return Jsr305.hasType(env.getElementUtils(), NULLABLE) ? AVAILABLE : UNAVAILABLE;
            }
        };
        NULLABLE = QualifiedName.of("javax.annotation", "Nullable", new String[0]);
    }

    private static class NullableExcerpt
    implements Excerpt {
        private NullableExcerpt() {
        }

        @Override
        public void addTo(SourceBuilder source) {
            switch (source.feature(JSR305)) {
                case AVAILABLE: {
                    source.add("@%s", NULLABLE);
                    break;
                }
            }
        }

        public String toString() {
            return "@Nullable";
        }
    }
}

