/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.DummyWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.ClientTest;
import org.apache.zookeeper.test.DisconnectableZooKeeper;
import org.apache.zookeeper.test.QuorumBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumTest.class);
    public static final long CONNECTION_TIMEOUT = ClientTest.CONNECTION_TIMEOUT;
    private final QuorumBase qb = new QuorumBase();
    private final ClientTest ct = new ClientTest();
    private QuorumUtil qu;
    volatile int counter = 0;
    volatile int errors = 0;

    @BeforeEach
    public void setUp() throws Exception {
        this.qb.setUp();
        this.ct.hostPort = this.qb.hostPort;
        this.ct.setUpAll();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.ct.tearDownAll();
        this.qb.tearDown();
        if (this.qu != null) {
            this.qu.tearDown();
        }
    }

    @Test
    public void testDeleteWithChildren() throws Exception {
        this.ct.testDeleteWithChildren();
    }

    @Test
    public void testPing() throws Exception {
        this.ct.testPing();
    }

    @Test
    public void testSequentialNodeNames() throws IOException, InterruptedException, KeeperException {
        this.ct.testSequentialNodeNames();
    }

    @Test
    public void testACLs() throws Exception {
        this.ct.testACLs();
    }

    @Test
    public void testClientwithoutWatcherObj() throws IOException, InterruptedException, KeeperException {
        this.ct.testClientwithoutWatcherObj();
    }

    @Test
    public void testClientWithWatcherObj() throws IOException, InterruptedException, KeeperException {
        this.ct.testClientWithWatcherObj();
    }

    @Test
    public void testGetView() {
        Assertions.assertEquals((int)5, (int)this.qb.s1.getView().size());
        Assertions.assertEquals((int)5, (int)this.qb.s2.getView().size());
        Assertions.assertEquals((int)5, (int)this.qb.s3.getView().size());
        Assertions.assertEquals((int)5, (int)this.qb.s4.getView().size());
        Assertions.assertEquals((int)5, (int)this.qb.s5.getView().size());
    }

    @Test
    public void testViewContains() {
        Assertions.assertTrue((boolean)this.qb.s1.viewContains(Long.valueOf(this.qb.s1.getId())));
        Assertions.assertTrue((boolean)this.qb.s1.viewContains(Long.valueOf(this.qb.s2.getId())));
        Assertions.assertFalse((boolean)this.qb.s1.viewContains(Long.valueOf(-1L)));
    }

    @Test
    public void testLeaderShutdown() throws IOException, InterruptedException, KeeperException {
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper(this.qb.hostPort, ClientBase.CONNECTION_TIMEOUT, DummyWatcher.INSTANCE);
        zk.create("/blah", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/blah/blah", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Leader leader = this.qb.s1.leader;
        if (leader == null) {
            leader = this.qb.s2.leader;
        }
        if (leader == null) {
            leader = this.qb.s3.leader;
        }
        if (leader == null) {
            leader = this.qb.s4.leader;
        }
        if (leader == null) {
            leader = this.qb.s5.leader;
        }
        Assertions.assertNotNull((Object)leader);
        for (int i = 0; i < 5000; ++i) {
            zk.setData("/blah/blah", new byte[0], -1, (rc, path, ctx, stat) -> {
                ++this.counter;
                if (rc != 0) {
                    ++this.errors;
                }
            }, null);
        }
        for (LearnerHandler f : leader.getForwardingFollowers()) {
            f.getSocket().shutdownInput();
        }
        for (int i = 0; i < 5000; ++i) {
            zk.setData("/blah/blah", new byte[0], -1, (rc, path, ctx, stat) -> {
                ++this.counter;
                if (rc != 0) {
                    ++this.errors;
                }
            }, null);
        }
        Assertions.assertTrue((boolean)this.qb.s1.isAlive());
        Assertions.assertTrue((boolean)this.qb.s2.isAlive());
        Assertions.assertTrue((boolean)this.qb.s3.isAlive());
        Assertions.assertTrue((boolean)this.qb.s4.isAlive());
        Assertions.assertTrue((boolean)this.qb.s5.isAlive());
        zk.close();
    }

    @Test
    public void testMultipleWatcherObjs() throws IOException, InterruptedException, KeeperException {
        this.ct.testMutipleWatcherObjs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Test
    public void testSessionMoved() throws Exception {
        String[] hostPorts = this.qb.hostPort.split(",");
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper(hostPorts[0], ClientBase.CONNECTION_TIMEOUT, DummyWatcher.INSTANCE);
        zk.create("/sessionMoveTest", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        int i = 0;
        while (true) {
            if (i >= hostPorts.length * 2) {
                zk.close();
                return;
            }
            zk.dontReconnect();
            DisconnectableZooKeeper zknew = new DisconnectableZooKeeper(hostPorts[(i + 1) % hostPorts.length], ClientBase.CONNECTION_TIMEOUT, DummyWatcher.INSTANCE, zk.getSessionId(), zk.getSessionPasswd());
            zknew.setData("/", new byte[1], -1);
            int[] result = new int[]{Integer.MAX_VALUE};
            zknew.sync("/", (rc, path, ctx) -> {
                int[] nArray = result;
                synchronized (result) {
                    result[0] = rc;
                    result.notify();
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
            }, null);
            int[] nArray = result;
            // MONITORENTER : result
            if (result[0] == Integer.MAX_VALUE) {
                result.wait(5000L);
            }
            // MONITOREXIT : nArray
            LOG.info("{} Sync returned {}", (Object)hostPorts[(i + 1) % hostPorts.length], (Object)result[0]);
            Assertions.assertTrue((result[0] == KeeperException.Code.OK.intValue() ? 1 : 0) != 0);
            try {
                zk.setData("/", new byte[1], -1);
                Assertions.fail((String)"Should have lost the connection");
            }
            catch (KeeperException.ConnectionLossException connectionLossException) {
                // empty catch block
            }
            zk = zknew;
            ++i;
        }
    }

    @Test
    public void testSessionMovedWithMultiOp() throws Exception {
        String[] hostPorts = this.qb.hostPort.split(",");
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper(hostPorts[0], ClientBase.CONNECTION_TIMEOUT, DummyWatcher.INSTANCE);
        zk.multi(Arrays.asList(Op.create((String)"/testSessionMovedWithMultiOp", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.EPHEMERAL)));
        ZooKeeper zknew = new ZooKeeper(hostPorts[1], ClientBase.CONNECTION_TIMEOUT, (Watcher)DummyWatcher.INSTANCE, zk.getSessionId(), zk.getSessionPasswd());
        zknew.multi(Arrays.asList(Op.create((String)"/testSessionMovedWithMultiOp-1", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.EPHEMERAL)));
        try {
            zk.multi(Arrays.asList(Op.create((String)"/testSessionMovedWithMultiOp-Failed", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.EPHEMERAL)));
            Assertions.fail((String)"Should have lost the connection");
        }
        catch (KeeperException.ConnectionLossException connectionLossException) {
            // empty catch block
        }
        zk.close();
        zknew.close();
    }

    @Test
    @Disabled
    public void testSessionMove() throws Exception {
        int i;
        String[] hps = this.qb.hostPort.split(",");
        DiscoWatcher oldWatcher = new DiscoWatcher();
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper(hps[0], ClientBase.CONNECTION_TIMEOUT, oldWatcher);
        zk.create("/t1", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        zk.dontReconnect();
        DiscoWatcher watcher = new DiscoWatcher();
        DisconnectableZooKeeper zknew = new DisconnectableZooKeeper(hps[1], ClientBase.CONNECTION_TIMEOUT, watcher, zk.getSessionId(), zk.getSessionPasswd());
        zknew.create("/t2", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        try {
            zk.create("/t3", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            Assertions.fail((String)"Should have lost the connection");
        }
        catch (KeeperException.ConnectionLossException e) {
            for (i = 0; i < 30 && !oldWatcher.zkDisco; ++i) {
                Thread.sleep(1000L);
            }
            Assertions.assertTrue((boolean)oldWatcher.zkDisco);
        }
        ArrayList<DisconnectableZooKeeper> toClose = new ArrayList<DisconnectableZooKeeper>();
        toClose.add(zknew);
        for (i = 0; i < 10; ++i) {
            zknew.dontReconnect();
            zknew = new DisconnectableZooKeeper(hps[1], ClientBase.CONNECTION_TIMEOUT, new DiscoWatcher(), zk.getSessionId(), zk.getSessionPasswd());
            toClose.add(zknew);
            zknew.create("/t-" + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        for (ZooKeeper zooKeeper : toClose) {
            zooKeeper.close();
        }
        zk.close();
    }

    @Test
    public void testFollowersStartAfterLeader() throws Exception {
        this.qu = new QuorumUtil(1);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        this.qu.startQuorum();
        int index = 1;
        while (this.qu.getPeer((int)index).peer.leader == null) {
            ++index;
        }
        this.qu.shutdown(index);
        this.qu.start(index);
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + this.qu.getPeer((int)(index == 1 ? 2 : 1)).peer.getClientPort(), ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        try {
            watcher.waitForConnected(CONNECTION_TIMEOUT);
        }
        catch (TimeoutException e) {
            Assertions.fail((String)"client could not connect to reestablished quorum: giving up after 30+ seconds.");
        }
        zk.close();
    }

    @Test
    public void testMultiToFollower() throws Exception {
        this.qu = new QuorumUtil(1);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        this.qu.startQuorum();
        int index = 1;
        while (this.qu.getPeer((int)index).peer.leader == null) {
            ++index;
        }
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + this.qu.getPeer((int)(index == 1 ? 2 : 1)).peer.getClientPort(), ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        zk.multi(Arrays.asList(Op.create((String)"/multi0", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi1", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi2", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT)));
        zk.getData("/multi0", false, null);
        zk.getData("/multi1", false, null);
        zk.getData("/multi2", false, null);
        zk.close();
    }

    private static class DiscoWatcher
    implements Watcher {
        volatile boolean zkDisco = false;

        private DiscoWatcher() {
        }

        public void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.Disconnected) {
                this.zkDisco = true;
            }
        }
    }
}

